/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts.audio;

import com.sun.speech.freetts.audio.AudioPlayer;
import com.sun.speech.freetts.util.Utilities;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;

public class RawFileAudioPlayer
implements AudioPlayer {
    private AudioFormat audioFormat;
    private float volume;
    private BufferedOutputStream os;
    private String path;

    public RawFileAudioPlayer() throws IOException {
        this(Utilities.getProperty("com.sun.speech.freetts.AudioPlayer.baseName", "freetts") + ".raw");
    }

    public RawFileAudioPlayer(String path) throws IOException {
        this.path = path;
        this.os = new BufferedOutputStream(new FileOutputStream(path));
    }

    @Override
    public void setAudioFormat(AudioFormat format) {
        this.audioFormat = format;
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void reset() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void close() {
        try {
            this.os.flush();
            this.os.close();
            System.out.println("Wrote synthesized speech to " + this.path);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public float getVolume() {
        return this.volume;
    }

    @Override
    public void setVolume(float volume) {
        this.volume = volume;
    }

    @Override
    public boolean write(byte[] audioData) {
        return this.write(audioData, 0, audioData.length);
    }

    @Override
    public void begin(int size) {
    }

    @Override
    public boolean end() {
        return true;
    }

    @Override
    public boolean write(byte[] bytes, int offset, int size) {
        try {
            this.os.write(bytes, offset, size);
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    @Override
    public void startFirstSampleTimer() {
    }

    @Override
    public boolean drain() {
        return true;
    }

    @Override
    public long getTime() {
        return -1L;
    }

    @Override
    public void resetTime() {
    }

    @Override
    public void showMetrics() {
    }
}

