/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.ArrayList;
import java.util.Iterator;
import org.altusmetrum.altoslib_14.AltosTimeValue;
import org.altusmetrum.altoslib_14.AltosUnits;

public class AltosTimeSeries
implements Iterable<AltosTimeValue>,
Comparable<AltosTimeSeries> {
    public String label;
    public AltosUnits units;
    ArrayList<AltosTimeValue> values;
    boolean data_changed;
    double min_time = -2.0;

    @Override
    public int compareTo(AltosTimeSeries altosTimeSeries) {
        return this.label.compareTo(altosTimeSeries.label);
    }

    public void add(AltosTimeValue altosTimeValue) {
        if (altosTimeValue.time >= this.min_time) {
            this.data_changed = true;
            this.values.add(altosTimeValue);
        }
    }

    public void erase_values() {
        this.data_changed = true;
        this.values = new ArrayList();
    }

    public void clear_changed() {
        this.data_changed = false;
    }

    public void add(double d, double d2) {
        this.add(new AltosTimeValue(d, d2));
    }

    public AltosTimeValue get(int n) {
        return this.values.get(n);
    }

    private double lerp(AltosTimeValue altosTimeValue, AltosTimeValue altosTimeValue2, double d) {
        if (altosTimeValue.time == altosTimeValue2.time) {
            return (altosTimeValue.value + altosTimeValue2.value) / 2.0;
        }
        return (altosTimeValue.value * (altosTimeValue2.time - d) + altosTimeValue2.value * (d - altosTimeValue.time)) / (altosTimeValue2.time - altosTimeValue.time);
    }

    private int after_index(double d) {
        int n = 0;
        int n2 = this.values.size() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            if (this.values.get((int)n3).time < d) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return n;
    }

    public double value(double d) {
        double d2;
        int n = this.after_index(d);
        if (n == 0) {
            d2 = this.values.get((int)0).value;
        } else if (n == this.values.size()) {
            d2 = this.values.get((int)(n - 1)).value;
        } else {
            AltosTimeValue altosTimeValue = this.values.get(n - 1);
            AltosTimeValue altosTimeValue2 = this.values.get(n);
            d2 = this.lerp(altosTimeValue, altosTimeValue2, d);
        }
        return d2;
    }

    public double value_before(double d) {
        int n = this.after_index(d);
        if (n == 0) {
            return this.values.get((int)0).value;
        }
        return this.values.get((int)(n - 1)).value;
    }

    public double value_after(double d) {
        int n = this.after_index(d);
        if (n == this.values.size()) {
            return this.values.get((int)(n - 1)).value;
        }
        return this.values.get((int)n).value;
    }

    public double time_of(double d) {
        double d2 = 2.147483647E9;
        for (AltosTimeValue altosTimeValue : this.values) {
            if (altosTimeValue.value >= d) {
                return altosTimeValue.time;
            }
            d2 = altosTimeValue.time;
        }
        return d2;
    }

    public int size() {
        return this.values.size();
    }

    @Override
    public Iterator<AltosTimeValue> iterator() {
        return this.values.iterator();
    }

    public AltosTimeValue max() {
        AltosTimeValue altosTimeValue = null;
        for (AltosTimeValue altosTimeValue2 : this.values) {
            if (altosTimeValue != null && !(altosTimeValue2.value > altosTimeValue.value)) continue;
            altosTimeValue = altosTimeValue2;
        }
        return altosTimeValue;
    }

    public AltosTimeValue max(double d, double d2) {
        AltosTimeValue altosTimeValue = null;
        for (AltosTimeValue altosTimeValue2 : this.values) {
            if (!(d <= altosTimeValue2.time) || !(altosTimeValue2.time <= d2) || altosTimeValue != null && !(altosTimeValue2.value > altosTimeValue.value)) continue;
            altosTimeValue = altosTimeValue2;
        }
        return altosTimeValue;
    }

    public AltosTimeValue min() {
        AltosTimeValue altosTimeValue = null;
        for (AltosTimeValue altosTimeValue2 : this.values) {
            if (altosTimeValue != null && !(altosTimeValue2.value < altosTimeValue.value)) continue;
            altosTimeValue = altosTimeValue2;
        }
        return altosTimeValue;
    }

    public AltosTimeValue min(double d, double d2) {
        AltosTimeValue altosTimeValue = null;
        for (AltosTimeValue altosTimeValue2 : this.values) {
            if (!(d <= altosTimeValue2.time) || !(altosTimeValue2.time <= d2) || altosTimeValue != null && !(altosTimeValue2.value < altosTimeValue.value)) continue;
            altosTimeValue = altosTimeValue2;
        }
        return altosTimeValue;
    }

    public AltosTimeValue first() {
        if (this.values.size() > 0) {
            return this.values.get(0);
        }
        return null;
    }

    public AltosTimeValue last() {
        if (this.values.size() > 0) {
            return this.values.get(this.values.size() - 1);
        }
        return null;
    }

    public double average() {
        double d = 0.0;
        double d2 = 0.0;
        AltosTimeValue altosTimeValue = null;
        for (AltosTimeValue altosTimeValue2 : this.values) {
            if (altosTimeValue != null) {
                d += (altosTimeValue2.value + altosTimeValue.value) / 2.0 * (altosTimeValue2.time - altosTimeValue.time);
                d2 += altosTimeValue2.time - altosTimeValue.time;
            }
            altosTimeValue = altosTimeValue2;
        }
        if (d2 == 0.0) {
            return 2.147483647E9;
        }
        return d / d2;
    }

    public double average(double d, double d2) {
        double d3 = 0.0;
        double d4 = 0.0;
        AltosTimeValue altosTimeValue = null;
        for (AltosTimeValue altosTimeValue2 : this.values) {
            if (d <= altosTimeValue2.time && altosTimeValue2.time <= d2) {
                if (altosTimeValue != null) {
                    d3 += (altosTimeValue2.value + altosTimeValue.value) / 2.0 * (altosTimeValue2.time - d);
                    d4 += altosTimeValue2.time - d;
                }
                d = altosTimeValue2.time;
            }
            altosTimeValue = altosTimeValue2;
        }
        if (d4 == 0.0) {
            return 2.147483647E9;
        }
        return d3 / d4;
    }

    public AltosTimeSeries integrate(AltosTimeSeries altosTimeSeries) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        boolean bl = true;
        for (AltosTimeValue altosTimeValue : this.values) {
            if (bl) {
                d = 0.0;
                bl = false;
            } else {
                d += (d2 + altosTimeValue.value) / 2.0 * (altosTimeValue.time - d3);
            }
            d2 = altosTimeValue.value;
            d3 = altosTimeValue.time;
            altosTimeSeries.add(d3, d);
        }
        return altosTimeSeries;
    }

    public AltosTimeSeries differentiate(AltosTimeSeries altosTimeSeries) {
        double d = 0.0;
        double d2 = 0.0;
        boolean bl = true;
        for (AltosTimeValue altosTimeValue : this.values) {
            if (bl) {
                d = altosTimeValue.value;
                d2 = altosTimeValue.time;
                bl = false;
                continue;
            }
            double d3 = altosTimeValue.time - d2;
            double d4 = altosTimeValue.value - d;
            if (d3 != 0.0) {
                altosTimeSeries.add(d2, d4 / d3);
            }
            d2 = altosTimeValue.time;
            d = altosTimeValue.value;
        }
        return altosTimeSeries;
    }

    private int find_left(int n, double d) {
        int n2;
        double d2 = this.values.get((int)n).time - d;
        for (n2 = n; n2 >= 0 && !(this.values.get((int)n2).time < d2); --n2) {
        }
        return n2 + 1;
    }

    private int find_right(int n, double d) {
        int n2;
        double d2 = this.values.get((int)n).time + d;
        for (n2 = n; n2 < this.values.size() && !(this.values.get((int)n2).time > d2); ++n2) {
        }
        return n2 - 1;
    }

    private static double i0(double d) {
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        while ((d2 = d2 * (d * d) / ((d3 += 2.0) * d3)) - 2.0E-9 * (d4 += d2) > 0.0) {
        }
        return d4;
    }

    private static double kaiser(double d, double d2, double d3) {
        double d4 = d2 / 2.0;
        double d5 = (d - d4) / d4;
        if (d5 > 1.0 || d5 < -1.0) {
            d5 = 1.0;
        }
        double d6 = AltosTimeSeries.i0(d3 * Math.sqrt(1.0 - d5 * d5)) / AltosTimeSeries.i0(d3);
        return d6;
    }

    private double filter_coeff(double d, double d2) {
        return AltosTimeSeries.kaiser(d + d2 / 2.0, d2, Math.PI * 2);
    }

    public AltosTimeSeries filter(AltosTimeSeries altosTimeSeries, double d) {
        double d2 = d / 2.0;
        int n = this.values.size() / 2;
        for (int i = 0; i < this.values.size(); ++i) {
            double d3 = this.values.get((int)i).time;
            double d4 = d3 - d2;
            double d5 = d3 + d2;
            double d6 = 0.0;
            double d7 = 0.0;
            int n2 = this.find_left(i, d2);
            int n3 = this.find_right(i, d2);
            for (int j = n2; j <= n3; ++j) {
                double d8 = this.values.get((int)j).time;
                if (!(d4 <= d8) || !(d8 <= d5)) continue;
                double d9 = j == n2 ? d4 : this.values.get((int)(j - 1)).time;
                double d10 = j == n3 ? d5 : this.values.get((int)(j + 1)).time;
                double d11 = (d10 - d9) / 2.0;
                double d12 = this.filter_coeff(d8 - d3, d) * d11;
                double d13 = this.values.get((int)j).value;
                double d14 = d13 * d12;
                d6 += d12;
                d7 += d14;
            }
            if (d6 == 0.0) continue;
            altosTimeSeries.add(d3, d7 / d6);
        }
        return altosTimeSeries;
    }

    public AltosTimeSeries clip(AltosTimeSeries altosTimeSeries, double d, double d2) {
        for (AltosTimeValue altosTimeValue : this.values) {
            double d3 = altosTimeValue.value;
            if (d3 < d) {
                d3 = d;
            }
            if (d3 > d2) {
                d3 = d2;
            }
            altosTimeSeries.add(altosTimeValue.time, d3);
        }
        return altosTimeSeries;
    }

    public AltosTimeSeries(String string, AltosUnits altosUnits) {
        this.label = string;
        this.units = altosUnits;
        this.values = new ArrayList();
    }
}

