/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosLink;

class AltosSensorEasyMotor2 {
    int tick;
    int v_batt;
    int motor_pressure;

    public AltosSensorEasyMotor2(AltosLink altosLink) throws InterruptedException, TimeoutException {
        String[] stringArray = altosLink.adc();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("tick:")) {
                this.tick = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("motor_pressure:")) {
                this.motor_pressure = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (stringArray[n].equals("batt:")) {
                this.v_batt = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            ++n;
        }
    }

    public static void provide_data(AltosDataListener altosDataListener, AltosLink altosLink) throws InterruptedException {
        try {
            AltosSensorEasyMotor2 altosSensorEasyMotor2 = new AltosSensorEasyMotor2(altosLink);
            altosDataListener.set_battery_voltage(AltosConvert.easy_mini_2_voltage(altosSensorEasyMotor2.v_batt));
            double d = AltosConvert.easy_motor_2_motor_pressure(altosSensorEasyMotor2.motor_pressure, altosDataListener.cal_data().ground_motor_pressure);
            altosDataListener.set_motor_pressure(d);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }
}

