/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.concurrent.Semaphore;
import org.altusmetrum.altoslib_14.AltosCompanion;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosRecordSet;
import org.altusmetrum.altoslib_14.AltosState;

class AltosReplay
extends AltosDataListener
implements Runnable {
    AltosState state;
    AltosRecordSet record_set;
    double last_time = 2.147483647E9;
    Semaphore semaphore = new Semaphore(1);
    boolean done = false;

    @Override
    public void set_time(double d) {
        if (d > -2.0 && this.last_time != 2.147483647E9) {
            this.semaphore.release();
            double d2 = Math.min(d - this.last_time, 10.0);
            if (d2 > 0.0) {
                try {
                    Thread.sleep((int)(d2 * 1000.0));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.last_time = d;
        super.set_time(d);
        this.state.set_time(d);
    }

    @Override
    public void set_state(int n) {
        super.set_state(n);
        this.state.set_state(n);
    }

    @Override
    public void set_rssi(int n, int n2) {
        this.state.set_rssi(n, n2);
    }

    @Override
    public void set_received_time(long l) {
    }

    @Override
    public void set_acceleration(double d) {
        this.state.set_acceleration(d);
    }

    @Override
    public void set_pressure(double d) {
        this.state.set_pressure(d);
    }

    @Override
    public void set_thrust(double d) {
        this.state.set_thrust(d);
    }

    @Override
    public void set_kalman(double d, double d2, double d3) {
        this.state.set_kalman(d, d2, d3);
    }

    @Override
    public void set_temperature(double d) {
        this.state.set_temperature(d);
    }

    @Override
    public void set_battery_voltage(double d) {
        this.state.set_battery_voltage(d);
    }

    @Override
    public void set_apogee_voltage(double d) {
        this.state.set_apogee_voltage(d);
    }

    @Override
    public void set_main_voltage(double d) {
        this.state.set_main_voltage(d);
    }

    @Override
    public void set_gps(AltosGPS altosGPS, boolean bl, boolean bl2) {
        super.set_gps(altosGPS, bl, bl2);
        this.state.set_gps(altosGPS, bl, bl2);
    }

    @Override
    public void set_orient(double d) {
        this.state.set_orient(d);
    }

    @Override
    public void set_gyro(double d, double d2, double d3) {
        this.state.set_gyro(d, d2, d3);
    }

    @Override
    public void set_accel_ground(double d, double d2, double d3) {
        this.state.set_accel_ground(d, d2, d3);
    }

    @Override
    public void set_accel(double d, double d2, double d3) {
        this.state.set_accel(d, d2, d3);
    }

    @Override
    public void set_mag(double d, double d2, double d3) {
        this.state.set_mag(d, d2, d3);
    }

    @Override
    public void set_pyro_voltage(double d) {
        this.state.set_pyro_voltage(d);
    }

    @Override
    public void set_igniter_voltage(double[] dArray) {
        this.state.set_igniter_voltage(dArray);
    }

    @Override
    public void set_pyro_fired(int n) {
        this.state.set_pyro_fired(n);
    }

    @Override
    public void set_companion(AltosCompanion altosCompanion) {
        this.state.set_companion(altosCompanion);
    }

    @Override
    public void set_motor_pressure(double d) {
        this.state.set_motor_pressure(d);
    }

    @Override
    public void run() {
        this.record_set.capture_series(this);
        this.done = true;
        this.semaphore.release();
    }

    public AltosReplay(AltosRecordSet altosRecordSet) {
        super(altosRecordSet.cal_data());
        this.state = new AltosState(altosRecordSet.cal_data());
        this.record_set = altosRecordSet;
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

