/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConfigData;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosPresTemp;

public class AltosMs5607 {
    public int reserved = Integer.MAX_VALUE;
    public int sens = Integer.MAX_VALUE;
    public int off = Integer.MAX_VALUE;
    public int tcs = Integer.MAX_VALUE;
    public int tco = Integer.MAX_VALUE;
    public int tref = Integer.MAX_VALUE;
    public int tempsens = Integer.MAX_VALUE;
    public int crc = Integer.MAX_VALUE;
    private boolean ms5611 = false;

    public boolean valid_config() {
        return this.reserved != Integer.MAX_VALUE && this.sens != Integer.MAX_VALUE && this.off != Integer.MAX_VALUE && this.tcs != Integer.MAX_VALUE && this.tco != Integer.MAX_VALUE && this.tref != Integer.MAX_VALUE && this.tempsens != Integer.MAX_VALUE && this.crc != Integer.MAX_VALUE;
    }

    public AltosPresTemp pres_temp(int n, int n2) {
        long l;
        long l2;
        if (n == Integer.MAX_VALUE || n2 == Integer.MAX_VALUE) {
            return new AltosPresTemp(2.147483647E9, 2.147483647E9);
        }
        int n3 = n2 - (this.tref << 8);
        int n4 = (int)(2000L + ((long)n3 * (long)this.tempsens >> 23));
        if (this.ms5611) {
            l2 = ((long)this.off << 16) + ((long)this.tco * (long)n3 >> 7);
            l = ((long)this.sens << 15) + ((long)this.tcs * (long)n3 >> 8);
        } else {
            l2 = ((long)this.off << 17) + ((long)this.tco * (long)n3 >> 6);
            l = ((long)this.sens << 16) + ((long)this.tcs * (long)n3 >> 7);
        }
        if (n4 < 2000) {
            int n5 = (int)((long)n3 * (long)n3 >> 31);
            int n6 = n4 - 2000;
            long l3 = 61L * (long)n6 * (long)n6 >> 4;
            long l4 = 2L * (long)n6 * (long)n6;
            if (n4 < -1500) {
                int n7 = n4 + 1500;
                long l5 = (long)n7 * (long)n7;
                l3 += 15L * l5;
                l4 += 8L * l5;
            }
            n4 -= n5;
            l2 -= l3;
            l -= l4;
        }
        int n8 = (int)(((long)n * l >> 21) - l2 >> 15);
        return new AltosPresTemp(n8, (double)n4 / 100.0);
    }

    public AltosPresTemp pres_temp(AltosLink altosLink) throws InterruptedException, TimeoutException {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        boolean bl = false;
        altosLink.printf("B\n", new Object[0]);
        while (!bl) {
            String string = altosLink.get_reply_no_dialog(5000);
            if (string == null) {
                throw new TimeoutException();
            }
            String[] stringArray = string.split("\\s+");
            if (string.startsWith("Pressure:")) {
                if (stringArray.length < 2) continue;
                n = Integer.parseInt(stringArray[1]);
                continue;
            }
            if (string.startsWith("Temperature:")) {
                if (stringArray.length < 2) continue;
                n2 = Integer.parseInt(stringArray[1]);
                continue;
            }
            if (!string.startsWith("Altitude:")) continue;
            bl = true;
        }
        return this.pres_temp(n, n2);
    }

    public AltosMs5607(boolean bl) {
        this.ms5611 = bl;
    }

    public AltosMs5607() {
        this(false);
    }

    public AltosMs5607(AltosMs5607 altosMs5607) {
        this.reserved = altosMs5607.reserved;
        this.sens = altosMs5607.sens;
        this.off = altosMs5607.off;
        this.tcs = altosMs5607.tcs;
        this.tco = altosMs5607.tco;
        this.tref = altosMs5607.tref;
        this.tempsens = altosMs5607.tempsens;
        this.crc = altosMs5607.crc;
    }

    public static void provide_data(AltosDataListener altosDataListener, AltosLink altosLink) throws InterruptedException {
        try {
            AltosCalData altosCalData = altosDataListener.cal_data();
            AltosMs5607 altosMs5607 = altosCalData.ms5607;
            if (altosMs5607 != null) {
                AltosPresTemp altosPresTemp = altosMs5607.pres_temp(altosLink);
                altosDataListener.set_temperature(altosPresTemp.temp);
                altosDataListener.set_pressure(altosPresTemp.pres);
            }
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public AltosMs5607(AltosConfigData altosConfigData) {
        this(altosConfigData.ms5607());
    }

    public AltosMs5607(AltosLink altosLink, AltosConfigData altosConfigData) throws InterruptedException, TimeoutException {
        this(altosConfigData);
    }
}

