/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosLatLon;
import org.altusmetrum.altoslib_14.AltosMapRectangle;
import org.altusmetrum.altoslib_14.AltosPointDouble;
import org.altusmetrum.altoslib_14.AltosPointInt;
import org.altusmetrum.altoslib_14.AltosRectangle;

public class AltosMapTransform {
    double scale_x;
    double scale_y;
    double offset_x;
    double offset_y;
    int width;
    int height;
    private boolean has_location;

    public AltosLatLon lat_lon(AltosPointDouble altosPointDouble) {
        double d = altosPointDouble.x / this.scale_x;
        double d2 = 2.0 * Math.atan(Math.exp(-altosPointDouble.y / this.scale_y));
        double d3 = Math.toDegrees(d2 - 1.5707963267948966);
        return new AltosLatLon(d3, d);
    }

    public AltosLatLon lat_lon(AltosPointInt altosPointInt) {
        return this.lat_lon(new AltosPointDouble(altosPointInt.x, altosPointInt.y));
    }

    public AltosPointDouble screen_point(AltosPointInt altosPointInt) {
        return new AltosPointDouble((double)altosPointInt.x + this.offset_x, (double)altosPointInt.y + this.offset_y);
    }

    public AltosPointDouble screen_point(AltosPointDouble altosPointDouble) {
        return new AltosPointDouble(altosPointDouble.x + this.offset_x, altosPointDouble.y + this.offset_y);
    }

    public double hypot(AltosLatLon altosLatLon, AltosLatLon altosLatLon2) {
        AltosPointDouble altosPointDouble = this.point(altosLatLon);
        AltosPointDouble altosPointDouble2 = this.point(altosLatLon2);
        return Math.hypot(altosPointDouble.x - altosPointDouble2.x, altosPointDouble.y - altosPointDouble2.y);
    }

    public AltosLatLon screen_lat_lon(AltosPointInt altosPointInt) {
        return this.lat_lon(this.screen_point(altosPointInt));
    }

    public AltosLatLon screen_lat_lon(AltosPointDouble altosPointDouble) {
        return this.lat_lon(this.screen_point(altosPointDouble));
    }

    public AltosPointDouble point(double d, double d2) {
        double d3 = d2 * this.scale_x;
        double d4 = Math.sin(Math.toRadians(d));
        d4 = Math.max(d4, -0.999999999999999);
        d4 = Math.min(d4, 0.999999999999999);
        double d5 = 0.5 * Math.log((1.0 + d4) / (1.0 - d4)) * -this.scale_y;
        return new AltosPointDouble(d3, d5);
    }

    public AltosPointDouble point(AltosLatLon altosLatLon) {
        return this.point(altosLatLon.lat, altosLatLon.lon);
    }

    public AltosPointDouble screen(AltosPointDouble altosPointDouble) {
        return new AltosPointDouble(altosPointDouble.x - this.offset_x, altosPointDouble.y - this.offset_y);
    }

    public AltosPointInt screen(AltosPointInt altosPointInt) {
        return new AltosPointInt((int)((double)altosPointInt.x - this.offset_x + 0.5), (int)((double)altosPointInt.y - this.offset_y + 0.5));
    }

    public AltosRectangle screen(AltosMapRectangle altosMapRectangle) {
        AltosPointDouble altosPointDouble = this.screen(altosMapRectangle.ul);
        AltosPointDouble altosPointDouble2 = this.screen(altosMapRectangle.lr);
        return new AltosRectangle((int)altosPointDouble.x, (int)altosPointDouble.y, (int)(altosPointDouble2.x - altosPointDouble.x), (int)(altosPointDouble2.y - altosPointDouble.y));
    }

    public AltosPointDouble screen(AltosLatLon altosLatLon) {
        return this.screen(this.point(altosLatLon));
    }

    public AltosPointDouble screen(double d, double d2) {
        return this.screen(this.point(d, d2));
    }

    public double first_lon(double d) {
        double d2;
        while (!((d2 = d * this.scale_x - this.offset_x) < 0.0)) {
            d -= 360.0;
        }
        while (!((d2 = d * this.scale_x - this.offset_x) >= 0.0)) {
            d += 360.0;
        }
        return d;
    }

    public double last_lon(double d) {
        double d2;
        double d3;
        d = this.first_lon(d);
        while (!((d3 = (d2 = d + 360.0) * this.scale_x - this.offset_x) >= (double)this.width)) {
            d = d2;
        }
        return d;
    }

    public boolean has_location() {
        return this.has_location;
    }

    public AltosMapTransform(int n, int n2, int n3, AltosLatLon altosLatLon) {
        this.scale_x = 0.7111111111111111 * Math.pow(2.0, n3);
        this.scale_y = 40.74366543152521 * Math.pow(2.0, n3);
        this.width = n;
        this.height = n2;
        AltosPointDouble altosPointDouble = this.point(altosLatLon);
        this.has_location = altosLatLon.lat != 0.0 || altosLatLon.lon != 0.0;
        this.offset_x = altosPointDouble.x - (double)n / 2.0;
        this.offset_y = altosPointDouble.y - (double)n2 / 2.0;
    }

    public static double lon_from_distance(double d, double d2) {
        double d3 = 6371200.0 * Math.cos(d * Math.PI / 180.0) * 2.0 * Math.PI;
        if (d3 < 10.0) {
            return 0.0;
        }
        return d2 / d3 * 360.0;
    }
}

