/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosDataProvider;
import org.altusmetrum.altoslib_14.AltosEeprom;
import org.altusmetrum.altoslib_14.AltosEepromRecord;

public class AltosEepromRecordTiny
extends AltosEepromRecord
implements AltosDataProvider {
    public static final int record_length = 2;

    private int value() {
        return this.eeprom.data16(this.start);
    }

    @Override
    public boolean valid(int n) {
        return this.eeprom.data16(n) != 65535;
    }

    @Override
    public int cmd() {
        if (this.start == 0) {
            return 70;
        }
        if ((this.value() & 0x8000) != 0) {
            return 83;
        }
        return 65;
    }

    @Override
    public int tick() {
        int n = 0;
        int n2 = 10;
        for (int i = 2; i < this.start; i += 2) {
            int n3 = this.eeprom.data16(i);
            if ((n3 & 0x8000) != 0) {
                if ((n3 & Short.MAX_VALUE) < 6) continue;
                n2 = 100;
                continue;
            }
            n += n2;
        }
        return n;
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener) {
        int n = this.data16(-4);
        altosDataListener.set_tick(this.tick());
        switch (this.cmd()) {
            case 70: {
                altosDataListener.set_state(2);
                altosDataListener.cal_data().set_flight(n);
                altosDataListener.cal_data().set_boost_tick();
                break;
            }
            case 83: {
                altosDataListener.set_state(n & Short.MAX_VALUE);
                break;
            }
            case 65: {
                altosDataListener.set_pressure(AltosConvert.barometer_to_pressure(n));
            }
        }
    }

    @Override
    public AltosEepromRecord next() {
        int n = this.next_start();
        if (n < 0) {
            return null;
        }
        return new AltosEepromRecordTiny(this.eeprom, n);
    }

    public AltosEepromRecordTiny(AltosEeprom altosEeprom, int n) {
        super(altosEeprom, n, 2);
    }

    public AltosEepromRecordTiny(AltosEeprom altosEeprom) {
        this(altosEeprom, 0);
    }
}

