/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.IOException;
import java.io.InputStream;
import java.util.TreeSet;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConfigData;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosEeprom;
import org.altusmetrum.altoslib_14.AltosEepromRecord;
import org.altusmetrum.altoslib_14.AltosEepromRecordFireTwo;
import org.altusmetrum.altoslib_14.AltosEepromRecordFull;
import org.altusmetrum.altoslib_14.AltosEepromRecordGps;
import org.altusmetrum.altoslib_14.AltosEepromRecordMega;
import org.altusmetrum.altoslib_14.AltosEepromRecordMetrum;
import org.altusmetrum.altoslib_14.AltosEepromRecordMicroPeak2;
import org.altusmetrum.altoslib_14.AltosEepromRecordMini;
import org.altusmetrum.altoslib_14.AltosEepromRecordMotor;
import org.altusmetrum.altoslib_14.AltosEepromRecordTiny;
import org.altusmetrum.altoslib_14.AltosRecordSet;

public class AltosEepromRecordSet
implements AltosRecordSet {
    AltosEeprom eeprom;
    TreeSet<AltosEepromRecord> ordered;
    AltosCalData cal_data;
    boolean valid;

    public AltosConfigData config_data() {
        return this.eeprom.config_data();
    }

    private void init_cal_data() {
        for (AltosEepromRecord altosEepromRecord : this.ordered) {
            if (altosEepromRecord.cmd() != 70) continue;
            this.cal_data.set_tick(altosEepromRecord.tick());
            this.cal_data.set_boost_tick();
            this.cal_data.set_state(2);
            break;
        }
    }

    @Override
    public AltosCalData cal_data() {
        if (this.cal_data == null) {
            this.cal_data = new AltosCalData(this.config_data());
            this.init_cal_data();
        }
        return this.cal_data;
    }

    @Override
    public void capture_series(AltosDataListener altosDataListener) {
        if (this.cal_data == null) {
            this.cal_data();
        } else {
            this.cal_data.reset();
            this.init_cal_data();
        }
        altosDataListener.set_log_format(this.config_data().log_format);
        for (AltosEepromRecord altosEepromRecord : this.ordered) {
            altosEepromRecord.provide_data(altosDataListener, this.cal_data);
        }
        altosDataListener.finish();
    }

    @Override
    public boolean valid() {
        return this.valid;
    }

    public AltosEepromRecordSet(AltosEeprom altosEeprom) {
        this.eeprom = altosEeprom;
        AltosConfigData altosConfigData = altosEeprom.config_data();
        AltosEepromRecord altosEepromRecord = null;
        switch (altosConfigData.log_format) {
            case 1: {
                altosEepromRecord = new AltosEepromRecordFull(altosEeprom);
                break;
            }
            case 2: {
                altosEepromRecord = new AltosEepromRecordTiny(altosEeprom);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 15: 
            case 16: 
            case 19: {
                altosEepromRecord = new AltosEepromRecordMega(altosEeprom);
                break;
            }
            case 7: {
                altosEepromRecord = new AltosEepromRecordMetrum(altosEeprom);
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 14: {
                altosEepromRecord = new AltosEepromRecordMini(altosEeprom);
                break;
            }
            case 9: {
                altosEepromRecord = new AltosEepromRecordGps(altosEeprom);
                break;
            }
            case 13: {
                altosEepromRecord = new AltosEepromRecordFireTwo(altosEeprom);
                break;
            }
            case 18: {
                altosEepromRecord = new AltosEepromRecordMicroPeak2(altosEeprom);
                break;
            }
            case 20: {
                altosEepromRecord = new AltosEepromRecordMotor(altosEeprom);
            }
        }
        this.ordered = new TreeSet();
        if (altosEepromRecord == null) {
            System.out.printf("failed to parse log format %d\n", altosConfigData.log_format);
            this.valid = false;
            return;
        }
        this.valid = true;
        int n = 0;
        boolean bl = true;
        do {
            int n2;
            if (bl) {
                n = n2;
                bl = false;
            } else {
                for (n2 = altosEepromRecord.tick(); n2 < n - Short.MAX_VALUE; n2 += 65536) {
                }
                n = n2;
            }
            altosEepromRecord.wide_tick = n;
            this.ordered.add(altosEepromRecord);
        } while ((altosEepromRecord = altosEepromRecord.next()) != null);
    }

    public AltosEepromRecordSet(InputStream inputStream) throws IOException {
        this(new AltosEeprom(inputStream));
    }
}

