/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosEeprom;
import org.altusmetrum.altoslib_14.AltosEepromRecord;

public class AltosEepromRecordMicroPeak2
extends AltosEepromRecord {
    public static final int record_length = 2;
    private static final int PA_GROUND_OFFSET = 0;
    private static final int PA_MIN_OFFSET = 4;
    private static final int N_SAMPLES_OFFSET = 8;
    private static final int STARTING_LOG_OFFSET = 10;
    private static final int LOG_ID_MICROPEAK = 0;
    private static final int LOG_ID_MICROKITE = 1;
    private static final int LOG_ID_MICROPEAK2 = 2;

    private int value16(int n) {
        return this.eeprom.data16(n);
    }

    private int value32(int n) {
        return this.eeprom.data32(n);
    }

    @Override
    public int cmd() {
        if (this.start == 0) {
            return 70;
        }
        return 65;
    }

    private int pa_ground() {
        return this.value32(0);
    }

    private int pa_min() {
        return this.value32(4);
    }

    private int log_id() {
        return this.value16(8) >> 12;
    }

    private int n_samples() {
        return this.value16(8) & 0xFFF;
    }

    private int ticks_per_sample() {
        int n = this.log_id();
        if (n == 0) {
            return 2;
        }
        if (n == 1) {
            return 200;
        }
        if (n == 2) {
            return 10;
        }
        return 1;
    }

    @Override
    public int tick() {
        if (this.start <= 10) {
            return 0;
        }
        return (this.start - 10) / 2 * this.ticks_per_sample();
    }

    public double ticks_per_sec() {
        int n = this.log_id();
        if (n == 0) {
            return 10.416666666666666;
        }
        if (n == 1) {
            return 10.416666666666666;
        }
        if (n == 2) {
            return 100.0;
        }
        return 100.0;
    }

    int mix_in(int n, int n2) {
        return n - (n & 0xFFFF) + n2;
    }

    boolean closer(int n, int n2, int n3) {
        return Math.abs(n - n2) < Math.abs(n - n3);
    }

    private int pressure() {
        int n = this.value32(0);
        for (int i = 10; i <= this.start; i += 2) {
            int n2 = this.value16(i);
            int n3 = this.mix_in(n, n2);
            int n4 = this.mix_in(n + 65536, n2);
            int n5 = this.mix_in(n - 65536, n2);
            if (this.closer(n, n3, n4)) {
                if (this.closer(n, n3, n5)) {
                    n = n3;
                    continue;
                }
                n = n5;
                continue;
            }
            n = this.closer(n, n4, n5) ? n4 : n5;
        }
        return n;
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener, AltosCalData altosCalData) {
        altosDataListener.set_tick(this.tick());
        switch (this.cmd()) {
            case 70: {
                int n = this.pa_ground();
                int n2 = this.pa_min();
                int n3 = this.n_samples();
                int n4 = this.log_id();
                altosDataListener.set_state(2);
                altosDataListener.cal_data().set_ground_pressure(n);
                altosDataListener.cal_data().set_ticks_per_sec(this.ticks_per_sec());
                altosDataListener.cal_data().set_boost_tick();
                altosDataListener.set_avoid_duplicate_files();
                break;
            }
            case 65: {
                altosDataListener.set_state(3);
                altosDataListener.set_pressure(this.pressure());
            }
        }
    }

    @Override
    public int next_start() {
        if (this.start == 0) {
            return 10;
        }
        if (this.start + 2 >= 10 + 2 * this.n_samples()) {
            return -1;
        }
        return this.start + 2;
    }

    @Override
    public AltosEepromRecord next() {
        int n = this.next_start();
        if (n < 0) {
            return null;
        }
        return new AltosEepromRecordMicroPeak2(this.eeprom, n);
    }

    public AltosEepromRecordMicroPeak2(AltosEeprom altosEeprom, int n) {
        super(altosEeprom, n, 2);
    }

    public AltosEepromRecordMicroPeak2(AltosEeprom altosEeprom) {
        this(altosEeprom, 0);
    }
}

