/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosCompanion;
import org.altusmetrum.altoslib_14.AltosGPS;

public abstract class AltosDataListener {
    private AltosCalData cal_data = null;
    public double time = 2.147483647E9;
    public double frequency = 2.147483647E9;
    public int raw_tick = Integer.MAX_VALUE;

    public int tick() {
        return this.raw_tick;
    }

    public void set_tick(int n) {
        this.raw_tick = n;
        this.cal_data.set_tick(n);
        this.set_time(this.cal_data.time());
    }

    public AltosCalData cal_data() {
        if (this.cal_data == null) {
            this.cal_data = new AltosCalData();
        }
        return this.cal_data;
    }

    public void set_time(double d) {
        if (d != 2.147483647E9) {
            this.time = d;
        }
    }

    public void set_serial(int n) {
        this.cal_data().set_serial(n);
    }

    public void set_device_type(int n) {
        this.cal_data().set_device_type(n);
        switch (n) {
            case 37: {
                this.set_state(10);
            }
        }
    }

    public void set_log_format(int n) {
        this.cal_data().set_log_format(n);
        switch (n) {
            case 9: {
                this.set_state(10);
            }
        }
    }

    public double time() {
        return this.time;
    }

    public String state_name() {
        return this.cal_data().state_name();
    }

    public void set_state(int n) {
        this.cal_data().set_state(n);
    }

    public int state() {
        return this.cal_data().state;
    }

    public void set_flight(int n) {
        this.cal_data().set_flight(n);
    }

    public void set_frequency(double d) {
        this.frequency = d;
    }

    public void set_avoid_duplicate_files() {
    }

    public void finish() {
    }

    public void init() {
        this.set_state(9);
        this.time = 2.147483647E9;
        this.frequency = 2.147483647E9;
    }

    public abstract void set_rssi(int var1, int var2);

    public abstract void set_received_time(long var1);

    public abstract void set_acceleration(double var1);

    public abstract void set_pressure(double var1);

    public abstract void set_thrust(double var1);

    public abstract void set_kalman(double var1, double var3, double var5);

    public abstract void set_temperature(double var1);

    public abstract void set_battery_voltage(double var1);

    public abstract void set_apogee_voltage(double var1);

    public abstract void set_main_voltage(double var1);

    public void set_gps(AltosGPS altosGPS, boolean bl, boolean bl2) {
        AltosCalData altosCalData = this.cal_data();
        altosCalData.set_cal_gps(altosGPS);
    }

    public AltosGPS make_temp_gps(boolean bl) {
        return this.cal_data().make_temp_cal_gps(this.tick(), bl);
    }

    public AltosGPS temp_gps() {
        return this.cal_data().temp_cal_gps();
    }

    public abstract void set_orient(double var1);

    public abstract void set_gyro(double var1, double var3, double var5);

    public abstract void set_accel_ground(double var1, double var3, double var5);

    public abstract void set_accel(double var1, double var3, double var5);

    public abstract void set_mag(double var1, double var3, double var5);

    public abstract void set_pyro_voltage(double var1);

    public abstract void set_igniter_voltage(double[] var1);

    public abstract void set_pyro_fired(int var1);

    public abstract void set_companion(AltosCompanion var1);

    public abstract void set_motor_pressure(double var1);

    public AltosDataListener() {
    }

    public AltosDataListener(AltosCalData altosCalData) {
        this.cal_data = altosCalData;
    }
}

