/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.altusmetrum.altoslib_14.AltosFontListener;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altoslib_14.AltosUnitsListener;
import org.altusmetrum.altosuilib_14.AltosLights;
import org.altusmetrum.altosuilib_14.AltosUILib;

public abstract class AltosUIIndicator
implements AltosFontListener,
AltosUnitsListener {
    JLabel label;
    JTextField[] values;
    AltosLights lights;
    int number_values;
    boolean has_lights;
    int value_width;

    public abstract void show(AltosState var1, AltosListenerState var2);

    public void set_lights(boolean bl) {
        this.lights.set(bl);
    }

    public void setVisible(boolean bl) {
        if (this.lights != null) {
            this.lights.setVisible(bl);
        }
        this.label.setVisible(bl);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i].setVisible(bl);
        }
    }

    public void reset() {
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i].setText("");
        }
        if (this.lights != null) {
            this.lights.set(false);
        }
    }

    public void show() {
        if (this.lights != null) {
            this.lights.setVisible(true);
        }
        this.label.setVisible(true);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i].setVisible(true);
        }
    }

    public void show(String ... stringArray) {
        int n = Math.min(stringArray.length, this.values.length);
        this.show();
        for (int i = 0; i < n; ++i) {
            this.values[i].setText(stringArray[i]);
        }
    }

    public void show(String string, double d) {
        this.show(String.format(string, d));
    }

    public void show(String string, int n) {
        this.show(String.format(string, n));
    }

    public void show(String string, double d, String string2, double d2) {
        this.show(String.format(string, d), String.format(string2, d2));
    }

    public void show(String string, int n, String string2, int n2) {
        this.show(String.format(string, n), String.format(string2, n2));
    }

    public void hide() {
        if (this.lights != null) {
            this.lights.setVisible(false);
        }
        this.label.setVisible(false);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i].setVisible(false);
        }
    }

    public void font_size_changed(int n) {
        this.label.setFont(AltosUILib.label_font);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i].setFont(AltosUILib.value_font);
        }
    }

    public void units_changed(boolean bl) {
    }

    public void set_label(String string) {
        this.label.setText(string);
    }

    public void remove(Container container) {
        if (this.lights != null) {
            container.remove(this.lights);
        }
        container.remove(this.label);
        for (int i = 0; i < this.values.length; ++i) {
            container.remove(this.values[i]);
        }
    }

    public AltosUIIndicator(Container container, int n, int n2, int n3, String string, int n4, boolean bl, int n5, int n6) {
        GridBagLayout gridBagLayout = (GridBagLayout)container.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        if (bl) {
            this.lights = new AltosLights();
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.fill = 3;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(this.lights, gridBagConstraints);
            container.add(this.lights);
        }
        this.label = new JLabel(string);
        this.label.setFont(AltosUILib.label_font);
        this.label.setHorizontalAlignment(2);
        gridBagConstraints.gridx = n + 1;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.label, gridBagConstraints);
        container.add(this.label);
        this.values = new JTextField[n4];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = new JTextField(20);
            this.values[i].setEditable(false);
            this.values[i].setFont(AltosUILib.value_font);
            this.values[i].setHorizontalAlignment(4);
            gridBagConstraints.gridx = 1 + n3 + n + i * n6;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = n5;
            gridBagLayout.setConstraints(this.values[i], gridBagConstraints);
            container.add(this.values[i]);
        }
    }

    public AltosUIIndicator(Container container, int n, int n2, int n3, String string, int n4, boolean bl, int n5) {
        this(container, n, n2, n3, string, n4, bl, n5, 1);
    }

    public AltosUIIndicator(Container container, int n, int n2, String string, int n3, boolean bl, int n4) {
        this(container, n, n2, 1, string, n3, bl, n4);
    }

    public AltosUIIndicator(Container container, int n, String string, int n2, boolean bl, int n3) {
        this(container, 0, n, string, n2, bl, n3);
    }

    public AltosUIIndicator(Container container, int n, String string, int n2, boolean bl) {
        this(container, 0, n, string, n2, bl, 1);
    }

    public AltosUIIndicator(Container container, int n, String string, int n2) {
        this(container, 0, n, string, n2, false, 1);
    }

    public AltosUIIndicator(Container container, int n, String string) {
        this(container, 0, n, string, 1, false, 1);
    }
}

