/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;
import org.altusmetrum.altosuilib_14.AltosUIDialog;
import org.altusmetrum.altosuilib_14.AltosUILib;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;
import org.altusmetrum.altosuilib_14.DelegatingRenderer;

public class AltosUIConfigure
extends AltosUIDialog {
    public JFrame owner;
    public Container pane;
    public int row;
    static final String[] font_size_names = new String[]{"Small", "Medium", "Large", "Huge"};
    static final Integer[] map_caches = new Integer[]{9, 25, 100};

    public GridBagConstraints constraints(int n, int n2, int n3) {
        Insets insets;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = n3;
        gridBagConstraints.anchor = n2 == 3 ? 10 : (n == 2 ? 13 : 17);
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridwidth = n2;
        gridBagConstraints.gridy = this.row;
        return gridBagConstraints;
    }

    public GridBagConstraints constraints(int n, int n2) {
        return this.constraints(n, n2, 0);
    }

    public void add_voice() {
    }

    public void add_log_dir() {
        this.pane.add((Component)new JLabel("Log Directory"), this.constraints(0, 1));
        final JButton jButton = new JButton(AltosUIPreferences.logdir().getPath());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUIPreferences.ConfigureLog();
                jButton.setText(AltosUIPreferences.logdir().getPath());
            }
        });
        this.pane.add((Component)jButton, this.constraints(1, 2));
        jButton.setToolTipText("Which directory flight logs are stored in");
        ++this.row;
    }

    public void add_callsign() {
    }

    public void add_units() {
        this.pane.add((Component)new JLabel("Imperial Units"), this.constraints(0, 1));
        JRadioButton jRadioButton = new JRadioButton("Enable", AltosUIPreferences.imperial_units());
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                boolean bl = jRadioButton.isSelected();
                AltosUIPreferences.set_imperial_units((boolean)bl);
            }
        });
        jRadioButton.setToolTipText("Use Imperial units instead of metric");
        this.pane.add((Component)jRadioButton, this.constraints(1, 2));
        ++this.row;
    }

    public void add_font_size() {
        this.pane.add((Component)new JLabel("Font size"), this.constraints(0, 1));
        final JComboBox<String> jComboBox = new JComboBox<String>(font_size_names);
        int n = AltosUIPreferences.font_size();
        jComboBox.setSelectedIndex(n - 1);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = jComboBox.getSelectedIndex() + 1;
                AltosUIPreferences.set_font_size(n);
            }
        });
        this.pane.add(jComboBox, this.constraints(1, 2, 1));
        jComboBox.setToolTipText("Font size used in telemetry window");
        ++this.row;
    }

    public void add_look_and_feel() {
        this.pane.add((Component)new JLabel("Look & feel"), this.constraints(0, 1));
        final UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        final JComboBox<Object> jComboBox = new JComboBox<Object>(lookAndFeelInfoArray);
        DelegatingRenderer.install(jComboBox);
        String string = AltosUIPreferences.look_and_feel();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            if (!string.equals(lookAndFeelInfoArray[i].getClassName())) continue;
            jComboBox.setSelectedIndex(i);
        }
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = jComboBox.getSelectedIndex();
                AltosUIPreferences.set_look_and_feel(lookAndFeelInfoArray[n].getClassName());
            }
        });
        this.pane.add(jComboBox, this.constraints(1, 2, 1));
        jComboBox.setToolTipText("Look&feel used for new windows");
        ++this.row;
    }

    public void add_position() {
    }

    public void add_serial_debug() {
        this.pane.add((Component)new JLabel("Serial Debug"), this.constraints(0, 1));
        JRadioButton jRadioButton = new JRadioButton("Enable", AltosUIPreferences.serial_debug());
        jRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
                boolean bl = jRadioButton.isSelected();
                AltosUIPreferences.set_serial_debug(bl);
            }
        });
        jRadioButton.setToolTipText("Enable/Disable USB I/O getting sent to the console");
        this.pane.add((Component)jRadioButton, this.constraints(1, 2));
        ++this.row;
    }

    public void add_map_cache() {
        this.pane.add((Component)new JLabel("Map Cache Size"), this.constraints(0, 1));
        final JComboBox<Integer> jComboBox = new JComboBox<Integer>(map_caches);
        jComboBox.setEditable(true);
        jComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = (Integer)jComboBox.getSelectedItem();
                    AltosUIPreferences.set_map_cache((int)n);
                }
                catch (ClassCastException classCastException) {
                    jComboBox.setSelectedItem(AltosUIPreferences.map_cache());
                }
            }
        });
        jComboBox.setSelectedItem(AltosUIPreferences.map_cache());
        this.pane.add(jComboBox, this.constraints(1, 2, 1));
        ++this.row;
    }

    public void add_bluetooth() {
    }

    public void add_frequencies() {
    }

    public AltosUIConfigure(JFrame jFrame, String string, String string2) {
        super(jFrame, string, false);
        this.owner = jFrame;
        this.pane = this.getScrollablePane();
        this.pane.setLayout(new GridBagLayout());
        this.row = 0;
        this.pane.add((Component)new JLabel(string2), this.constraints(0, 3));
        ++this.row;
        this.pane.add((Component)new JLabel(String.format("AltOS version %s", "1.9.6.4")), this.constraints(0, 3));
        ++this.row;
        this.add_voice();
        this.add_log_dir();
        this.add_callsign();
        this.add_units();
        this.add_serial_debug();
        this.add_font_size();
        this.add_look_and_feel();
        this.add_position();
        this.add_map_cache();
        if (AltosUILib.has_bluetooth) {
            this.add_bluetooth();
        }
        this.add_frequencies();
        JButton jButton = new JButton("Close");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUIConfigure.this.setVisible(false);
            }
        });
        this.pane.add((Component)jButton, this.constraints(0, 3));
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
    }

    public AltosUIConfigure(JFrame jFrame) {
        this(jFrame, "Configure AltosUI", "Configure AltOS UI");
    }
}

