/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosFlightDisplay;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altosuilib_14.AltosFlightInfoTableModel;
import org.altusmetrum.altosuilib_14.AltosUILib;

public class AltosInfoTable
extends JTable
implements AltosFlightDisplay,
HierarchyListener {
    private AltosFlightInfoTableModel model = (AltosFlightInfoTableModel)this.getModel();
    static final int info_columns = 4;
    static final int info_rows = 18;
    private AltosState last_state;
    private AltosListenerState last_listener_state;

    int desired_row_height() {
        FontMetrics fontMetrics = this.getFontMetrics(AltosUILib.table_value_font);
        return (fontMetrics.getHeight() + fontMetrics.getLeading()) * 18 / 10;
    }

    int text_width(String string) {
        FontMetrics fontMetrics = this.getFontMetrics(AltosUILib.table_value_font);
        return fontMetrics.stringWidth(string);
    }

    void set_layout() {
        this.setRowHeight(this.desired_row_height());
        for (int i = 0; i < 8; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            if ((i & 1) == 0) {
                tableColumn.setPreferredWidth(this.text_width(" Satellites Visible"));
                continue;
            }
            tableColumn.setPreferredWidth(this.text_width("W 179\u00b059.99999' "));
        }
    }

    public AltosInfoTable() {
        super(new AltosFlightInfoTableModel(18, 4));
        this.setFont(AltosUILib.table_value_font);
        this.addHierarchyListener(this);
        this.setAutoResizeMode(4);
        this.setShowGrid(true);
        this.set_layout();
        this.doLayout();
    }

    public void font_size_changed(int n) {
        this.setFont(AltosUILib.table_value_font);
        this.set_layout();
        this.doLayout();
    }

    public void units_changed(boolean bl) {
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if (this.last_state != null && this.isShowing()) {
            AltosState altosState = this.last_state;
            AltosListenerState altosListenerState = this.last_listener_state;
            this.last_state = null;
            this.last_listener_state = null;
            this.show(altosState, altosListenerState);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public void reset() {
        this.model.reset();
    }

    void info_add_row(int n, String string, String string2) {
        this.model.addRow(n, string, string2);
    }

    void info_add_row(int n, String string, String string2, Object ... objectArray) {
        this.info_add_row(n, string, String.format(string2, objectArray));
    }

    void info_add_deg(int n, String string, double d, int n2, int n3) {
        int n4 = n2;
        if (d < 0.0) {
            n4 = n3;
            d = -d;
        }
        double d2 = Math.floor(d);
        double d3 = (d - d2) * 60.0;
        this.info_add_row(n, string, String.format("%c %3.0f\u00b0%08.5f'", n4, d2, d3));
    }

    void info_finish() {
        this.model.finish();
    }

    public void clear() {
        this.model.clear();
    }

    @Override
    public String getName() {
        return "Table";
    }

    public void show(AltosState altosState, AltosListenerState altosListenerState) {
        int n;
        AltosCalData altosCalData = altosState.cal_data();
        if (!this.isShowing()) {
            this.last_state = altosState;
            this.last_listener_state = altosListenerState;
            return;
        }
        this.reset();
        if (altosState != null) {
            if (altosCalData.device_type != Integer.MAX_VALUE) {
                this.info_add_row(0, "Device", "%s", AltosLib.product_name((int)altosCalData.device_type));
            } else if (altosCalData.product != null) {
                this.info_add_row(0, "Device", "%s", altosCalData.product);
            }
            if (altosState.tick() != Integer.MAX_VALUE) {
                this.info_add_row(0, "Tick", "%6d", altosState.tick());
            }
            if (altosState.altitude() != 2.147483647E9) {
                this.info_add_row(0, "Altitude", "%6.0f    m", altosState.altitude());
            }
            if (altosCalData.ground_altitude != 2.147483647E9) {
                this.info_add_row(0, "Pad altitude", "%6.0f    m", altosCalData.ground_altitude);
            }
            if (altosState.height() != 2.147483647E9) {
                this.info_add_row(0, "Height", "%6.0f    m", altosState.height());
            }
            if (altosState.max_height() != 2.147483647E9) {
                this.info_add_row(0, "Max height", "%6.0f    m", altosState.max_height());
            }
            if (altosState.acceleration() != 2.147483647E9) {
                this.info_add_row(0, "Acceleration", "%8.1f  m/s\u00b2", altosState.acceleration());
            }
            if (altosState.max_acceleration() != 2.147483647E9) {
                this.info_add_row(0, "Max acceleration", "%8.1f  m/s\u00b2", altosState.max_acceleration());
            }
            if (altosState.speed() != 2.147483647E9) {
                this.info_add_row(0, "Speed", "%8.1f  m/s", altosState.speed());
            }
            if (altosState.max_speed() != 2.147483647E9) {
                this.info_add_row(0, "Max Speed", "%8.1f  m/s", altosState.max_speed());
            }
            if (altosState.orient() != 2.147483647E9) {
                this.info_add_row(0, "Tilt", "%4.0f \u00b0", altosState.orient());
            }
            if (altosState.max_orient() != 2.147483647E9) {
                this.info_add_row(0, "Max Tilt", "%4.0f \u00b0", altosState.max_orient());
            }
            if (altosState.temperature != 2.147483647E9) {
                this.info_add_row(0, "Temperature", "%9.2f \u00b0C", altosState.temperature);
            }
            if (altosState.battery_voltage != 2.147483647E9) {
                this.info_add_row(0, "Battery", "%9.2f V", altosState.battery_voltage);
            }
            if (altosState.apogee_voltage != 2.147483647E9) {
                this.info_add_row(0, "Drogue", "%9.2f V", altosState.apogee_voltage);
            }
            if (altosState.main_voltage != 2.147483647E9) {
                this.info_add_row(0, "Main", "%9.2f V", altosState.main_voltage);
            }
        }
        if (altosListenerState != null) {
            this.info_add_row(0, "CRC Errors", "%6d", altosListenerState.crc_errors);
            if (altosListenerState.battery != 2.147483647E9) {
                this.info_add_row(0, "Receiver Battery", "%9.2f", altosListenerState.battery);
            }
        }
        if (altosState != null) {
            if (altosState.gps == null || !altosState.gps.connected) {
                this.info_add_row(1, "GPS", "not available");
            } else {
                if (altosState.gps_ready) {
                    this.info_add_row(1, "GPS state", "%s", "ready");
                } else {
                    this.info_add_row(1, "GPS state", "wait (%d)", altosState.gps_waiting);
                }
                if (altosState.gps.locked) {
                    this.info_add_row(1, "GPS", "   locked");
                } else if (altosState.gps.connected) {
                    this.info_add_row(1, "GPS", " unlocked");
                } else {
                    this.info_add_row(1, "GPS", "  missing");
                }
                this.info_add_row(1, "Satellites", "%6d", altosState.gps.nsat);
                if (altosState.gps.lat != 2.147483647E9) {
                    this.info_add_deg(1, "Latitude", altosState.gps.lat, 78, 83);
                }
                if (altosState.gps.lon != 2.147483647E9) {
                    this.info_add_deg(1, "Longitude", altosState.gps.lon, 69, 87);
                }
                if (altosState.gps.alt != 2.147483647E9) {
                    this.info_add_row(1, "GPS altitude", "%8.1f m", altosState.gps.alt);
                }
                if (altosState.gps_height != 2.147483647E9) {
                    this.info_add_row(1, "GPS height", "%8.1f m", altosState.gps_height);
                }
                if (altosState.gps.ground_speed != 2.147483647E9 && altosState.gps.course != Integer.MAX_VALUE) {
                    this.info_add_row(1, "GPS ground speed", "%6.1f m/s %3d\u00b0", altosState.gps.ground_speed, altosState.gps.course);
                }
                if (altosState.gps.climb_rate != 2.147483647E9) {
                    this.info_add_row(1, "GPS climb rate", "%6.1f m/s", altosState.gps.climb_rate);
                }
                if (altosState.gps.h_error != 2.147483647E9 && altosState.gps.v_error != 2.147483647E9) {
                    this.info_add_row(1, "GPS error", "%6.0f m(h)%6.0f m(v)", altosState.gps.h_error, altosState.gps.v_error);
                }
                if (altosState.gps.pdop != 2.147483647E9 && altosState.gps.hdop != 2.147483647E9 && altosState.gps.vdop != 2.147483647E9) {
                    this.info_add_row(1, "GPS dop", "%3.1fp/%3.1fh/%3.1fv", altosState.gps.pdop, altosState.gps.hdop, altosState.gps.vdop);
                }
                if (altosState.npad > 0) {
                    if (altosState.from_pad != null) {
                        this.info_add_row(1, "Ground pad dist", "%6d m", (int)(altosState.from_pad.distance + 0.5));
                        this.info_add_row(1, "Direction from pad", "%6d\u00b0", (int)(altosState.from_pad.bearing + 0.5));
                        this.info_add_row(1, "Elevation from pad", "%6d\u00b0", (int)(altosState.elevation + 0.5));
                        this.info_add_row(1, "Range from pad", "%6d m", (int)(altosState.range + 0.5));
                    } else {
                        this.info_add_row(1, "Distance from pad", "unknown");
                        this.info_add_row(1, "Direction from pad", "unknown");
                        this.info_add_row(1, "Elevation from pad", "unknown");
                        this.info_add_row(1, "Range from pad", "unknown");
                    }
                    this.info_add_deg(1, "Pad latitude", altosState.pad_lat, 78, 83);
                    this.info_add_deg(1, "Pad longitude", altosState.pad_lon, 69, 87);
                    this.info_add_row(1, "Pad GPS alt", "%6.0f m", altosState.gps_ground_altitude());
                }
                if (altosState.gps.year != Integer.MAX_VALUE) {
                    this.info_add_row(2, "GPS date", "%04d-%02d-%02d", altosState.gps.year, altosState.gps.month, altosState.gps.day);
                }
                if (altosState.gps.hour != Integer.MAX_VALUE) {
                    this.info_add_row(2, "GPS time", "  %02d:%02d:%02d", altosState.gps.hour, altosState.gps.minute, altosState.gps.second);
                }
                if (altosState.gps.cc_gps_sat == null) {
                    this.info_add_row(2, "Satellites Visible", "%4d", 0);
                } else {
                    this.info_add_row(2, "Satellites Visible", "%4d", altosState.gps.cc_gps_sat.length);
                    for (n = 0; n < altosState.gps.cc_gps_sat.length; ++n) {
                        this.info_add_row(2, "Satellite id,C/N0", "%4d, %4d", altosState.gps.cc_gps_sat[n].svid, altosState.gps.cc_gps_sat[n].c_n0);
                    }
                }
            }
        }
        if (altosState != null && altosState.accel_along() != 2.147483647E9) {
            this.info_add_row(3, "Accel along", "%8.1f m/s\u00b2", altosState.accel_along());
            this.info_add_row(3, "Accel across", "%8.1f m/s\u00b2", altosState.accel_across());
            this.info_add_row(3, "Accel through", "%8.1f m/s\u00b2", altosState.accel_through());
        }
        if (altosState != null && altosState.gyro_roll() != 2.147483647E9) {
            this.info_add_row(3, "Gyro roll", "%8.1f \u00b0/s", altosState.gyro_roll());
            this.info_add_row(3, "Gyro pitch", "%8.1f \u00b0/s", altosState.gyro_pitch());
            this.info_add_row(3, "Gyro yaw", "%8.1f \u00b0/s", altosState.gyro_yaw());
        }
        if (altosState != null && altosState.mag_along() != 2.147483647E9) {
            this.info_add_row(3, "Mag along", "%8.1f \u00b5T", altosState.mag_along() * 100.0);
            this.info_add_row(3, "Mag across", "%8.1f \u00b5T", altosState.mag_across() * 100.0);
            this.info_add_row(3, "Mag Through", "%8.1f \u00b5T", altosState.mag_through() * 100.0);
            this.info_add_row(3, "Mag Bearing", "%8.1f\u00b0", Math.atan2(altosState.mag_across(), altosState.mag_through()) * 180.0 / Math.PI);
        }
        if (altosState != null && altosState.igniter_voltage != null) {
            for (n = 0; n < altosState.igniter_voltage.length; ++n) {
                this.info_add_row(3, AltosLib.igniter_name((int)n), "%9.2f V", altosState.igniter_voltage[n]);
            }
        }
        this.info_finish();
    }
}

