/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.telegps;

import java.awt.Frame;
import java.io.IOException;
import java.text.ParseException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosFlightDisplay;
import org.altusmetrum.altoslib_14.AltosFlightReader;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altosuilib_14.AltosVoice;

public class TeleGPSDisplayThread
extends Thread {
    Frame parent;
    IdleThread idle_thread;
    AltosVoice voice;
    AltosFlightReader reader;
    AltosState state;
    int old_state = 9;
    boolean old_gps_ready = false;
    AltosListenerState listener_state = new AltosListenerState();
    AltosFlightDisplay display;

    synchronized void show_safely() {
        final AltosState altosState = this.state;
        final AltosListenerState altosListenerState = this.listener_state;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    TeleGPSDisplayThread.this.display.show(altosState, altosListenerState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    void reading_error_internal() {
        JOptionPane.showMessageDialog(this.parent, String.format("Error reading from \"%s\"", this.reader.name), "Telemetry Read Error", 0);
    }

    void reading_error_safely() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    TeleGPSDisplayThread.this.reading_error_internal();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    synchronized boolean tell() {
        boolean bl = false;
        if (this.old_gps_ready != this.state.gps_ready) {
            if (this.state.gps_ready) {
                this.voice.speak("GPS ready");
                bl = true;
            } else if (this.old_gps_ready) {
                this.voice.speak("GPS lost");
                bl = true;
            }
            this.old_gps_ready = this.state.gps_ready;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block22: {
            var1_1 = false;
            this.idle_thread = new IdleThread();
            this.idle_thread.start();
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    try {
                        while (true) {
                            this.state = this.reader.read();
                            if (this.state == null) {
                                this.listener_state.running = false;
                                break block22;
                            }
                            this.show_safely();
                            var2_2 = this.tell();
                            this.idle_thread.notice(var2_2);
                        }
                    }
                    catch (ParseException var3_4) {
                        System.out.printf("Parse error: %d \"%s\"\n", new Object[]{var3_4.getErrorOffset(), var3_4.getMessage()});
                    }
                    catch (AltosCRCException var3_5) {
                        ++this.listener_state.crc_errors;
                        this.show_safely();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException var3_7) {
                var1_1 = true;
                break block22;
            }
            catch (IOException var3_9) {
                this.reading_error_safely();
                break block22;
            }
            finally {
                if (!var1_1) {
                    this.idle_thread.report(true);
                }
                this.reader.close(var1_1);
                this.idle_thread.interrupt();
                try {
                    this.idle_thread.join();
                }
                catch (InterruptedException var3_8) {}
            }
            ** GOTO lbl-1000
        }
    }

    public TeleGPSDisplayThread(Frame frame, AltosVoice altosVoice, AltosFlightDisplay altosFlightDisplay, AltosFlightReader altosFlightReader) {
        this.parent = frame;
        this.voice = altosVoice;
        this.display = altosFlightDisplay;
        this.reader = altosFlightReader;
        this.display.reset();
    }

    class IdleThread
    extends Thread {
        boolean started;
        int report_interval = 10000;
        long report_time;

        public synchronized void report(boolean bl) {
            if (TeleGPSDisplayThread.this.state == null) {
                return;
            }
            if (TeleGPSDisplayThread.this.state.height() != 2.147483647E9) {
                if (TeleGPSDisplayThread.this.state.from_pad != null) {
                    TeleGPSDisplayThread.this.voice.speak("Height %s, bearing %s %d, elevation %d, range %s, .\n", AltosConvert.height.say(TeleGPSDisplayThread.this.state.gps_height()), TeleGPSDisplayThread.this.state.from_pad.bearing_words(2), (int)(TeleGPSDisplayThread.this.state.from_pad.bearing + 0.5), (int)(TeleGPSDisplayThread.this.state.elevation + 0.5), AltosConvert.distance.say(TeleGPSDisplayThread.this.state.range));
                } else {
                    TeleGPSDisplayThread.this.voice.speak("Height %s.\n", AltosConvert.height.say(TeleGPSDisplayThread.this.state.height()));
                }
            }
        }

        long now() {
            return System.currentTimeMillis();
        }

        void set_report_time() {
            this.report_time = this.now() + (long)this.report_interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    if (TeleGPSDisplayThread.this.reader.has_monitor_battery()) {
                        TeleGPSDisplayThread.this.listener_state.battery = TeleGPSDisplayThread.this.reader.monitor_battery();
                        TeleGPSDisplayThread.this.show_safely();
                    }
                    this.set_report_time();
                    while (true) {
                        TeleGPSDisplayThread.this.voice.drain();
                        IdleThread idleThread = this;
                        synchronized (idleThread) {
                            long l = this.report_time - this.now();
                            if (l <= 0L) {
                                break;
                            }
                            this.wait(l);
                        }
                    }
                    this.report(false);
                }
            }
            catch (InterruptedException interruptedException) {
                try {
                    TeleGPSDisplayThread.this.voice.drain();
                }
                catch (InterruptedException interruptedException2) {
                    // empty catch block
                }
                return;
            }
        }

        public synchronized void notice(boolean bl) {
            if (TeleGPSDisplayThread.this.old_state != TeleGPSDisplayThread.this.state.state()) {
                this.report_time = this.now();
                this.notify();
            } else if (bl) {
                this.set_report_time();
            }
            TeleGPSDisplayThread.this.old_state = TeleGPSDisplayThread.this.state.state();
        }
    }
}

