/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.micropeak;

import java.io.FileNotFoundException;
import java.io.InputStream;
import libaltosJNI.SWIGTYPE_p_altos_file;
import libaltosJNI.libaltos;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;
import org.altusmetrum.micropeak.MicroSerialLog;

public class MicroSerial
extends InputStream {
    SWIGTYPE_p_altos_file file;
    private MicroSerialLog log;

    @Override
    public int read() {
        if (this.file == null) {
            return -1;
        }
        int n = libaltos.altos_getchar(this.file, 0);
        if (Thread.interrupted()) {
            return -1;
        }
        if (n == -1) {
            return -1;
        }
        if (AltosUIPreferences.serial_debug) {
            System.out.printf("%c", n);
        }
        if (this.log != null) {
            this.log.log_char(n);
        }
        return n;
    }

    public void write(char c) {
        libaltos.altos_putchar(this.file, c);
    }

    public void flush() {
        libaltos.altos_flush(this.file);
    }

    @Override
    public void close() {
        if (this.file != null) {
            libaltos.altos_close(this.file);
            this.file = null;
        }
    }

    public void set_log(MicroSerialLog microSerialLog) {
        this.log = microSerialLog;
    }

    public MicroSerial(AltosDevice altosDevice) throws FileNotFoundException {
        this.file = altosDevice.open();
        this.log = null;
        if (this.file == null) {
            String string = altosDevice.getErrorString();
            throw new FileNotFoundException(String.format("%s (%s)", altosDevice.toShortString(), string));
        }
    }
}

