/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.micropeak;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.altusmetrum.altoslib_14.AltosFilterListener;
import org.altusmetrum.altoslib_14.AltosFlightStats;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosFlightStatsTable;
import org.altusmetrum.altosuilib_14.AltosGraph;
import org.altusmetrum.altosuilib_14.AltosUIConfigure;
import org.altusmetrum.altosuilib_14.AltosUIEnable;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;
import org.altusmetrum.micropeak.MicroData;
import org.altusmetrum.micropeak.MicroDeviceDialog;
import org.altusmetrum.micropeak.MicroDownload;
import org.altusmetrum.micropeak.MicroExport;
import org.altusmetrum.micropeak.MicroFileChooser;
import org.altusmetrum.micropeak.MicroFrame;
import org.altusmetrum.micropeak.MicroRaw;
import org.altusmetrum.micropeak.MicroSave;

public class MicroPeak
extends MicroFrame
implements ActionListener,
ItemListener,
AltosFilterListener {
    File filename;
    AltosGraph graph;
    AltosUIEnable enable;
    AltosFlightStatsTable statsTable;
    MicroRaw raw;
    MicroData data;
    Container container;
    JTabbedPane pane;
    JMenuBar menu_bar;
    static int number_of_windows;
    static final String open_command = "open";
    static final String save_command = "save";
    static final String export_command = "export";
    static final String preferences_command = "preferences";
    static final String close_command = "close";
    static final String exit_command = "exit";
    static final String[][] file_menu_entries;
    static final String download_command = "download";
    static final String download_label = "Download";
    static final String[][] download_menu_entries;

    MicroPeak SetData(MicroData microData) {
        MicroPeak microPeak = this;
        if (this.data != null) {
            microPeak = new MicroPeak();
            return microPeak.SetData(microData);
        }
        this.data = microData;
        if (microData.flight_series == null) {
            System.out.printf("no data in flight\n", new Object[0]);
        }
        if (microData.flight_stats == null) {
            System.out.printf("no stats in flight\n", new Object[0]);
        }
        this.graph.set_data(microData.flight_stats, microData.flight_series);
        this.statsTable.set_stats(microData.flight_stats);
        this.raw.setData(microData);
        this.setTitle(microData.name);
        return this;
    }

    void SetName(String string) {
        this.graph.setName(string);
        this.setTitle(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MicroData ReadFile(File file) throws IOException, FileNotFoundException {
        MicroData microData = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            microData = new MicroData(fileInputStream, file.getName());
            AltosUIPreferences.set_last_logdir(file);
        }
        return microData;
    }

    private void OpenFile(File file) {
        try {
            this.SetData(MicroPeak.ReadFile(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, fileNotFoundException.getMessage(), "Cannot open file", 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, iOException.getMessage(), "File Read Error", 0);
        }
    }

    private void SelectFile() {
        MicroFileChooser microFileChooser = new MicroFileChooser(this);
        File file = microFileChooser.runDialog();
        if (file != null) {
            this.OpenFile(file);
        }
    }

    private void Preferences() {
        new AltosUIConfigure(this);
    }

    private void DownloadData() {
        AltosDevice altosDevice = MicroDeviceDialog.show(this);
        if (altosDevice != null) {
            new MicroDownload(this, altosDevice);
        }
    }

    private void no_data() {
        JOptionPane.showMessageDialog(this, "No data available", "No data", 1);
    }

    private void Save() {
        if (this.data == null) {
            this.no_data();
            return;
        }
        MicroSave microSave = new MicroSave(this, this.data);
        if (microSave.runDialog()) {
            this.SetName(this.data.name);
        }
    }

    private void Export() {
        if (this.data == null) {
            this.no_data();
            return;
        }
        MicroExport microExport = new MicroExport(this, this.data);
        microExport.runDialog();
    }

    private static void CommandGraph(File file) {
        MicroPeak microPeak = new MicroPeak();
        microPeak.OpenFile(file);
    }

    private static void CommandExport(File file) {
        try {
            MicroData microData = MicroPeak.ReadFile(file);
            if (microData != null) {
                File file2 = new File(AltosLib.replace_extension(file.getPath(), ".csv"));
                try {
                    System.out.printf("Export \"%s\" to \"%s\"\n", file.getPath(), file2.getPath());
                    MicroExport.export(file2, microData);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    System.err.printf("Cannot create file \"%s\" (%s)\n", file2.getName(), fileNotFoundException.getMessage());
                }
                catch (IOException iOException) {
                    System.err.printf("Cannot write file \"%s\" (%s)\n", file2.getName(), iOException.getMessage());
                }
            }
        }
        catch (IOException iOException) {
            System.err.printf("Cannot read file \"%s\" (%s)\n", file.getName(), iOException.getMessage());
        }
    }

    private void Close() {
        this.setVisible(false);
        this.dispose();
        if (--number_of_windows == 0) {
            System.exit(0);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (open_command.equals(actionEvent.getActionCommand())) {
            this.SelectFile();
        } else if (save_command.equals(actionEvent.getActionCommand())) {
            this.Save();
        } else if (export_command.equals(actionEvent.getActionCommand())) {
            this.Export();
        } else if (preferences_command.equals(actionEvent.getActionCommand())) {
            this.Preferences();
        } else if (close_command.equals(actionEvent.getActionCommand())) {
            this.Close();
        } else if (exit_command.equals(actionEvent.getActionCommand())) {
            System.exit(0);
        } else if (download_command.equals(actionEvent.getActionCommand())) {
            this.DownloadData();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
    }

    @Override
    public void macosx_file_handler(String string) {
        MicroPeak.CommandGraph(new File(string));
    }

    @Override
    public void macosx_quit_handler() {
        System.exit(0);
    }

    @Override
    public void macosx_preferences_handler() {
        this.Preferences();
    }

    @Override
    public void filter_changed(double d, double d2) {
        this.data.flight_series.set_filter(d, d2);
        this.graph.filter_changed();
        this.data.flight_stats = new AltosFlightStats(this.data.flight_series);
        this.statsTable.filter_changed(this.data.flight_stats);
    }

    @Override
    public double speed_filter() {
        if (this.data != null && this.data.flight_series != null) {
            return this.data.flight_series.speed_filter_width;
        }
        return 4.0;
    }

    @Override
    public double accel_filter() {
        if (this.data != null && this.data.flight_series != null) {
            return this.data.flight_series.accel_filter_width;
        }
        return 1.0;
    }

    private void add_menu(JMenu jMenu, String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(string2);
    }

    private void make_menu(String string, String[][] stringArray) {
        JMenu jMenu = new JMenu(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (MAC_OS_X && (stringArray[i][1].equals(exit_command) || stringArray[i][1].equals(preferences_command))) continue;
            this.add_menu(jMenu, stringArray[i][0], stringArray[i][1]);
        }
        this.menu_bar.add(jMenu);
    }

    public MicroPeak() {
        JComponent jComponent;
        ++number_of_windows;
        this.register_for_macosx_events();
        AltosUIPreferences.set_component(this);
        this.container = this.getContentPane();
        this.pane = new JTabbedPane();
        this.setTitle("MicroPeak");
        this.menu_bar = new JMenuBar();
        this.setJMenuBar(this.menu_bar);
        this.make_menu("File", file_menu_entries);
        if (MAC_OS_X) {
            this.make_menu(download_label, download_menu_entries);
        } else {
            jComponent = new JButton(download_label);
            jComponent.setActionCommand(download_command);
            jComponent.addActionListener(this);
            this.menu_bar.add(jComponent);
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MicroPeak.this.statsTable.tell_closing();
                MicroPeak.this.raw.tell_closing();
                MicroPeak.this.Close();
            }
        });
        this.enable = new AltosUIEnable(this);
        this.graph = new AltosGraph(this.enable);
        this.statsTable = new AltosFlightStatsTable();
        this.raw = new MicroRaw();
        this.pane.add((Component)this.graph.panel, "Graph");
        this.pane.add((Component)this.enable, "Configure Graph");
        this.pane.add((Component)this.statsTable, "Statistics");
        jComponent = new JScrollPane(this.raw);
        this.pane.add((Component)jComponent, "Raw Data");
        this.pane.doLayout();
        this.pane.validate();
        this.container.add(this.pane);
        this.container.doLayout();
        this.container.validate();
        this.doLayout();
        this.validate();
        Insets insets = this.getInsets();
        Dimension dimension = this.pane.getPreferredSize();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        this.setSize(dimension);
        this.pack();
        this.setVisible(true);
    }

    public static void help(int n) {
        System.out.printf("Usage: micropeak [OPTION] ... [FILE]...\n", new Object[0]);
        System.out.printf("  Options:\n", new Object[0]);
        System.out.printf("    --csv\tgenerate comma separated output for spreadsheets, etc\n", new Object[0]);
        System.out.printf("    --graph\tgraph a flight\n", new Object[0]);
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        boolean bl2 = true;
        try {
            UIManager.setLookAndFeel(AltosUIPreferences.look_and_feel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--help")) {
                MicroPeak.help(0);
                continue;
            }
            if (stringArray[i].equals("--export")) {
                bl2 = false;
                continue;
            }
            if (stringArray[i].equals("--graph")) {
                bl2 = true;
                continue;
            }
            if (stringArray[i].startsWith("--")) {
                MicroPeak.help(1);
                continue;
            }
            File file = new File(stringArray[i]);
            try {
                if (bl2) {
                    MicroPeak.CommandGraph(file);
                } else {
                    MicroPeak.CommandExport(file);
                }
                bl = true;
                continue;
            }
            catch (Exception exception) {
                System.err.printf("Error processing \"%s\": %s %s\n", file.getName(), exception.toString(), exception.getMessage());
                exception.printStackTrace();
            }
        }
        if (!bl) {
            new MicroPeak();
        }
    }

    static {
        file_menu_entries = new String[][]{{"Open", open_command}, {"Save a Copy", save_command}, {"Export Data", export_command}, {"Preferences", preferences_command}, {"Close", close_command}, {"Exit", exit_command}};
        download_menu_entries = new String[][]{{download_label, download_command}};
    }
}

