/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosFontListener;
import org.altusmetrum.altoslib_14.AltosLatLon;
import org.altusmetrum.altoslib_14.AltosLaunchSite;
import org.altusmetrum.altoslib_14.AltosLaunchSiteListener;
import org.altusmetrum.altoslib_14.AltosLaunchSites;
import org.altusmetrum.altoslib_14.AltosMapLoader;
import org.altusmetrum.altoslib_14.AltosMapLoaderListener;
import org.altusmetrum.altoslib_14.AltosPreferences;
import org.altusmetrum.altoslib_14.AltosUnitsListener;
import org.altusmetrum.altosuilib_14.AltosSerial;
import org.altusmetrum.altosuilib_14.AltosUIFrame;
import org.altusmetrum.altosuilib_14.AltosUIMap;
import org.altusmetrum.altosuilib_14.AltosUIMapPos;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;

public class AltosUIMapPreload
extends AltosUIFrame
implements ActionListener,
ItemListener,
AltosLaunchSiteListener,
AltosMapLoaderListener,
AltosUnitsListener,
AltosFontListener {
    AltosUIFrame owner;
    AltosUIMap map;
    AltosUIMapPos lat;
    AltosUIMapPos lon;
    JProgressBar pbar;
    JLabel site_list_label;
    List<AltosLaunchSite> sites;
    JComboBox<AltosLaunchSite> site_list;
    JToggleButton load_button;
    JButton close_button;
    JComboBox<Integer> min_zoom;
    JComboBox<Integer> max_zoom;
    JLabel radius_label;
    JComboBox<Double> radius;
    int scale = 1;
    Integer[] zooms = new Integer[]{-12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6};
    Double[] radius_mi = new Double[]{1.0, 2.0, 5.0, 10.0, 20.0};
    Double radius_def_mi = 5.0;
    Double[] radius_km = new Double[]{2.0, 5.0, 10.0, 20.0, 30.0};
    Double radius_def_km = 10.0;
    AltosMapLoader loader;
    static final String[] lat_hemi_names = new String[]{"N", "S"};
    static final String[] lon_hemi_names = new String[]{"E", "W"};
    double latitude;
    double longitude;
    long loader_notify_time;

    public void loader_start(final int n) {
        this.loader_notify_time = System.currentTimeMillis();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AltosUIMapPreload.this.pbar.setMaximum(n);
                AltosUIMapPreload.this.pbar.setValue(0);
                AltosUIMapPreload.this.pbar.setString("");
            }
        });
    }

    public void loader_notify(final int n, int n2, final String string) {
        long l = System.currentTimeMillis();
        if (l - this.loader_notify_time < 100L) {
            return;
        }
        this.loader_notify_time = l;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AltosUIMapPreload.this.pbar.setValue(n);
                AltosUIMapPreload.this.pbar.setString(string);
            }
        });
    }

    public void loader_done(int n) {
        this.loader = null;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AltosUIMapPreload.this.pbar.setValue(0);
                AltosUIMapPreload.this.pbar.setString("");
                AltosUIMapPreload.this.load_button.setSelected(false);
            }
        });
    }

    public void debug(String string, Object ... objectArray) {
        if (AltosSerial.debug) {
            System.out.printf(string, objectArray);
        }
    }

    private int all_types() {
        return 1;
    }

    void add_mark(double d, double d2, int n, String string) {
        this.map.add_mark(d, d2, n, string);
    }

    void reset_marks() {
        this.map.clear_marks();
        AltosLatLon altosLatLon = null;
        String string = null;
        if (this.map != null && this.map.map != null) {
            altosLatLon = this.map.map.centre;
        }
        for (AltosLaunchSite altosLaunchSite : this.sites) {
            if (altosLatLon != null && altosLatLon.lat == altosLaunchSite.latitude && altosLatLon.lon == altosLaunchSite.longitude) {
                string = altosLaunchSite.name;
                continue;
            }
            this.add_mark(altosLaunchSite.latitude, altosLaunchSite.longitude, 7, altosLaunchSite.name);
        }
        if (altosLatLon != null) {
            this.add_mark(altosLatLon.lat, altosLatLon.lon, 3, string);
        }
    }

    void center_map(double d, double d2) {
        this.map.map.centre(new AltosLatLon(d, d2));
        this.reset_marks();
    }

    void center_map() {
        try {
            this.center_map(this.lat.get_value(), this.lon.get_value());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object;
        int n = itemEvent.getStateChange();
        if (n == 1 && (object = itemEvent.getItem()) instanceof AltosLaunchSite) {
            AltosLaunchSite altosLaunchSite = (AltosLaunchSite)object;
            this.lat.set_value(altosLaunchSite.latitude);
            this.lon.set_value(altosLaunchSite.longitude);
            this.center_map(altosLaunchSite.latitude, altosLaunchSite.longitude);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("close")) {
            if (this.loader != null) {
                this.loader.abort();
            }
            this.setVisible(false);
        }
        if (string.equals("load") && this.loader == null) {
            try {
                this.latitude = this.lat.get_value();
                this.longitude = this.lon.get_value();
                int n = (Integer)this.min_zoom.getSelectedItem();
                int n2 = (Integer)this.max_zoom.getSelectedItem();
                if (n2 < n) {
                    n2 = n;
                }
                Double d = (Double)this.radius.getSelectedItem();
                d = AltosPreferences.imperial_units() ? Double.valueOf(AltosConvert.miles_to_meters((double)d)) : Double.valueOf(d * 1000.0);
                this.center_map(this.latitude, this.longitude);
                this.loader = new AltosMapLoader((AltosMapLoaderListener)this, this.latitude, this.longitude, n, n2, d.doubleValue(), this.all_types(), this.scale);
            }
            catch (ParseException parseException) {
                this.load_button.setSelected(false);
            }
        }
    }

    public void notify_launch_sites(final List<AltosLaunchSite> list) {
        this.sites = list;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int n = 1;
                for (AltosLaunchSite altosLaunchSite : list) {
                    AltosUIMapPreload.this.site_list.insertItemAt(altosLaunchSite, n);
                    ++n;
                }
                AltosUIMapPreload.this.reset_marks();
            }
        });
    }

    private void set_radius_values() {
        this.radius_label.setText(String.format("Map Radius (%s)", AltosPreferences.imperial_units() ? "mi" : "km"));
        Double[] doubleArray = AltosPreferences.imperial_units() ? this.radius_mi : this.radius_km;
        this.radius.removeAllItems();
        for (Double d : doubleArray) {
            this.radius.addItem(d);
        }
        this.radius.setSelectedItem(doubleArray[2]);
        this.radius.setMaximumRowCount(doubleArray.length);
    }

    public void units_changed(boolean bl) {
        this.map.units_changed(bl);
        this.set_radius_values();
    }

    public void font_size_changed(int n) {
        this.map.font_size_changed(n);
    }

    public AltosUIMapPreload(AltosUIFrame altosUIFrame) {
        this.owner = altosUIFrame;
        Container container = this.getScrollablePane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(4, 4, 4, 4);
        this.setTitle("AltOS Load Maps");
        container.setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AltosUIPreferences.unregister_font_listener(AltosUIMapPreload.this);
                AltosPreferences.unregister_units_listener((AltosUnitsListener)AltosUIMapPreload.this);
            }
        });
        AltosPreferences.register_units_listener((AltosUnitsListener)this);
        AltosUIPreferences.register_font_listener(this);
        this.map = new AltosUIMap();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.anchor = 10;
        container.add((Component)this.map, gridBagConstraints);
        this.pbar = new JProgressBar();
        this.pbar.setMinimum(0);
        this.pbar.setMaximum(1);
        this.pbar.setValue(0);
        this.pbar.setString("");
        this.pbar.setStringPainted(true);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 10;
        container.add((Component)this.pbar, gridBagConstraints);
        this.site_list_label = new JLabel("Known Launch Sites:");
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        container.add((Component)this.site_list_label, gridBagConstraints);
        this.site_list = new JComboBox<AltosLaunchSite>(new AltosLaunchSite[]{new AltosLaunchSite("Site List", 0.0, 0.0)});
        this.site_list.addItemListener(this);
        new AltosLaunchSites((AltosLaunchSiteListener)this);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        container.add(this.site_list, gridBagConstraints);
        this.lat = new AltosUIMapPos(this.owner, this, "Latitude:", lat_hemi_names, 37.167833333);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        container.add((Component)this.lat, gridBagConstraints);
        this.lon = new AltosUIMapPos(this.owner, this, "Longitude:", lon_hemi_names, -97.73975);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        container.add((Component)this.lon, gridBagConstraints);
        this.load_button = new JToggleButton("Load Map");
        this.load_button.addActionListener(this);
        this.load_button.setActionCommand("load");
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        container.add((Component)this.load_button, gridBagConstraints);
        this.close_button = new JButton("Close");
        this.close_button.addActionListener(this);
        this.close_button.setActionCommand("close");
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        container.add((Component)this.close_button, gridBagConstraints);
        JLabel jLabel = new JLabel("Minimum Zoom");
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        container.add((Component)jLabel, gridBagConstraints);
        this.min_zoom = new JComboBox<Integer>(this.zooms);
        this.min_zoom.setSelectedItem(this.zooms[10]);
        this.min_zoom.setEditable(false);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        container.add(this.min_zoom, gridBagConstraints);
        JLabel jLabel2 = new JLabel("Maximum Zoom");
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        container.add((Component)jLabel2, gridBagConstraints);
        this.max_zoom = new JComboBox<Integer>(this.zooms);
        this.max_zoom.setSelectedItem(this.zooms[14]);
        this.max_zoom.setEditable(false);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        container.add(this.max_zoom, gridBagConstraints);
        this.radius_label = new JLabel();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        container.add((Component)this.radius_label, gridBagConstraints);
        this.radius = new JComboBox();
        this.radius.setEditable(true);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        container.add(this.radius, gridBagConstraints);
        this.set_radius_values();
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.setVisible(true);
    }
}

