/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosFlightDisplay;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosImage;
import org.altusmetrum.altoslib_14.AltosLatLon;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosMap;
import org.altusmetrum.altoslib_14.AltosMapCache;
import org.altusmetrum.altoslib_14.AltosMapInterface;
import org.altusmetrum.altoslib_14.AltosMapLine;
import org.altusmetrum.altoslib_14.AltosMapMark;
import org.altusmetrum.altoslib_14.AltosMapPath;
import org.altusmetrum.altoslib_14.AltosMapPathPoint;
import org.altusmetrum.altoslib_14.AltosMapTile;
import org.altusmetrum.altoslib_14.AltosMapTransform;
import org.altusmetrum.altoslib_14.AltosPointDouble;
import org.altusmetrum.altoslib_14.AltosPointInt;
import org.altusmetrum.altoslib_14.AltosRectangle;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altoslib_14.AltosUIImage;
import org.altusmetrum.altosuilib_14.AltosUILib;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;

public class AltosUIMap
extends JComponent
implements AltosFlightDisplay,
AltosMapInterface {
    AltosMap map;
    Graphics2D g;
    Font tile_font;
    Font line_font;
    AltosMapMark nearest_mark;
    public static final Color[] stateColors = new Color[]{Color.WHITE, Color.WHITE, Color.WHITE, Color.RED, Color.PINK, Color.YELLOW, Color.CYAN, Color.BLUE, Color.BLACK, Color.BLACK, Color.CYAN};
    JLabel zoom_label;
    JLabel nearest_label;
    private GridBagLayout layout = new GridBagLayout();
    MapView view;

    static Point2D.Double point2d(AltosPointDouble altosPointDouble) {
        return new Point2D.Double(altosPointDouble.x, altosPointDouble.y);
    }

    static final AltosPointDouble point_double(Point point) {
        return new AltosPointDouble(point.x, point.y);
    }

    public AltosMapPath new_path() {
        return new MapPath();
    }

    public AltosMapLine new_line() {
        return new MapLine();
    }

    public AltosImage load_image(File file) throws Exception {
        return new AltosUIImage(ImageIO.read(file));
    }

    public AltosMapMark new_mark(double d, double d2, int n) {
        return new MapMark(d, d2, n);
    }

    public AltosMapMark new_mark(double d, double d2, int n, String string) {
        return new MapMark(d, d2, n, string);
    }

    public AltosMapTile new_tile(AltosMapCache altosMapCache, AltosLatLon altosLatLon, AltosLatLon altosLatLon2, int n, int n2, int n3, int n4) {
        return new MapTile(altosMapCache, altosLatLon, altosLatLon2, n, n2, n3, n4);
    }

    public int width() {
        return this.view.getWidth();
    }

    public int height() {
        return this.view.getHeight();
    }

    @Override
    public void repaint() {
        this.view.repaint();
    }

    public void repaint(AltosRectangle altosRectangle) {
        this.view.repaint(altosRectangle);
    }

    public void set_zoom_label(String string) {
        this.zoom_label.setText(string);
    }

    public void select_object(AltosLatLon altosLatLon) {
        this.debug("select at %f,%f\n", altosLatLon.lat, altosLatLon.lon);
    }

    public void debug(String string, Object ... objectArray) {
        if (AltosUIPreferences.serial_debug()) {
            System.out.printf(string, objectArray);
        }
    }

    public void set_font() {
        this.tile_font = AltosUILib.value_font;
        this.line_font = AltosUILib.status_font;
        if (this.nearest_label != null) {
            this.nearest_label.setFont(AltosUILib.value_font);
        }
    }

    public void font_size_changed(int n) {
        this.set_font();
        this.repaint();
    }

    public void units_changed(boolean bl) {
        this.repaint();
    }

    public void set_maptype(int n) {
    }

    public void set_zoom(int n) {
        this.map.set_zoom(n);
    }

    public void add_mark(double d, double d2, int n) {
        this.map.add_mark(d, d2, n);
    }

    public void add_mark(double d, double d2, int n, String string) {
        this.map.add_mark(d, d2, n, string);
    }

    public void clear_marks() {
        this.map.clear_marks();
    }

    public void reset() {
    }

    public void show(AltosState altosState, AltosListenerState altosListenerState) {
        this.map.show(altosState, altosListenerState);
    }

    public void show(AltosGPS altosGPS, double d, int n, double d2) {
        this.map.show(altosGPS, d, n, d2);
    }

    @Override
    public String getName() {
        return "Map";
    }

    public void centre(AltosState altosState) {
        this.map.centre(altosState);
    }

    public void centre(AltosGPS altosGPS) {
        this.map.centre(altosGPS);
    }

    public AltosUIMap() {
        this.set_font();
        this.view = new MapView();
        this.view.setPreferredSize(new Dimension(500, 500));
        this.view.setVisible(true);
        this.view.setEnabled(true);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.view, gridBagConstraints);
        int n = 0;
        this.zoom_label = new JLabel("", 0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.zoom_label, gridBagConstraints);
        JButton jButton = new JButton("0");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosMap cfr_ignored_0 = AltosUIMap.this.map;
                AltosUIMap.this.map.set_zoom(15);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jButton, gridBagConstraints);
        JButton jButton2 = new JButton("+");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUIMap.this.map.set_zoom(AltosUIMap.this.map.get_zoom() + 1);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jButton2, gridBagConstraints);
        JButton jButton3 = new JButton("-");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AltosUIMap.this.map.set_zoom(AltosUIMap.this.map.get_zoom() - 1);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jButton3, gridBagConstraints);
        this.nearest_label = new JLabel("", 2);
        this.nearest_label.setFont(this.tile_font);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        this.add((Component)this.nearest_label, gridBagConstraints);
        this.map = new AltosMap((AltosMapInterface)this);
    }

    class MapTile
    extends AltosMapTile {
        public MapTile(AltosMapCache altosMapCache, AltosLatLon altosLatLon, AltosLatLon altosLatLon2, int n, int n2, int n3, int n4) {
            super(altosMapCache, altosLatLon, altosLatLon2, n, n2, n3, n4);
        }

        public void paint(AltosMapTransform altosMapTransform) {
            AltosPointDouble altosPointDouble = altosMapTransform.screen(this.upper_left);
            Point point = new Point((int)(altosPointDouble.x + 0.5), (int)(altosPointDouble.y + 0.5));
            if (!AltosUIMap.this.g.hitClip(point.x, point.y, this.px_size, this.px_size)) {
                return;
            }
            AltosImage altosImage = this.get_image();
            AltosUIImage altosUIImage = (AltosUIImage)altosImage;
            Image image = null;
            if (altosUIImage != null) {
                image = altosUIImage.image;
            }
            if (image != null) {
                AltosUIMap.this.g.drawImage(image, point.x, point.y, null);
            } else {
                AltosUIMap.this.g.setColor(Color.GRAY);
                AltosUIMap.this.g.fillRect(point.x, point.y, this.px_size, this.px_size);
                if (altosMapTransform.has_location()) {
                    String string = null;
                    switch (this.status) {
                        case 2: {
                            string = "Fetching...";
                            break;
                        }
                        case 4: {
                            string = "Internal error";
                            break;
                        }
                        case 3: {
                            string = "Network error";
                            break;
                        }
                        case 5: {
                            string = "Outside of known launch areas";
                        }
                    }
                    if (string != null && AltosUIMap.this.tile_font != null) {
                        AltosUIMap.this.g.setFont(AltosUIMap.this.tile_font);
                        AltosUIMap.this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                        Rectangle2D rectangle2D = AltosUIMap.this.tile_font.getStringBounds(string, AltosUIMap.this.g.getFontRenderContext());
                        float f = (float)this.px_size / 2.0f;
                        float f2 = (float)this.px_size / 2.0f;
                        AltosUIMap.this.g.setColor(Color.BLACK);
                        AltosUIMap.this.g.drawString(string, (float)altosPointDouble.x + (f -= (float)rectangle2D.getWidth() / 2.0f), (float)altosPointDouble.y + (f2 += (float)rectangle2D.getHeight() / 2.0f));
                    }
                }
            }
        }
    }

    class MapPath
    extends AltosMapPath {
        MapPath() {
        }

        public void paint(AltosMapTransform altosMapTransform) {
            Point2D.Double double_ = null;
            AltosUIMap.this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            AltosUIMap.this.g.setStroke(new BasicStroke(stroke_width, 1, 1));
            for (AltosMapPathPoint altosMapPathPoint : this.points) {
                Point2D.Double double_2 = AltosUIMap.point2d(altosMapTransform.screen(altosMapPathPoint.gps.lat, altosMapPathPoint.gps.lon));
                if (double_ != null) {
                    Line2D.Double double_3 = new Line2D.Double(double_, double_2);
                    Rectangle rectangle = double_3.getBounds();
                    if (AltosUIMap.this.g.hitClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                        if (0 <= altosMapPathPoint.state && altosMapPathPoint.state < stateColors.length) {
                            AltosUIMap.this.g.setColor(stateColors[altosMapPathPoint.state]);
                        } else {
                            AltosUIMap.this.g.setColor(stateColors[9]);
                        }
                        AltosUIMap.this.g.draw(double_3);
                    }
                }
                double_ = double_2;
            }
        }
    }

    class MapLine
    extends AltosMapLine {
        public void paint(AltosMapTransform altosMapTransform) {
            if (this.start == null || this.end == null) {
                return;
            }
            AltosUIMap.this.g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Line2D.Double double_ = new Line2D.Double(AltosUIMap.point2d(altosMapTransform.screen(this.start)), AltosUIMap.point2d(altosMapTransform.screen(this.end)));
            AltosUIMap.this.g.setColor(Color.WHITE);
            AltosUIMap.this.g.setStroke(new BasicStroke(stroke_width + 4, 1, 1));
            AltosUIMap.this.g.draw(double_);
            AltosUIMap.this.g.setColor(Color.BLUE);
            AltosUIMap.this.g.setStroke(new BasicStroke(stroke_width, 1, 1));
            AltosUIMap.this.g.draw(double_);
            String string = this.line_dist();
            Rectangle2D rectangle2D = AltosUIMap.this.line_font.getStringBounds(string, AltosUIMap.this.g.getFontRenderContext());
            float f = (float)double_.x1;
            float f2 = (float)double_.y1 + (float)rectangle2D.getHeight() / 2.0f;
            f = double_.x1 < double_.x2 ? (f -= (float)rectangle2D.getWidth() + 2.0f) : (f += 2.0f);
            AltosUIMap.this.g.setFont(AltosUIMap.this.line_font);
            AltosUIMap.this.g.setColor(Color.WHITE);
            for (int i = -2; i <= 2; i += 2) {
                for (int j = -2; j <= 2; j += 2) {
                    AltosUIMap.this.g.drawString(string, f + (float)j, f2 + (float)i);
                }
            }
            AltosUIMap.this.g.setColor(Color.BLUE);
            AltosUIMap.this.g.drawString(string, f, f2);
        }
    }

    class MapView
    extends JComponent
    implements MouseMotionListener,
    MouseListener,
    ComponentListener,
    MouseWheelListener {
        private VolatileImage create_back_buffer() {
            return this.getGraphicsConfiguration().createCompatibleVolatileImage(this.getWidth(), this.getHeight());
        }

        private void do_paint(Graphics graphics) {
            AltosUIMap.this.g = (Graphics2D)graphics;
            AltosUIMap.this.map.paint();
        }

        @Override
        public void paint(Graphics graphics) {
            VolatileImage volatileImage = this.create_back_buffer();
            Graphics2D graphics2D = (Graphics2D)graphics;
            do {
                GraphicsConfiguration graphicsConfiguration;
                int n;
                if ((n = volatileImage.validate(graphicsConfiguration = this.getGraphicsConfiguration())) == 2) {
                    volatileImage = this.create_back_buffer();
                }
                Graphics graphics2 = volatileImage.getGraphics();
                graphics2.setClip(graphics2D.getClip());
                this.do_paint(graphics2);
                graphics2.dispose();
                graphics2D.drawImage(volatileImage, 0, 0, this);
            } while (volatileImage.contentsLost());
            volatileImage.flush();
        }

        public void repaint(AltosRectangle altosRectangle) {
            this.repaint(altosRectangle.x, altosRectangle.y, altosRectangle.width, altosRectangle.height);
        }

        private boolean is_drag_event(MouseEvent mouseEvent) {
            return mouseEvent.getModifiersEx() == 1024;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            AltosUIMap.this.map.touch_continue(mouseEvent.getPoint().x, mouseEvent.getPoint().y, this.is_drag_event(mouseEvent));
        }

        String pos(double d, String string, String string2) {
            if (d == 2.147483647E9) {
                return "";
            }
            String string3 = string;
            if (d < 0.0) {
                string3 = string2;
                d = -d;
            }
            int n = (int)Math.floor(d);
            double d2 = (d - Math.floor(d)) * 60.0;
            return String.format("%s %4d\u00b0 %9.6f'", string3, n, d2);
        }

        String height(double d, String string) {
            if (d == 2.147483647E9) {
                return "";
            }
            return String.format(" %s%s", AltosConvert.height.show(6, d), string);
        }

        String speed(double d, String string) {
            if (d == 2.147483647E9) {
                return "";
            }
            return String.format(" %s%s", AltosConvert.speed.show(6, d), string);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            AltosMapPathPoint altosMapPathPoint = AltosUIMap.this.map.nearest(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
            if (altosMapPathPoint != null) {
                if (AltosUIMap.this.nearest_mark == null) {
                    AltosUIMap.this.nearest_mark = AltosUIMap.this.map.add_mark(altosMapPathPoint.gps.lat, altosMapPathPoint.gps.lon, altosMapPathPoint.state);
                } else {
                    AltosUIMap.this.nearest_mark.lat_lon.lat = altosMapPathPoint.gps.lat;
                    AltosUIMap.this.nearest_mark.lat_lon.lon = altosMapPathPoint.gps.lon;
                    AltosUIMap.this.nearest_mark.state = altosMapPathPoint.state;
                }
                AltosUIMap.this.nearest_label.setText(String.format("%9.2f sec %s%s%s%s", altosMapPathPoint.time, this.pos(altosMapPathPoint.gps.lat, "N", "S"), this.pos(altosMapPathPoint.gps.lon, "E", "W"), this.height(altosMapPathPoint.gps_height, ""), this.speed(altosMapPathPoint.gps.ground_speed, "(h)"), this.speed(altosMapPathPoint.gps.climb_rate, "(v)")));
            } else {
                AltosUIMap.this.nearest_label.setText("");
            }
            this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            AltosUIMap.this.map.touch_start(mouseEvent.getPoint().x, mouseEvent.getPoint().y, this.is_drag_event(mouseEvent));
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            int n = mouseWheelEvent.getWheelRotation();
            AltosUIMap.this.map.set_zoom_centre(AltosUIMap.this.map.get_zoom() - n, new AltosPointInt(mouseWheelEvent.getPoint().x, mouseWheelEvent.getPoint().y));
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            AltosUIMap.this.map.set_transform();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            AltosUIMap.this.map.set_transform();
        }

        MapView() {
            this.addComponentListener(this);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.addMouseWheelListener(this);
        }
    }

    class MapMark
    extends AltosMapMark {
        public void paint(AltosMapTransform altosMapTransform) {
            double d = this.lat_lon.lat;
            double d2 = altosMapTransform.first_lon(this.lat_lon.lon);
            double d3 = altosMapTransform.last_lon(this.lat_lon.lon);
            for (double d4 = d2; d4 <= d3; d4 += 360.0) {
                AltosPointDouble altosPointDouble = altosMapTransform.screen(d, d4);
                AltosUIMap.this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                AltosUIMap.this.g.setStroke(new BasicStroke(stroke_width, 1, 1));
                if (0 <= this.state && this.state < stateColors.length) {
                    AltosUIMap.this.g.setColor(stateColors[this.state]);
                } else {
                    AltosUIMap.this.g.setColor(stateColors[9]);
                }
                AltosUIMap.this.g.drawOval((int)altosPointDouble.x - 5, (int)altosPointDouble.y - 5, 10, 10);
                AltosUIMap.this.g.drawOval((int)altosPointDouble.x - 20, (int)altosPointDouble.y - 20, 40, 40);
                AltosUIMap.this.g.drawOval((int)altosPointDouble.x - 35, (int)altosPointDouble.y - 35, 70, 70);
                if (this.label == null) continue;
                Rectangle2D rectangle2D = AltosUIMap.this.line_font.getStringBounds(this.label, AltosUIMap.this.g.getFontRenderContext());
                float f = (float)altosPointDouble.x;
                float f2 = (float)altosPointDouble.y + (float)rectangle2D.getHeight() / 2.0f;
                AltosUIMap.this.g.setFont(AltosUIMap.this.line_font);
                AltosUIMap.this.g.setColor(Color.WHITE);
                for (int i = -2; i <= 2; i += 2) {
                    for (int j = -2; j <= 2; j += 2) {
                        AltosUIMap.this.g.drawString(this.label, f + (float)j, f2 + (float)i);
                    }
                }
                if (0 <= this.state && this.state < stateColors.length) {
                    AltosUIMap.this.g.setColor(stateColors[this.state]);
                } else {
                    AltosUIMap.this.g.setColor(stateColors[9]);
                }
                AltosUIMap.this.g.drawString(this.label, f, f2);
            }
        }

        MapMark(double d, double d2, int n, String string) {
            super(d, d2, n, string);
        }

        MapMark(double d, double d2, int n) {
            super(d, d2, n);
        }
    }
}

