/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.GridBagLayout;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.LinkedList;
import javax.swing.JComponent;
import org.altusmetrum.altoslib_14.AltosFlightDisplay;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altosuilib_14.AltosUIIndicator;

public abstract class AltosUIFlightTab
extends JComponent
implements AltosFlightDisplay,
HierarchyListener {
    public GridBagLayout layout;
    AltosState last_state;
    AltosListenerState last_listener_state;
    LinkedList<AltosUIIndicator> indicators = new LinkedList();

    public void add(AltosUIIndicator altosUIIndicator) {
        this.indicators.add(altosUIIndicator);
    }

    public void remove(AltosUIIndicator altosUIIndicator) {
        this.indicators.remove(altosUIIndicator);
    }

    public void reset() {
        for (AltosUIIndicator altosUIIndicator : this.indicators) {
            altosUIIndicator.reset();
        }
    }

    public void font_size_changed(int n) {
        for (AltosUIIndicator altosUIIndicator : this.indicators) {
            altosUIIndicator.font_size_changed(n);
        }
    }

    public void units_changed(boolean bl) {
        for (AltosUIIndicator altosUIIndicator : this.indicators) {
            altosUIIndicator.units_changed(bl);
        }
    }

    public void show(AltosState altosState, AltosListenerState altosListenerState) {
        if (!this.isShowing()) {
            this.last_state = altosState;
            this.last_listener_state = altosListenerState;
            return;
        }
        for (AltosUIIndicator altosUIIndicator : this.indicators) {
            altosUIIndicator.show(altosState, altosListenerState);
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
        if (this.last_state != null && this.isShowing()) {
            AltosState altosState = this.last_state;
            AltosListenerState altosListenerState = this.last_listener_state;
            this.last_state = null;
            this.last_listener_state = null;
            this.show(altosState, altosListenerState);
        }
    }

    @Override
    public abstract String getName();

    public AltosUIFlightTab() {
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        this.addHierarchyListener(this);
    }
}

