/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.altusmetrum.altoslib_14.AltosAccelCal;
import org.altusmetrum.altoslib_14.AltosAccelCalListener;
import org.altusmetrum.altoslib_14.AltosConfigValues;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altosuilib_14.AltosUIDialog;

public class AltosUIAccelCal
extends AltosUIDialog
implements AltosAccelCalListener,
ActionListener {
    Frame owner;
    AltosLink link;
    AltosAccelCal cal;
    AltosConfigValues config_values;
    Thread thread;
    Container pane;
    JTextField message;
    JButton antenna_up;
    JButton antenna_down;
    JButton ok;
    JButton cancel;
    boolean success;
    int accel_plus;
    int accel_minus;

    private void make_visible() {
        this.pack();
        this.cal.start();
        this.setVisible(true);
    }

    public boolean doit() {
        this.success = false;
        this.make_visible();
        return this.success;
    }

    public int accel_cal_plus() {
        if (this.success) {
            return this.accel_plus;
        }
        return Integer.MAX_VALUE;
    }

    public int accel_cal_minus() {
        if (this.success) {
            return this.accel_minus;
        }
        return Integer.MAX_VALUE;
    }

    private void setDefaultButton(JButton jButton) {
        this.getRootPane().setDefaultButton(jButton);
    }

    public void set_thread(AltosAccelCal altosAccelCal, Thread thread) {
        this.thread = thread;
    }

    public void set_phase(AltosAccelCal altosAccelCal, final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                switch (n) {
                    case 0: {
                        AltosUIAccelCal.this.message.setText("Orient antenna upwards and click on Antenna Up");
                        AltosUIAccelCal.this.antenna_up.setEnabled(true);
                        AltosUIAccelCal.this.setDefaultButton(AltosUIAccelCal.this.antenna_up);
                        AltosUIAccelCal.this.antenna_down.setEnabled(false);
                        AltosUIAccelCal.this.ok.setEnabled(false);
                        break;
                    }
                    case 1: {
                        AltosUIAccelCal.this.message.setText("Orient antenna downwards and click on Antenna Down");
                        AltosUIAccelCal.this.antenna_up.setEnabled(false);
                        AltosUIAccelCal.this.antenna_down.setEnabled(true);
                        AltosUIAccelCal.this.setDefaultButton(AltosUIAccelCal.this.antenna_down);
                        AltosUIAccelCal.this.ok.setEnabled(false);
                    }
                }
            }
        });
    }

    public void cal_done(AltosAccelCal altosAccelCal, int n, int n2) {
        this.accel_plus = n;
        this.accel_minus = n2;
        this.success = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AltosUIAccelCal.this.message.setText(String.format("Calibration succeeded, plus %d minus %d, press OK to continue", AltosUIAccelCal.this.accel_plus, AltosUIAccelCal.this.accel_minus));
                AltosUIAccelCal.this.antenna_up.setEnabled(false);
                AltosUIAccelCal.this.antenna_down.setEnabled(false);
                AltosUIAccelCal.this.ok.setEnabled(true);
                AltosUIAccelCal.this.setDefaultButton(AltosUIAccelCal.this.ok);
            }
        });
    }

    public void message(AltosAccelCal altosAccelCal, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AltosUIAccelCal.this.message.setText(string);
            }
        });
    }

    public void error(AltosAccelCal altosAccelCal, String string) {
        this.message(altosAccelCal, string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("up".equals(string)) {
            this.cal.signal(true);
            this.antenna_up.setEnabled(false);
        } else if ("down".equals(string)) {
            this.cal.signal(true);
            this.antenna_down.setEnabled(false);
            this.setDefaultButton(this.antenna_down);
        } else if ("ok".equals(string)) {
            this.cal.signal(true);
            this.setVisible(false);
            if (this.success) {
                this.config_values.set_accel_cal(this.accel_plus, this.accel_minus);
                this.config_values.set_dirty();
            }
            try {
                this.cal.abort();
            }
            catch (InterruptedException interruptedException) {}
        } else if ("cancel".equals(string)) {
            this.cal.signal(false);
            this.setVisible(false);
            try {
                this.cal.abort();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public AltosUIAccelCal(Frame frame, AltosLink altosLink, AltosConfigValues altosConfigValues) {
        super(frame, "Calibrate Accelerometer", true);
        this.owner = frame;
        this.link = altosLink;
        this.config_values = altosConfigValues;
        this.pane = this.getScrollablePane();
        this.pane.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        int n = 0;
        int n2 = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2++;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.message = new JTextField(64);
        this.pane.add((Component)this.message, gridBagConstraints);
        n = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.antenna_up = new JButton("Antenna Up");
        this.antenna_up.setActionCommand("up");
        this.antenna_up.setEnabled(false);
        this.antenna_up.addActionListener(this);
        this.pane.add((Component)this.antenna_up, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.antenna_down = new JButton("Antenna Down");
        this.antenna_down.setActionCommand("down");
        this.antenna_down.setEnabled(false);
        this.antenna_down.addActionListener(this);
        this.pane.add((Component)this.antenna_down, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = n++;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.ok = new JButton("OK");
        this.ok.setActionCommand("ok");
        this.ok.setEnabled(false);
        this.ok.addActionListener(this);
        this.pane.add((Component)this.ok, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        this.cancel = new JButton("Cancel");
        this.cancel.setActionCommand("cancel");
        this.cancel.setEnabled(true);
        this.cancel.addActionListener(this);
        this.pane.add((Component)this.cancel, gridBagConstraints);
        this.cal = new AltosAccelCal(this.link, (AltosAccelCalListener)this);
    }
}

