/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosRomconfig;
import org.altusmetrum.altosuilib_14.AltosUIDialog;

public class AltosRomconfigUI
extends AltosUIDialog
implements ActionListener {
    Container pane;
    Box box;
    JLabel product_label;
    JLabel serial_label;
    JLabel radio_calibration_label;
    JLabel product_value;
    JFrame owner;
    JTextField serial_value;
    JTextField radio_calibration_value;
    JButton ok;
    JButton cancel;
    boolean selected;

    public AltosRomconfigUI(JFrame jFrame, AltosRomconfig altosRomconfig) {
        super(jFrame, "Configure Rom Values", true);
        this.owner = jFrame;
        Insets insets = new Insets(4, 4, 4, 4);
        Insets insets2 = new Insets(4, 4, 4, 4);
        this.pane = this.getScrollablePane();
        this.pane.setLayout(new GridBagLayout());
        int n = 0;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        this.product_label = new JLabel("Product:");
        this.pane.add((Component)this.product_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        String string = "unknown";
        if (altosRomconfig != null) {
            string = altosRomconfig.usb_product;
        }
        this.product_value = new JLabel(string);
        this.pane.add((Component)this.product_value, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = ++n;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        this.serial_label = new JLabel("Serial:");
        this.pane.add((Component)this.serial_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets2;
        this.serial_value = new JTextField("00000000");
        this.pane.add((Component)this.serial_value, gridBagConstraints);
        if (altosRomconfig == null || AltosLib.has_radio((int)altosRomconfig.usb_id.pid)) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = insets;
            gridBagConstraints.ipady = 5;
            this.radio_calibration_label = new JLabel("Radio Calibration:");
            this.pane.add((Component)this.radio_calibration_label, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 3;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = insets2;
            gridBagConstraints.ipady = 5;
            this.radio_calibration_value = new JTextField("00000000");
            this.pane.add((Component)this.radio_calibration_value, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        this.ok = new JButton("OK");
        this.pane.add((Component)this.ok, gridBagConstraints);
        this.ok.addActionListener(this);
        this.ok.setActionCommand("ok");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n++;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        this.cancel = new JButton("Cancel");
        this.pane.add((Component)this.cancel, gridBagConstraints);
        this.cancel.addActionListener(this);
        this.cancel.setActionCommand("cancel");
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.set(altosRomconfig);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ok")) {
            AltosRomconfig altosRomconfig = this.romconfig();
            if (altosRomconfig == null || !altosRomconfig.valid()) {
                JOptionPane.showMessageDialog(this, "Invalid serial number or radio calibration value", "Invalid rom configuration", 0);
                return;
            }
            this.selected = true;
        }
        this.setVisible(false);
    }

    int serial() {
        return Integer.parseInt(this.serial_value.getText());
    }

    void set_serial(int n) {
        this.serial_value.setText(String.format("%d", n));
    }

    int radio_calibration() {
        if (this.radio_calibration_value == null) {
            return 0;
        }
        return Integer.parseInt(this.radio_calibration_value.getText());
    }

    void set_radio_calibration(int n) {
        if (this.radio_calibration_value == null) {
            return;
        }
        this.radio_calibration_value.setText(String.format("%d", n));
    }

    public void set(AltosRomconfig altosRomconfig) {
        if (altosRomconfig != null && altosRomconfig.valid()) {
            this.set_serial(altosRomconfig.serial_number);
            this.set_radio_calibration(altosRomconfig.radio_calibration);
        }
    }

    AltosRomconfig romconfig() {
        try {
            return new AltosRomconfig(this.serial(), this.radio_calibration());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public AltosRomconfig showDialog() {
        this.setVisible(true);
        if (this.selected) {
            return this.romconfig();
        }
        return null;
    }

    public static AltosRomconfig show(JFrame jFrame, AltosRomconfig altosRomconfig) {
        AltosRomconfigUI altosRomconfigUI = new AltosRomconfigUI(jFrame, altosRomconfig);
        return altosRomconfigUI.showDialog();
    }
}

