/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.altusmetrum.altoslib_14.AltosCSV;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosFlightSeries;
import org.altusmetrum.altoslib_14.AltosKML;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosWriter;
import org.altusmetrum.altosuilib_14.AltosUIDialog;

public class AltosCSVUI
extends AltosUIDialog
implements ActionListener {
    JFileChooser csv_chooser;
    JPanel accessory;
    JComboBox<String> combo_box;
    AltosFlightSeries series;
    AltosCalData cal_data;
    AltosWriter writer;
    static String[] combo_box_items = new String[]{"Comma Separated Values (.CSV)", "Googleearth Data (.KML)"};

    void set_default_file() {
        File file = this.csv_chooser.getSelectedFile();
        String string = file.getName();
        String string2 = null;
        String string3 = (String)this.combo_box.getSelectedItem();
        if (string3.contains("CSV")) {
            string2 = AltosLib.replace_extension((String)string, (String)".csv");
        } else if (string3.contains("KML")) {
            string2 = AltosLib.replace_extension((String)string, (String)".kml");
        }
        if (string2 != null) {
            this.csv_chooser.setSelectedFile(new File(string2));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("comboBoxChanged")) {
            this.set_default_file();
        }
    }

    public AltosCSVUI(JFrame jFrame, AltosFlightSeries altosFlightSeries, File file) {
        this.series = altosFlightSeries;
        this.cal_data = altosFlightSeries.cal_data();
        this.csv_chooser = new JFileChooser(file);
        this.accessory = new JPanel();
        this.accessory.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        JLabel jLabel = new JLabel("Export File Type");
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.accessory.add((Component)jLabel, gridBagConstraints);
        this.combo_box = new JComboBox<String>(combo_box_items);
        this.combo_box.addActionListener(this);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.accessory.add(this.combo_box, gridBagConstraints);
        this.csv_chooser.setAccessory(this.accessory);
        this.csv_chooser.setSelectedFile(file);
        this.set_default_file();
        int n = this.csv_chooser.showSaveDialog(jFrame);
        if (n == 0) {
            File file2 = this.csv_chooser.getSelectedFile();
            String string = (String)this.combo_box.getSelectedItem();
            try {
                this.writer = string.contains("CSV") ? new AltosCSV(file2) : new AltosKML(file2);
                this.writer.write(altosFlightSeries);
                this.writer.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(jFrame, fileNotFoundException.getMessage(), "Cannot open file", 0);
            }
        }
    }
}

