/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosGPSSat;
import org.altusmetrum.altoslib_14.AltosTelemetryStandard;

public class AltosTelemetrySatellite
extends AltosTelemetryStandard {
    int channels() {
        return this.uint8(5);
    }

    AltosGPSSat[] sats() {
        int n = this.channels();
        AltosGPSSat[] altosGPSSatArray = null;
        if (n > 12) {
            n = 12;
        }
        if (n == 0) {
            altosGPSSatArray = null;
        } else {
            altosGPSSatArray = new AltosGPSSat[n];
            for (int i = 0; i < n; ++i) {
                int n2 = this.uint8(6 + i * 2 + 0);
                int n3 = this.uint8(6 + i * 2 + 1);
                altosGPSSatArray[i] = new AltosGPSSat(n2, n3);
            }
        }
        return altosGPSSatArray;
    }

    public AltosTelemetrySatellite(int[] nArray) throws AltosCRCException {
        super(nArray);
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener) {
        super.provide_data(altosDataListener);
        AltosCalData altosCalData = altosDataListener.cal_data();
        AltosGPS altosGPS = altosDataListener.make_temp_gps(true);
        altosGPS.cc_gps_sat = this.sats();
        altosDataListener.set_gps(altosGPS, false, true);
    }
}

