/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.text.ParseException;
import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosDataProvider;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosParse;
import org.altusmetrum.altoslib_14.AltosTelemetryLegacy;
import org.altusmetrum.altoslib_14.AltosTelemetryStandard;

public abstract class AltosTelemetry
implements AltosDataProvider {
    int[] bytes;
    long received_time = System.currentTimeMillis();
    public double frequency = 2.147483647E9;
    static final int PKT_APPEND_STATUS_1_CRC_OK = 128;
    static final int PKT_APPEND_STATUS_1_LQI_MASK = 127;
    static final int PKT_APPEND_STATUS_1_LQI_SHIFT = 0;
    static final int packet_type_TM_sensor = 1;
    static final int packet_type_Tm_sensor = 2;
    static final int packet_type_Tn_sensor = 3;
    static final int packet_type_configuration = 4;
    static final int packet_type_location = 5;
    static final int packet_type_satellite = 6;
    static final int packet_type_companion = 7;
    static final int packet_type_mega_sensor_mpu = 8;
    static final int packet_type_mega_data = 9;
    static final int packet_type_metrum_sensor = 10;
    static final int packet_type_metrum_data = 11;
    static final int packet_type_mini2 = 16;
    static final int packet_type_mini3 = 17;
    static final int packet_type_mega_sensor_bmx160 = 18;

    public static int rssi(int[] nArray) {
        return AltosConvert.telem_to_rssi(AltosLib.int8(nArray, nArray.length - 3));
    }

    public static int status(int[] nArray) {
        return AltosLib.uint8(nArray, nArray.length - 2);
    }

    public int rssi() {
        return AltosTelemetry.rssi(this.bytes);
    }

    public int status() {
        return AltosTelemetry.status(this.bytes);
    }

    public abstract int serial();

    public abstract int tick();

    static boolean cksum(int[] nArray) {
        int n = 90;
        for (int i = 1; i < nArray.length - 1; ++i) {
            n += nArray[i];
        }
        return (n &= 0xFF) == nArray[nArray.length - 1];
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener) {
        altosDataListener.set_serial(this.serial());
        if (altosDataListener.state() == 9) {
            altosDataListener.set_state(0);
        }
        if (this.frequency != 2.147483647E9) {
            altosDataListener.set_frequency(this.frequency);
        }
        altosDataListener.set_tick(this.tick());
        altosDataListener.set_rssi(this.rssi(), this.status());
        altosDataListener.set_received_time(this.received_time);
    }

    static AltosTelemetry parse_hex(String string) throws ParseException, AltosCRCException {
        int[] nArray;
        AltosTelemetry altosTelemetry = null;
        try {
            nArray = AltosLib.hexbytes(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.getMessage(), 0);
        }
        if (nArray[0] != nArray.length - 2) {
            throw new ParseException(String.format("invalid length %d != %d\n", nArray[0], nArray.length - 2), 0);
        }
        if (!AltosTelemetry.cksum(nArray)) {
            throw new ParseException(String.format("invalid line \"%s\"", string), 0);
        }
        if ((AltosTelemetry.status(nArray) & 0x80) == 0) {
            throw new AltosCRCException(AltosTelemetry.rssi(nArray));
        }
        switch (nArray.length) {
            case 36: {
                altosTelemetry = AltosTelemetryStandard.parse_hex(nArray);
                break;
            }
            case 99: {
                altosTelemetry = new AltosTelemetryLegacy(nArray);
                break;
            }
            case 98: {
                altosTelemetry = new AltosTelemetryLegacy(nArray);
                break;
            }
            default: {
                throw new ParseException(String.format("Invalid packet length %d", nArray.length), 0);
            }
        }
        return altosTelemetry;
    }

    public void set_frequency(double d) {
        this.frequency = d;
    }

    public AltosTelemetry() {
    }

    public AltosTelemetry(int[] nArray) throws AltosCRCException {
        this();
        this.bytes = nArray;
        if ((this.status() & 0x80) == 0) {
            throw new AltosCRCException(this.rssi());
        }
    }

    public static AltosTelemetry parse(String string) throws ParseException, AltosCRCException {
        int n;
        String[] stringArray = string.split("\\s+");
        if (stringArray[n = 0].equals("CRC") && stringArray[n + 1].equals("INVALID")) {
            n += 2;
            AltosParse.word(stringArray[n++], "RSSI");
            throw new AltosCRCException(AltosParse.parse_int(stringArray[n++]));
        }
        AltosTelemetry altosTelemetry = null;
        altosTelemetry = stringArray[n].equals("TELEM") ? AltosTelemetry.parse_hex(stringArray[n + 1]) : new AltosTelemetryLegacy(string);
        return altosTelemetry;
    }
}

