/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.altusmetrum.altoslib_14.AltosFlashListener;
import org.altusmetrum.altoslib_14.AltosHexfile;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosNoSymbol;
import org.altusmetrum.altoslib_14.AltosProgrammer;
import org.altusmetrum.altoslib_14.AltosRomconfig;
import org.altusmetrum.altoslib_14.AltosUsbId;

public class AltosSelfFlash
extends AltosProgrammer {
    File file;
    FileInputStream input;
    AltosHexfile image;
    AltosLink link;
    boolean aborted;
    AltosFlashListener listener;
    AltosRomconfig rom_config;

    void action(String string, int n) {
        if (this.listener != null && !this.aborted) {
            this.listener.position(string, n);
        }
    }

    void action(int n, int n2) {
        int n3 = 100 * n / n2;
        this.action(String.format("%d/%d (%d%%)", n, n2, n3), n3);
    }

    byte[] read_memory(long l, int n) throws InterruptedException, IOException {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; i += 256) {
            this.link.printf("R %x\n", l + (long)i);
            byte[] byArray2 = this.link.get_binary_reply(5000, 256);
            if (byArray2 == null) {
                throw new IOException("Read device memory timeout");
            }
            for (int j = 0; j < 256 && j + i < n; ++j) {
                byArray[j + i] = byArray2[j];
            }
        }
        return byArray;
    }

    AltosHexfile read_hexfile(long l, int n) throws InterruptedException {
        try {
            byte[] byArray = this.read_memory(l, n);
            AltosHexfile altosHexfile = new AltosHexfile(byArray, l);
            if (this.image != null) {
                altosHexfile.add_symbols(this.image);
            }
            return altosHexfile;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    void write_memory(long l, byte[] byArray, int n, int n2) {
        int n3;
        this.link.printf("W %x\n", l);
        this.link.flush_output();
        for (n3 = 0; n3 < n2; ++n3) {
            this.link.putchar(byArray[n + n3]);
        }
        while (n3 < 256) {
            this.link.putchar((byte)-1);
            ++n3;
        }
    }

    void reboot() {
        this.link.printf("a\n", new Object[0]);
        this.link.flush_output();
    }

    @Override
    public void flash() {
        try {
            if (!this.check_rom_config()) {
                throw new IOException("Invalid rom config settings");
            }
            this.rom_config.write(this.image);
            int n = this.image.data.length;
            long l = this.image.address;
            int n2 = 0;
            this.action("start", 0);
            this.action(0, this.image.data.length);
            while (n > 0 && !this.aborted) {
                int n3 = n;
                if (n3 > 256) {
                    n3 = 256;
                }
                if (this.link != null) {
                    this.write_memory(l, this.image.data, n2, n3);
                    byte[] byArray = this.read_memory(l, n3);
                    for (int i = 0; i < n3; ++i) {
                        if (byArray[i] == this.image.data[n2 + i]) continue;
                        throw new IOException(String.format("Flash write failed at 0x%x (%02x != %02x)", this.image.address + (long)n2 + (long)i, byArray[i], this.image.data[n2 + i]));
                    }
                } else {
                    Thread.sleep(100L);
                }
                l += (long)n3;
                n2 += n3;
                this.action(this.image.data.length - (n -= n3), this.image.data.length);
            }
            if (!this.aborted) {
                this.action("done", 100);
            }
            this.close();
        }
        catch (IOException iOException) {
            this.action(iOException.getMessage(), -1);
            this.abort();
        }
        catch (InterruptedException interruptedException) {
            this.abort();
        }
    }

    @Override
    public void close() {
        if (this.link != null) {
            this.reboot();
            try {
                this.link.close();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.link = null;
        }
    }

    @Override
    public synchronized void abort() {
        this.aborted = true;
        this.close();
    }

    private AltosHexfile get_rom() throws InterruptedException {
        try {
            long l = AltosRomconfig.fetch_base(this.image);
            long l2 = AltosRomconfig.fetch_bounds(this.image);
            if (AltosLink.debug) {
                System.out.printf("rom base %x bounds %x\n", l, l2);
            }
            return this.read_hexfile(l, (int)(l2 - l));
        }
        catch (AltosNoSymbol altosNoSymbol) {
            return null;
        }
    }

    public boolean check_rom_config() throws InterruptedException {
        AltosHexfile altosHexfile;
        if (this.link == null) {
            return true;
        }
        if (this.rom_config == null && (altosHexfile = this.get_rom()) != null) {
            this.rom_config = new AltosRomconfig(altosHexfile);
        }
        return this.rom_config != null && this.rom_config.valid();
    }

    @Override
    public void set_romconfig(AltosRomconfig altosRomconfig) {
        this.rom_config = altosRomconfig;
    }

    @Override
    public AltosRomconfig target_romconfig(AltosUsbId altosUsbId, String string) throws InterruptedException {
        if (!this.check_rom_config()) {
            return null;
        }
        if (this.rom_config.usb_id == null) {
            this.rom_config.usb_id = altosUsbId;
        }
        if (this.rom_config.usb_product == null) {
            this.rom_config.usb_product = string;
        }
        return this.rom_config;
    }

    @Override
    public AltosRomconfig image_romconfig() {
        return new AltosRomconfig(this.image);
    }

    public AltosSelfFlash(File file, AltosLink altosLink, AltosFlashListener altosFlashListener) throws IOException, FileNotFoundException, InterruptedException {
        this.file = file;
        this.link = altosLink;
        this.listener = altosFlashListener;
        this.input = new FileInputStream(file);
        this.image = new AltosHexfile(this.input);
    }
}

