/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosImage;
import org.altusmetrum.altoslib_14.AltosMapCacheListener;
import org.altusmetrum.altoslib_14.AltosMapInterface;
import org.altusmetrum.altoslib_14.AltosMapTile;
import org.altusmetrum.altoslib_14.AltosMapTileListener;
import org.altusmetrum.altoslib_14.AltosPreferences;

public class AltosMapCache
implements AltosMapCacheListener {
    int min_cache_size;
    int cache_size;
    int requested_cache_size;
    private Object fetch_lock = new Object();
    private Object cache_lock = new Object();
    AltosMapInterface map_interface;
    MapCacheElement[] elements = new MapCacheElement[this.cache_size];
    long used;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set_cache_size(int n) {
        this.requested_cache_size = n;
        if (n < this.min_cache_size) {
            n = this.min_cache_size;
        }
        if (n == this.cache_size) {
            return;
        }
        Object object = this.cache_lock;
        synchronized (object) {
            MapCacheElement[] mapCacheElementArray = new MapCacheElement[n];
            for (int i = 0; i < this.cache_size; ++i) {
                if (i < n) {
                    mapCacheElementArray[i] = this.elements[i];
                    continue;
                }
                if (this.elements[i] == null) continue;
                this.elements[i].flush();
            }
            this.elements = mapCacheElementArray;
            this.cache_size = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AltosImage get(AltosMapTile altosMapTile) {
        int n = -1;
        long l = this.used;
        Object object = this.cache_lock;
        synchronized (object) {
            MapCacheElement mapCacheElement = null;
            for (int i = 0; i < this.cache_size; ++i) {
                mapCacheElement = this.elements[i];
                if (mapCacheElement == null) {
                    n = i;
                    break;
                }
                if (altosMapTile.store.equals(mapCacheElement.tile.store)) {
                    mapCacheElement.used = this.used++;
                    return mapCacheElement.image;
                }
                if (mapCacheElement.used >= l) continue;
                n = i;
                l = mapCacheElement.used;
            }
            mapCacheElement = new MapCacheElement(altosMapTile);
            mapCacheElement.used = this.used++;
            if (this.elements[n] != null) {
                this.elements[n].flush();
            }
            this.elements[n] = mapCacheElement;
            return mapCacheElement.image;
        }
    }

    @Override
    public void map_cache_changed(int n) {
        this.min_cache_size = n;
        this.set_cache_size(this.requested_cache_size);
    }

    public void dispose() {
        AltosPreferences.unregister_map_cache_listener(this);
        for (int i = 0; i < this.cache_size; ++i) {
            MapCacheElement mapCacheElement = this.elements[i];
            if (mapCacheElement == null) continue;
            mapCacheElement.flush();
        }
    }

    public AltosMapCache(AltosMapInterface altosMapInterface) {
        this.map_interface = altosMapInterface;
        this.min_cache_size = AltosPreferences.map_cache();
        this.set_cache_size(0);
        AltosPreferences.register_map_cache_listener(this);
    }

    class MapCacheElement
    implements AltosMapTileListener {
        AltosMapTile tile;
        AltosImage image;
        long used;

        private void load() {
            loader loader2 = new loader();
            Thread thread = new Thread(loader2);
            thread.start();
        }

        public void flush() {
            if (this.image != null) {
                this.image.flush();
                this.image = null;
            }
        }

        public boolean has_map() {
            return this.tile.status == 0;
        }

        @Override
        public synchronized void notify_tile(AltosMapTile altosMapTile, int n) {
            if (n == 1) {
                this.load();
            }
        }

        public MapCacheElement(AltosMapTile altosMapTile) {
            this.tile = altosMapTile;
            this.image = null;
            this.used = 0L;
            altosMapTile.add_listener(this);
        }

        class loader
        implements Runnable {
            loader() {
            }

            @Override
            public void run() {
                if (MapCacheElement.this.image == null) {
                    try {
                        MapCacheElement.this.image = AltosMapCache.this.map_interface.load_image(MapCacheElement.this.tile.store.file);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                MapCacheElement.this.tile.notify_image(MapCacheElement.this.image);
            }
        }
    }
}

