/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.util.Enumeration;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosLatLon;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosMapCache;
import org.altusmetrum.altoslib_14.AltosMapInterface;
import org.altusmetrum.altoslib_14.AltosMapLine;
import org.altusmetrum.altoslib_14.AltosMapMark;
import org.altusmetrum.altoslib_14.AltosMapPath;
import org.altusmetrum.altoslib_14.AltosMapPathPoint;
import org.altusmetrum.altoslib_14.AltosMapRectangle;
import org.altusmetrum.altoslib_14.AltosMapStore;
import org.altusmetrum.altoslib_14.AltosMapStoreListener;
import org.altusmetrum.altoslib_14.AltosMapTile;
import org.altusmetrum.altoslib_14.AltosMapTileListener;
import org.altusmetrum.altoslib_14.AltosMapTransform;
import org.altusmetrum.altoslib_14.AltosPointDouble;
import org.altusmetrum.altoslib_14.AltosPointInt;
import org.altusmetrum.altoslib_14.AltosRectangle;
import org.altusmetrum.altoslib_14.AltosState;

public class AltosMap
implements AltosMapTileListener,
AltosMapStoreListener {
    public static final int px_size = 512;
    public static final int maptype_hybrid = 0;
    public static final int maptype_roadmap = 1;
    public static final int maptype_satellite = 2;
    public static final int maptype_terrain = 3;
    public static final int maptype_default = 0;
    public static final int default_zoom = 15;
    public static final int min_zoom = 3;
    public static final int max_zoom = 21;
    public static final String[] maptype_names = new String[]{"hybrid", "roadmap", "satellite", "terrain"};
    public static final String[] maptype_labels = new String[]{"Hybrid", "Roadmap", "Satellite", "Terrain"};
    AltosMapInterface map_interface;
    int scale;
    AltosMapCache cache;
    LinkedList<AltosMapMark> marks = new LinkedList();
    AltosMapPath path;
    AltosMapLine line;
    public AltosLatLon last_position;
    boolean have_boost = false;
    boolean have_landed = false;
    ConcurrentHashMap<AltosPointInt, AltosMapTile> tiles = new ConcurrentHashMap();
    int load_radius;
    AltosLatLon load_centre = null;
    AltosMapTileListener load_listener;
    int zoom = 15;
    int maptype = 0;
    long user_input_time;
    static final long auto_scroll_delay = 20000L;
    public AltosMapTransform transform;
    public AltosLatLon centre;
    AltosPointInt drag_start;
    boolean dragged;
    static final double drag_far = 20.0;

    public AltosMapCache cache() {
        return this.cache;
    }

    public void reset() {
    }

    public void repaint(int n, int n2, int n3, int n4) {
        this.map_interface.repaint(new AltosRectangle(n, n2, n3, n4));
    }

    public void repaint(AltosMapRectangle altosMapRectangle, int n) {
        AltosRectangle altosRectangle = this.transform.screen(altosMapRectangle);
        this.repaint(altosRectangle.x - n, altosRectangle.y - n, altosRectangle.width + n * 2, altosRectangle.height + n * 2);
    }

    public void repaint() {
        this.map_interface.repaint();
    }

    public int width() {
        return this.map_interface.width();
    }

    public int height() {
        return this.map_interface.height();
    }

    public void debug(String string, Object ... objectArray) {
        this.map_interface.debug(string, objectArray);
    }

    public static AltosPointInt floor(AltosPointDouble altosPointDouble) {
        return new AltosPointInt((int)Math.floor(altosPointDouble.x / 512.0) * 512, (int)Math.floor(altosPointDouble.y / 512.0) * 512);
    }

    public static AltosPointInt ceil(AltosPointDouble altosPointDouble) {
        return new AltosPointInt((int)Math.ceil(altosPointDouble.x / 512.0) * 512, (int)Math.ceil(altosPointDouble.y / 512.0) * 512);
    }

    public void notice_user_input() {
        this.user_input_time = System.currentTimeMillis();
    }

    public boolean recent_user_input() {
        return System.currentTimeMillis() - this.user_input_time < 20000L;
    }

    public boolean has_centre() {
        return this.centre != null;
    }

    public boolean far_from_centre(AltosLatLon altosLatLon) {
        if (this.centre == null || this.transform == null) {
            return true;
        }
        AltosPointDouble altosPointDouble = this.transform.screen(altosLatLon);
        int n = this.width();
        int n2 = Math.abs((int)altosPointDouble.x - n / 2);
        if (n2 > n / 4) {
            return true;
        }
        int n3 = this.height();
        int n4 = Math.abs((int)altosPointDouble.y - n3 / 2);
        return n4 > n3 / 4;
    }

    public void set_transform() {
        if (this.centre != null) {
            this.transform = new AltosMapTransform(this.width(), this.height(), this.zoom, this.centre);
            this.repaint();
        }
    }

    private void set_zoom_label() {
        this.map_interface.set_zoom_label(String.format("Zoom %d", this.get_zoom() - 15));
    }

    public boolean set_zoom(int n) {
        this.notice_user_input();
        if (3 <= n && n <= 21 && n != this.zoom) {
            this.zoom = n;
            this.tiles.clear();
            this.set_transform();
            this.set_zoom_label();
            return true;
        }
        return false;
    }

    public boolean set_zoom_centre(int n, AltosPointInt altosPointInt) {
        boolean bl;
        AltosLatLon altosLatLon = null;
        if (this.transform != null) {
            altosLatLon = this.transform.screen_lat_lon(altosPointInt);
        }
        if ((bl = this.set_zoom(n)) && altosLatLon != null) {
            AltosPointDouble altosPointDouble = this.transform.screen(altosLatLon);
            double d = (double)this.width() / 2.0 - (double)altosPointInt.x;
            double d2 = (double)this.height() / 2.0 - (double)altosPointInt.y;
            AltosLatLon altosLatLon2 = this.transform.screen_lat_lon(new AltosPointDouble(altosPointDouble.x + d, altosPointDouble.y + d2));
            this.centre(altosLatLon2);
        }
        return bl;
    }

    public int get_zoom() {
        return this.zoom;
    }

    public boolean set_maptype(int n) {
        return false;
    }

    public void show(AltosGPS altosGPS, double d, int n, double d2) {
        AltosMapRectangle altosMapRectangle;
        if (altosGPS == null) {
            return;
        }
        if (!altosGPS.locked && altosGPS.nsat < 4) {
            return;
        }
        switch (n) {
            case 3: {
                if (this.have_boost) break;
                this.add_mark(altosGPS.lat, altosGPS.lon, n);
                this.have_boost = true;
                break;
            }
            case 8: {
                if (this.have_landed) break;
                this.add_mark(altosGPS.lat, altosGPS.lon, n);
                this.have_landed = true;
            }
        }
        if (this.path != null && (altosMapRectangle = this.path.add(altosGPS, d, n, d2)) != null) {
            this.repaint(altosMapRectangle, AltosMapPath.stroke_width);
        }
        this.last_position = new AltosLatLon(altosGPS.lat, altosGPS.lon);
        this.maybe_centre(altosGPS.lat, altosGPS.lon);
    }

    public void show(AltosState altosState, AltosListenerState altosListenerState) {
        this.show(altosState.gps, altosState.time, altosState.state(), altosState.gps_height());
    }

    public void centre(AltosLatLon altosLatLon) {
        this.centre = altosLatLon;
        this.set_transform();
    }

    public void centre(double d, double d2) {
        this.centre(new AltosLatLon(d, d2));
    }

    public void centre(AltosGPS altosGPS) {
        if (!altosGPS.locked && altosGPS.nsat < 4) {
            return;
        }
        this.centre(altosGPS.lat, altosGPS.lon);
    }

    public void centre(AltosState altosState) {
        this.centre(altosState.gps);
    }

    public void maybe_centre(double d, double d2) {
        AltosLatLon altosLatLon = new AltosLatLon(d, d2);
        if (this.centre == null || !this.recent_user_input() && this.far_from_centre(altosLatLon)) {
            this.centre(altosLatLon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AltosMapMark add_mark(double d, double d2, int n, String string) {
        AltosMapMark altosMapMark;
        LinkedList<AltosMapMark> linkedList = this.marks;
        synchronized (linkedList) {
            altosMapMark = this.map_interface.new_mark(d, d2, n, string);
            if (altosMapMark != null) {
                this.marks.add(altosMapMark);
            }
        }
        this.repaint();
        return altosMapMark;
    }

    public AltosMapMark add_mark(double d, double d2, int n) {
        return this.add_mark(d, d2, n, null);
    }

    public void del_mark(AltosMapMark altosMapMark) {
        this.marks.remove(altosMapMark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear_marks() {
        LinkedList<AltosMapMark> linkedList = this.marks;
        synchronized (linkedList) {
            this.marks.clear();
        }
    }

    private void make_tiles() {
        AltosPointInt altosPointInt;
        AltosPointInt altosPointInt2;
        Object object;
        if (this.load_centre != null) {
            object = AltosMap.floor(this.transform.point(this.load_centre));
            altosPointInt2 = new AltosPointInt(((AltosPointInt)object).x - this.load_radius * 512, ((AltosPointInt)object).y - this.load_radius * 512);
            altosPointInt = new AltosPointInt(((AltosPointInt)object).x + this.load_radius * 512, ((AltosPointInt)object).y + this.load_radius * 512);
        } else {
            altosPointInt2 = AltosMap.floor(this.transform.screen_point(new AltosPointInt(0, 0)));
            altosPointInt = AltosMap.floor(this.transform.screen_point(new AltosPointInt(this.width(), this.height())));
        }
        object = this.tiles.keys();
        while (object.hasMoreElements()) {
            AltosPointInt altosPointInt3 = (AltosPointInt)object.nextElement();
            if (altosPointInt3.x >= altosPointInt2.x && altosPointInt.x >= altosPointInt3.x && altosPointInt3.y >= altosPointInt2.y && altosPointInt.y >= altosPointInt3.y) continue;
            this.tiles.remove(altosPointInt3);
        }
        this.cache.set_cache_size((this.width() / 512 + 2) * (this.height() / 512 + 2));
        for (int i = altosPointInt2.y; i <= altosPointInt.y; i += 512) {
            for (int j = altosPointInt2.x; j <= altosPointInt.x; j += 512) {
                AltosPointInt altosPointInt4 = new AltosPointInt(j, i);
                if (this.tiles.containsKey(altosPointInt4)) continue;
                AltosLatLon altosLatLon = this.transform.lat_lon(altosPointInt4);
                AltosLatLon altosLatLon2 = this.transform.lat_lon(new AltosPointDouble(j + 256, i + 256));
                AltosMapTile altosMapTile = this.map_interface.new_tile(this.cache, altosLatLon, altosLatLon2, this.zoom, this.maptype, 512, this.scale);
                int n = altosMapTile.store.status();
                if (n == 2) {
                    this.debug("Fetching %.6f %.6f %d\n", altosLatLon2.lat, altosLatLon2.lon, this.zoom);
                }
                altosMapTile.add_listener(this);
                this.tiles.put(altosPointInt4, altosMapTile);
            }
        }
    }

    public void set_load_params(int n, int n2, double d, double d2, int n3, AltosMapTileListener altosMapTileListener) {
        if (3 <= n && n <= 21) {
            this.zoom = n;
        }
        this.load_centre = new AltosLatLon(d, d2);
        this.load_radius = n3;
        this.load_listener = altosMapTileListener;
        this.centre(d, d2);
        this.tiles.clear();
        this.make_tiles();
        this.repaint();
    }

    public String getName() {
        return "Map";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint() {
        if (this.centre != null) {
            this.make_tiles();
        }
        if (this.transform == null) {
            return;
        }
        for (AltosMapTile object : this.tiles.values()) {
            object.paint(this.transform);
        }
        LinkedList<AltosMapMark> linkedList = this.marks;
        synchronized (linkedList) {
            for (AltosMapMark altosMapMark : this.marks) {
                altosMapMark.paint(this.transform);
            }
        }
        if (this.path != null) {
            this.path.paint(this.transform);
        }
        if (this.line != null) {
            this.line.paint(this.transform);
        }
    }

    @Override
    public synchronized void notify_tile(AltosMapTile altosMapTile, int n) {
        Enumeration<AltosPointInt> enumeration = this.tiles.keys();
        while (enumeration.hasMoreElements()) {
            AltosPointInt altosPointInt = enumeration.nextElement();
            if (altosMapTile != this.tiles.get(altosPointInt)) continue;
            AltosPointInt altosPointInt2 = this.transform.screen(altosPointInt);
            this.repaint(altosPointInt2.x, altosPointInt2.y, 512, 512);
        }
    }

    @Override
    public synchronized void notify_store(AltosMapStore altosMapStore, int n) {
        if (this.load_listener != null) {
            for (AltosMapTile altosMapTile : this.tiles.values()) {
                if (!altosMapStore.equals(altosMapTile.store)) continue;
                this.load_listener.notify_tile(altosMapTile, n);
            }
        }
    }

    private void drag(int n, int n2) {
        if (this.drag_start == null) {
            return;
        }
        int n3 = n - this.drag_start.x;
        int n4 = n2 - this.drag_start.y;
        double d = Math.hypot(n3, n4);
        if (d > 20.0) {
            this.dragged = true;
        }
        if (this.transform == null) {
            return;
        }
        AltosLatLon altosLatLon = this.transform.screen_lat_lon(new AltosPointInt(this.width() / 2 - n3, this.height() / 2 - n4));
        this.centre(altosLatLon);
        this.drag_start = new AltosPointInt(n, n2);
    }

    private void drag_start(int n, int n2) {
        this.drag_start = new AltosPointInt(n, n2);
        this.dragged = false;
    }

    private void drag_stop(int n, int n2) {
        if (!this.dragged) {
            if (this.transform == null) {
                return;
            }
            this.map_interface.select_object(this.transform.screen_lat_lon(new AltosPointInt(n, n2)));
        }
    }

    private void line_start(int n, int n2) {
        if (this.line != null && this.transform != null) {
            this.line.pressed(new AltosPointInt(n, n2), this.transform);
            this.repaint();
        }
    }

    private void line(int n, int n2) {
        if (this.line != null && this.transform != null) {
            this.line.dragged(new AltosPointInt(n, n2), this.transform);
            this.repaint();
        }
    }

    public void touch_start(int n, int n2, boolean bl) {
        this.notice_user_input();
        if (bl) {
            this.drag_start(n, n2);
        } else {
            this.line_start(n, n2);
        }
    }

    public void touch_continue(int n, int n2, boolean bl) {
        this.notice_user_input();
        if (bl) {
            this.drag(n, n2);
        } else {
            this.line(n, n2);
        }
    }

    public void touch_stop(int n, int n2, boolean bl) {
        this.notice_user_input();
        if (bl) {
            this.drag_stop(n, n2);
        }
    }

    public AltosMapPathPoint nearest(int n, int n2) {
        this.notice_user_input();
        if (this.path == null) {
            return null;
        }
        if (this.transform == null) {
            return null;
        }
        AltosLatLon altosLatLon = this.transform.screen_lat_lon(new AltosPointInt(n, n2));
        return this.path.nearest(altosLatLon);
    }

    public AltosMap(AltosMapInterface altosMapInterface, int n) {
        this.map_interface = altosMapInterface;
        this.scale = n;
        this.cache = new AltosMapCache(altosMapInterface);
        this.line = altosMapInterface.new_line();
        this.path = altosMapInterface.new_path();
        this.set_zoom_label();
    }

    public AltosMap(AltosMapInterface altosMapInterface) {
        this(altosMapInterface, 1);
    }
}

