/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.File;
import java.util.Calendar;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosPreferences;

public class AltosFile
extends File {
    static String number(int n) {
        if (n == Integer.MAX_VALUE) {
            return "unkn";
        }
        return String.format("%04d", n);
    }

    static String receiver(int n) {
        if (n == Integer.MAX_VALUE) {
            return "";
        }
        return String.format("-via-%04d", n);
    }

    private static String label(int n) {
        if (n < 0) {
            return "corrupt";
        }
        return "flight";
    }

    private static int flight(int n) {
        if (n < 0) {
            return -n;
        }
        return n;
    }

    public AltosFile(int n, int n2, int n3, int n4, int n5, int n6, String string) {
        super(AltosPreferences.logdir(), String.format("%04d-%02d-%02d-serial-%s-%s-%s%s.%s", n, n2, n3, AltosFile.number(n4), AltosFile.label(n5), AltosFile.number(AltosFile.flight(n5)), AltosFile.receiver(n6), string));
    }

    public AltosFile(int n, int n2, int n3, int n4, int n5, String string) {
        this(n, n2, n3, n4, n5, Integer.MAX_VALUE, string);
    }

    public AltosFile(int n, int n2, int n3, String string) {
        this(Calendar.getInstance().get(1), Calendar.getInstance().get(2) + 1, Calendar.getInstance().get(5), n, n2, n3, string);
    }

    public AltosFile(int n, int n2, String string) {
        this(Calendar.getInstance().get(1), Calendar.getInstance().get(2) + 1, Calendar.getInstance().get(5), n, n2, Integer.MAX_VALUE, string);
    }

    public AltosFile(AltosCalData altosCalData) {
        this(altosCalData.serial, altosCalData.flight, altosCalData.receiver_serial, "telem");
    }
}

