/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosEeprom;
import org.altusmetrum.altoslib_14.AltosEepromRecord;
import org.altusmetrum.altoslib_14.AltosGPS;

public class AltosEepromRecordGps
extends AltosEepromRecord {
    public static final int record_length = 32;

    public int flight() {
        return this.data16(0);
    }

    public int start_altitude() {
        return this.data16(2);
    }

    public int start_latitude() {
        return this.data32(4);
    }

    public int start_longitude() {
        return this.data32(8);
    }

    public int latitude() {
        return this.data32(0);
    }

    public int longitude() {
        return this.data32(4);
    }

    public int altitude_low() {
        return this.data16(8);
    }

    public int hour() {
        return this.data8(10);
    }

    public int minute() {
        return this.data8(11);
    }

    public int second() {
        return this.data8(12);
    }

    public int flags() {
        return this.data8(13);
    }

    public int year() {
        return this.data8(14);
    }

    public int month() {
        return this.data8(15);
    }

    public int day() {
        return this.data8(16);
    }

    public int course() {
        return this.data8(17);
    }

    public int ground_speed() {
        return this.data16(18);
    }

    public int climb_rate() {
        return this.data16(20);
    }

    public int pdop() {
        return this.data8(22);
    }

    public int hdop() {
        return this.data8(23);
    }

    public int vdop() {
        return this.data8(24);
    }

    public int mode() {
        return this.data8(25);
    }

    public int altitude_high() {
        return this.data16(26);
    }

    private int seconds() {
        switch (this.cmd()) {
            case 71: {
                return this.second() + 60 * (this.minute() + 60 * (this.hour() + 24 * (this.day() + 31 * this.month())));
            }
        }
        return 0;
    }

    @Override
    public int compareTo(AltosEepromRecord altosEepromRecord) {
        AltosEepromRecordGps altosEepromRecordGps = (AltosEepromRecordGps)altosEepromRecord;
        int n = this.seconds() - altosEepromRecordGps.seconds();
        if (n != 0) {
            return n;
        }
        return this.start - altosEepromRecord.start;
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener, AltosCalData altosCalData) {
        super.provide_data(altosDataListener, altosCalData);
        switch (this.cmd()) {
            case 70: {
                if (altosCalData.flight != Integer.MAX_VALUE) break;
                altosCalData.set_boost_tick();
                altosCalData.set_flight(this.flight());
                break;
            }
            case 71: {
                AltosGPS altosGPS = new AltosGPS();
                altosGPS.lat = (double)this.latitude() / 1.0E7;
                altosGPS.lon = (double)this.longitude() / 1.0E7;
                altosGPS.alt = this.eeprom.config_data().altitude_32 == 1 ? (double)(this.altitude_low() & 0xFFFF | this.altitude_high() << 16) : (double)this.altitude_low();
                altosGPS.hour = this.hour();
                altosGPS.minute = this.minute();
                altosGPS.second = this.second();
                int n = this.flags();
                altosGPS.connected = (n & 0x20) != 0;
                altosGPS.locked = (n & 0x10) != 0;
                altosGPS.nsat = (n & 0xF) >> 0;
                altosGPS.year = 2000 + this.year();
                altosGPS.month = this.month();
                altosGPS.day = this.day();
                altosGPS.ground_speed = (double)this.ground_speed() * 0.01;
                altosGPS.course = this.course() * 2;
                altosGPS.climb_rate = (double)this.climb_rate() * 0.01;
                if (this.eeprom.config_data().compare_version("1.4.9") >= 0) {
                    altosGPS.pdop = (double)this.pdop() / 10.0;
                    altosGPS.hdop = (double)this.hdop() / 10.0;
                    altosGPS.vdop = (double)this.vdop() / 10.0;
                } else {
                    altosGPS.pdop = (double)this.pdop() / 100.0;
                    if (altosGPS.pdop < 0.8) {
                        altosGPS.pdop += 2.56;
                    }
                    altosGPS.hdop = (double)this.hdop() / 100.0;
                    if (altosGPS.hdop < 0.8) {
                        altosGPS.hdop += 2.56;
                    }
                    altosGPS.vdop = (double)this.vdop() / 100.0;
                    if (altosGPS.vdop < 0.8) {
                        altosGPS.vdop += 2.56;
                    }
                }
                altosDataListener.set_gps(altosGPS, true, true);
            }
        }
    }

    @Override
    public AltosEepromRecord next() {
        int n = this.next_start();
        if (n < 0) {
            return null;
        }
        return new AltosEepromRecordGps(this.eeprom, n);
    }

    public AltosEepromRecordGps(AltosEeprom altosEeprom, int n) {
        super(altosEeprom, n, 32);
    }

    public AltosEepromRecordGps(AltosEeprom altosEeprom) {
        this(altosEeprom, 0);
    }
}

