/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosEeprom;
import org.altusmetrum.altoslib_14.AltosEepromRecord;

public class AltosEepromRecordFireTwo
extends AltosEepromRecord {
    public static final int record_length = 32;
    private static final double r_above = 5600.0;
    private static final double r_below = 10000.0;
    private static final double v_adc = 3.3;

    public int flight() {
        return this.data16(0);
    }

    public int state() {
        return this.data16(0);
    }

    public int reason() {
        return this.data16(2);
    }

    public int pres() {
        return this.data16(0);
    }

    public int thrust() {
        return this.data16(2);
    }

    public int temp(int n) {
        return this.data16(4 + n * 2);
    }

    private static double firetwo_adc(int n) {
        return (double)n / 4095.0;
    }

    public static double adc_to_pa(int n) {
        double d = AltosEepromRecordFireTwo.firetwo_adc(n) * 3.3 * 15600.0 / 10000.0;
        if (d < 0.5) {
            d = 0.5;
        }
        if (d > 4.5) {
            d = 4.5;
        }
        double d2 = (d - 0.5) / 4.0 * 2500.0;
        return AltosConvert.psi_to_pa(d2);
    }

    public static double adc_to_n(int n) {
        double d = AltosEepromRecordFireTwo.firetwo_adc(n);
        return AltosConvert.lb_to_n(d * 298.0 * 9.807);
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener, AltosCalData altosCalData) {
        super.provide_data(altosDataListener, altosCalData);
        switch (this.cmd()) {
            case 70: {
                altosCalData.set_flight(this.flight());
                break;
            }
            case 83: {
                altosDataListener.set_state(this.state());
                break;
            }
            case 65: {
                altosDataListener.set_pressure(AltosEepromRecordFireTwo.adc_to_pa(this.pres()));
                altosDataListener.set_thrust(AltosEepromRecordFireTwo.adc_to_n(this.thrust()));
            }
        }
    }

    @Override
    public AltosEepromRecord next() {
        int n = this.next_start();
        if (n < 0) {
            return null;
        }
        return new AltosEepromRecordFireTwo(this.eeprom, n);
    }

    public AltosEepromRecordFireTwo(AltosEeprom altosEeprom, int n) {
        super(altosEeprom, n, 32);
    }

    public AltosEepromRecordFireTwo(AltosEeprom altosEeprom) {
        this(altosEeprom, 0);
    }
}

