/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import altosui.Altos;
import java.awt.Frame;
import java.io.FileNotFoundException;
import java.util.concurrent.TimeoutException;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosSerial;
import org.altusmetrum.altosuilib_14.AltosSerialInUseException;

public class AltosLaunch {
    AltosDevice device;
    AltosSerial serial;
    boolean serial_started;
    int launcher_serial;
    int launcher_channel;
    int rssi;
    static final int Unknown = -1;
    static final int Good = 0;
    static final int Bad = 1;
    int armed;
    int igniter;

    private void start_serial() throws InterruptedException {
        this.serial_started = true;
    }

    private void stop_serial() throws InterruptedException {
        if (!this.serial_started) {
            return;
        }
        this.serial_started = false;
        if (this.serial == null) {
            return;
        }
    }

    private boolean get_string(String string, String string2, string_ref string_ref2) {
        if (string.startsWith(string2)) {
            String string3 = string.substring(string2.length()).trim();
            if (string3.startsWith("\"")) {
                string3 = string3.substring(1);
            }
            if (string3.endsWith("\"")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            string_ref2.set(string3);
            return true;
        }
        return false;
    }

    public boolean status() throws InterruptedException, TimeoutException {
        boolean bl;
        block9: {
            bl = false;
            if (this.serial == null) {
                return false;
            }
            string_ref string_ref2 = new string_ref();
            this.start_serial();
            this.serial.printf("l %d %d\n", this.launcher_serial, this.launcher_channel);
            while (true) {
                String string;
                if ((string = this.serial.get_reply(20000)) == null) {
                    throw new TimeoutException();
                }
                if (this.get_string(string, "Rssi: ", string_ref2)) {
                    try {
                        this.rssi = (int)Altos.fromdec(string_ref2.get());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break block9;
                }
                if (this.get_string(string, "Armed: ", string_ref2)) {
                    this.armed = 0;
                    String string2 = string_ref2.get();
                    this.igniter = string2.startsWith("igniter good") ? 0 : (string2.startsWith("igniter bad") ? 1 : -1);
                    bl = true;
                    continue;
                }
                if (this.get_string(string, "Disarmed: ", string_ref2)) {
                    this.armed = 1;
                    this.igniter = string_ref2.get().startsWith("igniter good") ? 0 : (string_ref2.get().startsWith("igniter bad") ? 1 : -1);
                    bl = true;
                    continue;
                }
                if (this.get_string(string, "Error ", string_ref2)) break;
            }
            this.armed = -1;
            this.igniter = -1;
            bl = false;
        }
        this.stop_serial();
        if (!bl) {
            this.armed = -1;
            this.igniter = -1;
        }
        return bl;
    }

    public static String status_string(int n) {
        switch (n) {
            case 0: {
                return "good";
            }
            case 1: {
                return "open";
            }
        }
        return "unknown";
    }

    public void arm() {
        if (this.serial == null) {
            return;
        }
        try {
            this.start_serial();
            this.serial.printf("a %d %d\n", this.launcher_serial, this.launcher_channel);
            this.serial.flush_output();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            try {
                this.stop_serial();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void fire() {
        if (this.serial == null) {
            return;
        }
        try {
            this.start_serial();
            this.serial.printf("i %d %d\n", this.launcher_serial, this.launcher_channel);
            this.serial.flush_output();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            try {
                this.stop_serial();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void close() {
        try {
            this.stop_serial();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.serial.close();
        this.serial = null;
    }

    public void set_frame(Frame frame) {
        this.serial.set_frame(frame);
    }

    public void set_remote(int n, int n2) {
        this.launcher_serial = n;
        this.launcher_channel = n2;
    }

    public AltosLaunch(AltosDevice altosDevice) throws FileNotFoundException, AltosSerialInUseException {
        this.device = altosDevice;
        this.serial = new AltosSerial(this.device);
    }

    class string_ref {
        String value = null;

        public String get() {
            return this.value;
        }

        public void set(String string) {
            this.value = string;
        }
    }
}

