/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import altosui.AltosGraphUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosEepromRecordSet;
import org.altusmetrum.altoslib_14.AltosFlightReader;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosRecordSet;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altoslib_14.AltosTelemetryFile;
import org.altusmetrum.altosuilib_14.AltosUIFlightTab;
import org.altusmetrum.altosuilib_14.AltosUIIndicator;
import org.altusmetrum.altosuilib_14.AltosUIUnitsIndicator;

public class AltosLanded
extends AltosUIFlightTab
implements ActionListener {
    JButton graph;
    AltosFlightReader reader;

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        String string = actionEvent.getActionCommand();
        if (string.equals("graph") && (file = this.reader.backing_file()) != null) {
            String string2 = file.getName();
            try {
                AltosRecordSet altosRecordSet = null;
                FileInputStream fileInputStream = new FileInputStream(file);
                if (string2.endsWith("eeprom")) {
                    altosRecordSet = new AltosEepromRecordSet(fileInputStream);
                } else if (string2.endsWith("telem")) {
                    altosRecordSet = new AltosTelemetryFile(fileInputStream);
                } else {
                    throw new FileNotFoundException(string2);
                }
                try {
                    new AltosGraphUI(altosRecordSet, file);
                }
                catch (InterruptedException interruptedException) {
                }
                catch (IOException iOException) {}
            }
            catch (FileNotFoundException fileNotFoundException) {
                JOptionPane.showMessageDialog(null, fileNotFoundException.getMessage(), "Cannot open file", 0);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, iOException.getMessage(), "Error reading file file", 0);
            }
        }
    }

    @Override
    public String getName() {
        return "Landed";
    }

    @Override
    public void show(AltosState altosState, AltosListenerState altosListenerState) {
        super.show(altosState, altosListenerState);
        if (this.reader.backing_file() != null) {
            this.graph.setEnabled(true);
        }
    }

    public AltosLanded(AltosFlightReader altosFlightReader) {
        this.reader = altosFlightReader;
        this.add(new Bearing(this, 0));
        this.add(new Distance(this, 1));
        this.add(new Lat(this, 2));
        this.add(new Lon(this, 3));
        this.add(new MaxHeight(this, 4));
        this.add(new MaxSpeed(this, 5));
        this.add(new MaxAccel(this, 6));
        this.graph = new JButton("Graph Flight");
        this.graph.setActionCommand("graph");
        this.graph.addActionListener(this);
        this.graph.setEnabled(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 3;
        this.add((Component)this.graph, gridBagConstraints);
        this.addHierarchyListener(this);
    }

    class MaxAccel
    extends AltosUIUnitsIndicator {
        @Override
        public double value(AltosState altosState, int n) {
            return altosState.max_acceleration();
        }

        public MaxAccel(Container container, int n) {
            super(container, n, AltosConvert.speed, "Maximum acceleration", 2);
        }
    }

    class MaxSpeed
    extends AltosUIUnitsIndicator {
        @Override
        public double value(AltosState altosState, int n) {
            return altosState.max_speed();
        }

        public MaxSpeed(Container container, int n) {
            super(container, n, AltosConvert.speed, "Maximum Speed", 2);
        }
    }

    class MaxHeight
    extends AltosUIUnitsIndicator {
        @Override
        public double value(AltosState altosState, int n) {
            return altosState.max_height();
        }

        public MaxHeight(Container container, int n) {
            super(container, n, AltosConvert.height, "Maximum Height", 2);
        }
    }

    class Lon
    extends AltosUIUnitsIndicator {
        @Override
        public boolean hide(AltosState altosState, int n) {
            return altosState.gps == null || !altosState.gps.connected;
        }

        @Override
        public double value(AltosState altosState, int n) {
            if (altosState.gps == null) {
                return 2.147483647E9;
            }
            if (!altosState.gps.connected) {
                return 2.147483647E9;
            }
            return altosState.gps.lon;
        }

        public Lon(Container container, int n) {
            super(container, n, AltosConvert.longitude, "Longitude", 2);
        }
    }

    class Lat
    extends AltosUIUnitsIndicator {
        @Override
        public boolean hide(AltosState altosState, int n) {
            return altosState.gps == null || !altosState.gps.connected;
        }

        @Override
        public double value(AltosState altosState, int n) {
            if (altosState.gps == null) {
                return 2.147483647E9;
            }
            if (!altosState.gps.connected) {
                return 2.147483647E9;
            }
            return altosState.gps.lat;
        }

        public Lat(Container container, int n) {
            super(container, n, AltosConvert.latitude, "Latitude", 2);
        }
    }

    class Distance
    extends AltosUIUnitsIndicator {
        @Override
        public double value(AltosState altosState, int n) {
            if (altosState.from_pad != null) {
                return altosState.from_pad.distance;
            }
            return 2.147483647E9;
        }

        public Distance(Container container, int n) {
            super(container, n, AltosConvert.distance, "Ground Distance", 2);
        }
    }

    class Bearing
    extends AltosUIIndicator {
        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            if (altosState.from_pad != null && altosState.from_pad.bearing != 2.147483647E9) {
                this.show(String.format("%3.0f\u00b0", altosState.from_pad.bearing), altosState.from_pad.bearing_words(0));
            } else {
                this.show("Missing", "Missing");
            }
        }

        public Bearing(Container container, int n) {
            super(container, n, "Bearing", 2);
        }
    }
}

