/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import altosui.AltosFlightStatus;
import altosui.AltosFlightStatusUpdate;
import altosui.AltosIgnitor;
import altosui.AltosPad;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.altusmetrum.altoslib_14.AltosFlightDisplay;
import org.altusmetrum.altoslib_14.AltosIdleMonitor;
import org.altusmetrum.altoslib_14.AltosIdleMonitorListener;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosDeviceUIDialog;
import org.altusmetrum.altosuilib_14.AltosInfoTable;
import org.altusmetrum.altosuilib_14.AltosSerial;
import org.altusmetrum.altosuilib_14.AltosSerialInUseException;
import org.altusmetrum.altosuilib_14.AltosUIFrame;
import org.altusmetrum.altosuilib_14.AltosUIFreqList;
import org.altusmetrum.altosuilib_14.AltosUIMap;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;

public class AltosIdleMonitorUI
extends AltosUIFrame
implements AltosFlightDisplay,
AltosIdleMonitorListener,
DocumentListener {
    AltosDevice device;
    JTabbedPane pane;
    AltosPad pad;
    AltosInfoTable flightInfo;
    AltosFlightStatus flightStatus;
    AltosIgnitor igniter;
    AltosIdleMonitor thread;
    AltosUIMap sitemap;
    int serial;
    boolean remote;
    boolean has_igniter;
    boolean has_map;
    AltosFlightStatusUpdate status_update;
    Container bag;
    AltosUIFreqList frequencies;
    JTextField callsign_value;

    void stop_display() {
        if (this.thread != null) {
            try {
                this.thread.abort();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.thread = null;
    }

    void disconnect() {
        this.stop_display();
    }

    @Override
    public void reset() {
        this.pad.reset();
        this.flightInfo.clear();
    }

    @Override
    public void font_size_changed(int n) {
        this.pad.font_size_changed(n);
        this.flightInfo.font_size_changed(n);
    }

    @Override
    public void units_changed(boolean bl) {
        this.pad.units_changed(bl);
        this.flightInfo.units_changed(bl);
    }

    @Override
    public void show(AltosState altosState, AltosListenerState altosListenerState) {
        this.status_update.saved_state = altosState;
        if (this.igniter.should_show(altosState)) {
            if (!this.has_igniter) {
                this.pane.add("Ignitor", this.igniter);
                this.has_igniter = true;
            }
        } else if (this.has_igniter) {
            this.pane.remove(this.igniter);
            this.has_igniter = false;
        }
        if (altosState.gps != null && altosState.gps.connected) {
            if (!this.has_map) {
                this.pane.add("Site Map", this.sitemap);
                this.has_map = true;
            }
        } else if (this.has_map) {
            this.pane.remove(this.sitemap);
            this.has_map = false;
        }
        this.pad.show(altosState, altosListenerState);
        this.flightStatus.show(altosState, altosListenerState);
        this.flightInfo.show(altosState, altosListenerState);
        if (this.has_igniter) {
            this.igniter.show(altosState, altosListenerState);
        }
        if (this.has_map) {
            this.sitemap.show(altosState, altosListenerState);
        }
    }

    @Override
    public void update(final AltosState altosState, final AltosListenerState altosListenerState) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AltosIdleMonitorUI.this.show(altosState, altosListenerState);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void failed() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AltosIdleMonitorUI.this.close();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void error(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AltosIdleMonitorUI.this.disconnect();
                JOptionPane.showMessageDialog(AltosIdleMonitorUI.this, string, "Error fetching data", 0);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.callsign_value != null) {
            String string = this.callsign_value.getText();
            System.out.printf("callsign set to %s\n", string);
            this.thread.set_callsign(string);
            AltosUIPreferences.set_callsign(string);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    void idle_exception(JFrame jFrame, Exception exception) {
        if (exception instanceof FileNotFoundException) {
            JOptionPane.showMessageDialog(jFrame, ((FileNotFoundException)exception).getMessage(), "Cannot open target device", 0);
        } else if (exception instanceof AltosSerialInUseException) {
            JOptionPane.showMessageDialog(jFrame, String.format("Device \"%s\" already in use", this.device.toShortString()), "Device in use", 0);
        } else if (exception instanceof IOException) {
            IOException iOException = (IOException)exception;
            JOptionPane.showMessageDialog(jFrame, this.device.toShortString(), iOException.getLocalizedMessage(), 0);
        } else {
            JOptionPane.showMessageDialog(jFrame, String.format("Connection to \"%s\" failed", this.device.toShortString()), "Connection Failed", 0);
        }
    }

    private void close() {
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            System.out.printf("Exception %s\n", exception.toString());
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                System.out.printf("%s\n", stackTraceElement.toString());
            }
        }
        this.setVisible(false);
        this.dispose();
        AltosUIPreferences.unregister_font_listener(this);
    }

    public AltosIdleMonitorUI(JFrame jFrame) throws FileNotFoundException, TimeoutException, InterruptedException {
        AltosSerial altosSerial;
        this.device = AltosDeviceUIDialog.show(jFrame, 65536);
        this.remote = false;
        if (this.device.matchProduct(65537)) {
            this.remote = true;
        }
        this.serial = this.device.getSerial();
        try {
            altosSerial = new AltosSerial(this.device);
        }
        catch (Exception exception) {
            this.idle_exception(jFrame, exception);
            return;
        }
        altosSerial.set_frame(this);
        altosSerial.set_cancel_enable(false);
        this.bag = this.getScrollablePane();
        this.bag.setLayout(new GridBagLayout());
        this.setTitle(String.format("AltOS %s", this.device.toShortString()));
        if (this.remote && this.serial >= 0) {
            this.set_inset(3);
            this.frequencies = new AltosUIFreqList(AltosUIPreferences.frequency(this.serial));
            this.frequencies.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    double d = AltosIdleMonitorUI.this.frequencies.frequency();
                    AltosIdleMonitorUI.this.thread.set_frequency(d);
                    AltosUIPreferences.set_frequency(AltosIdleMonitorUI.this.device.getSerial(), d);
                }
            });
            this.bag.add((Component)this.frequencies, this.constraints(0, 1));
            this.bag.add((Component)new JLabel("Callsign:"), this.constraints(1, 1));
            this.callsign_value = new JTextField(AltosUIPreferences.callsign());
            this.callsign_value.getDocument().addDocumentListener(this);
            this.callsign_value.setToolTipText("Callsign sent in packet mode");
            this.bag.add((Component)this.callsign_value, this.constraints(2, 1, 2));
            this.next_row();
        }
        this.set_inset(0);
        this.flightStatus = new AltosFlightStatus();
        this.bag.add((Component)this.flightStatus, this.constraints(0, 4, 2));
        this.next_row();
        this.pane = new JTabbedPane();
        this.pad = new AltosPad();
        this.pane.add("Launch Pad", this.pad);
        this.flightInfo = new AltosInfoTable();
        this.pane.add("Table", new JScrollPane(this.flightInfo));
        this.igniter = new AltosIgnitor();
        this.sitemap = new AltosUIMap();
        this.bag.add((Component)this.pane, this.constraints(0, 4, 1));
        this.setDefaultCloseOperation(0);
        AltosUIPreferences.register_font_listener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AltosIdleMonitorUI.this.close();
            }
        });
        this.pack();
        this.setVisible(true);
        this.thread = new AltosIdleMonitor(this, altosSerial, this.remote);
        this.thread.set_frequency(AltosUIPreferences.frequency(this.serial));
        this.status_update = new AltosFlightStatusUpdate(this.flightStatus);
        new Timer(100, this.status_update).start();
        this.thread.start();
    }
}

