/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JTabbedPane;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosFilterListener;
import org.altusmetrum.altoslib_14.AltosFlightSeries;
import org.altusmetrum.altoslib_14.AltosFlightStats;
import org.altusmetrum.altoslib_14.AltosFontListener;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosGPSTimeValue;
import org.altusmetrum.altoslib_14.AltosPreferences;
import org.altusmetrum.altoslib_14.AltosRecordSet;
import org.altusmetrum.altoslib_14.AltosUnitsListener;
import org.altusmetrum.altosuilib_14.AltosFlightStatsTable;
import org.altusmetrum.altosuilib_14.AltosGraph;
import org.altusmetrum.altosuilib_14.AltosUIEnable;
import org.altusmetrum.altosuilib_14.AltosUIFlightSeries;
import org.altusmetrum.altosuilib_14.AltosUIFrame;
import org.altusmetrum.altosuilib_14.AltosUIMap;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;

public class AltosGraphUI
extends AltosUIFrame
implements AltosFontListener,
AltosUnitsListener,
AltosFilterListener {
    JTabbedPane pane;
    AltosGraph graph;
    AltosUIEnable enable;
    AltosUIMap map;
    AltosFlightStats stats;
    AltosFlightStatsTable statsTable;
    AltosGPS gps;
    boolean has_gps;
    AltosUIFlightSeries flight_series;

    void fill_map(AltosFlightSeries altosFlightSeries) {
        boolean bl = false;
        AltosGPSTimeValue altosGPSTimeValue = null;
        double d = altosFlightSeries.cal_data().gps_pad_altitude;
        if (altosFlightSeries.gps_series != null) {
            for (AltosGPSTimeValue altosGPSTimeValue2 : altosFlightSeries.gps_series) {
                AltosGPS altosGPS = altosGPSTimeValue2.gps;
                if (altosGPS == null || !altosGPS.locked || altosGPS.nsat < 4) continue;
                if (this.map == null) {
                    this.map = new AltosUIMap();
                }
                double d2 = altosGPS.alt - d;
                int n = (int)altosFlightSeries.value_before("State", altosGPSTimeValue2.time);
                this.map.show(altosGPS, altosGPSTimeValue2.time, n, d2);
                this.gps = altosGPS;
                altosGPSTimeValue = altosGPSTimeValue2;
                this.has_gps = true;
            }
        }
        if (altosGPSTimeValue != null) {
            int n = (int)altosFlightSeries.value_after("State", altosGPSTimeValue.time);
            double d3 = this.gps.alt - d;
            if (n == 8) {
                this.map.show(altosGPSTimeValue.gps, altosGPSTimeValue.time, n, d3);
            }
        }
    }

    @Override
    public void font_size_changed(int n) {
        if (this.map != null) {
            this.map.font_size_changed(n);
        }
        if (this.statsTable != null) {
            this.statsTable.font_size_changed(n);
        }
    }

    @Override
    public void units_changed(boolean bl) {
        if (this.map != null) {
            this.map.units_changed(bl);
        }
        if (this.enable != null) {
            this.enable.units_changed(bl);
        }
    }

    @Override
    public void filter_changed(double d, double d2) {
        this.flight_series.set_filter(d, d2);
        this.graph.filter_changed();
        this.stats = new AltosFlightStats(this.flight_series);
        this.statsTable.filter_changed(this.stats);
    }

    @Override
    public double speed_filter() {
        return this.flight_series.speed_filter_width;
    }

    @Override
    public double accel_filter() {
        return this.flight_series.accel_filter_width;
    }

    AltosGraphUI(AltosRecordSet altosRecordSet, File file) throws InterruptedException, IOException {
        super(file.getName());
        AltosCalData altosCalData = altosRecordSet.cal_data();
        this.pane = new JTabbedPane();
        this.flight_series = new AltosUIFlightSeries(altosCalData);
        this.enable = new AltosUIEnable(this);
        altosRecordSet.capture_series(this.flight_series);
        this.flight_series.finish();
        this.stats = new AltosFlightStats(this.flight_series);
        this.graph = new AltosGraph(this.enable, this.stats, this.flight_series);
        this.statsTable = new AltosFlightStatsTable(this.stats);
        this.pane.add("Flight Graph", (Component)this.graph.panel);
        this.pane.add("Configure Graph", this.enable);
        this.pane.add("Flight Statistics", this.statsTable);
        this.has_gps = false;
        this.fill_map(this.flight_series);
        if (this.has_gps) {
            this.pane.add("Map", this.map);
        }
        this.setContentPane(this.pane);
        AltosUIPreferences.register_font_listener(this);
        AltosPreferences.register_units_listener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AltosUIPreferences.unregister_font_listener(AltosGraphUI.this);
                AltosPreferences.unregister_units_listener(AltosGraphUI.this);
            }
        });
        this.pack();
        this.setVisible(true);
        if (this.gps != null) {
            this.map.centre(this.gps);
        }
    }
}

