/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import altosui.AltosAscent;
import altosui.AltosCompanionInfo;
import altosui.AltosDescent;
import altosui.AltosFlightStatus;
import altosui.AltosFlightStatusUpdate;
import altosui.AltosIgnitor;
import altosui.AltosLanded;
import altosui.AltosPad;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosFlightDisplay;
import org.altusmetrum.altoslib_14.AltosFlightReader;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosPreferences;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altosuilib_14.AltosDisplayThread;
import org.altusmetrum.altosuilib_14.AltosInfoTable;
import org.altusmetrum.altosuilib_14.AltosUIFrame;
import org.altusmetrum.altosuilib_14.AltosUIFreqList;
import org.altusmetrum.altosuilib_14.AltosUIMap;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;
import org.altusmetrum.altosuilib_14.AltosUIRateList;
import org.altusmetrum.altosuilib_14.AltosUITelemetryList;
import org.altusmetrum.altosuilib_14.AltosVoice;

public class AltosFlightUI
extends AltosUIFrame
implements AltosFlightDisplay {
    AltosVoice voice;
    AltosFlightReader reader;
    AltosDisplayThread thread;
    LinkedList<AltosFlightDisplay> displays;
    JTabbedPane pane;
    AltosPad pad;
    AltosIgnitor igniter;
    AltosAscent ascent;
    AltosDescent descent;
    AltosLanded landed;
    AltosCompanionInfo companion;
    AltosUIMap sitemap;
    boolean has_map;
    boolean has_companion;
    boolean has_state;
    boolean has_igniter;
    private AltosFlightStatus flightStatus;
    private AltosInfoTable flightInfo;
    boolean exit_on_close = false;
    JComponent cur_tab = null;
    AltosFlightStatusUpdate status_update;
    Container bag;
    AltosUIFreqList frequencies;
    AltosUIRateList rates;
    AltosUITelemetryList telemetries;
    JLabel telemetry;
    ActionListener show_timer;

    JComponent which_tab(AltosState altosState) {
        if (altosState.state() < 3) {
            return this.pad;
        }
        if (altosState.state() <= 5) {
            return this.ascent;
        }
        if (altosState.state() <= 7) {
            return this.descent;
        }
        if (altosState.state() == 10) {
            return this.descent;
        }
        return this.landed;
    }

    void stop_display() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.thread = null;
    }

    void disconnect() {
        this.stop_display();
    }

    @Override
    public void reset() {
        for (AltosFlightDisplay altosFlightDisplay : this.displays) {
            altosFlightDisplay.reset();
        }
    }

    @Override
    public void font_size_changed(int n) {
        for (AltosFlightDisplay altosFlightDisplay : this.displays) {
            altosFlightDisplay.font_size_changed(n);
        }
    }

    @Override
    public void units_changed(boolean bl) {
        for (AltosFlightDisplay altosFlightDisplay : this.displays) {
            altosFlightDisplay.units_changed(bl);
        }
    }

    @Override
    public void show(AltosState altosState, AltosListenerState altosListenerState) {
        JComponent jComponent;
        this.status_update.saved_state = altosState;
        this.status_update.saved_listener_state = altosListenerState;
        if (altosState == null) {
            altosState = new AltosState(new AltosCalData());
        }
        if (altosState.state() != 0 && !this.has_state) {
            this.pane.setTitleAt(0, "Launch Pad");
            this.pane.add((Component)this.ascent, 1);
            this.pane.add((Component)this.descent, 2);
            this.pane.add((Component)this.landed, 3);
            this.has_state = true;
        }
        if ((jComponent = this.which_tab(altosState)) != this.cur_tab) {
            if (this.cur_tab == this.pane.getSelectedComponent()) {
                this.pane.setSelectedComponent(jComponent);
            }
            this.cur_tab = jComponent;
        }
        if (this.igniter.should_show(altosState)) {
            if (!this.has_igniter) {
                this.pane.add("Ignitor", this.igniter);
                this.has_igniter = true;
            }
        } else if (this.has_igniter) {
            this.pane.remove(this.igniter);
            this.has_igniter = false;
        }
        if (altosState.companion != null) {
            if (!this.has_companion) {
                this.pane.add("Companion", this.companion);
                this.has_companion = true;
            }
        } else if (this.has_companion) {
            this.pane.remove(this.companion);
            this.has_companion = false;
        }
        if (altosState.gps != null) {
            if (!this.has_map) {
                this.pane.add("Site Map", this.sitemap);
                this.has_map = true;
            }
        } else if (this.has_map) {
            this.pane.remove(this.sitemap);
            this.has_map = false;
        }
        for (AltosFlightDisplay altosFlightDisplay : this.displays) {
            try {
                altosFlightDisplay.show(altosState, altosListenerState);
            }
            catch (Exception exception) {
                System.out.printf("Exception showing %s\n", altosFlightDisplay.getName());
                exception.printStackTrace();
            }
        }
    }

    public void set_exit_on_close() {
        this.exit_on_close = true;
    }

    public AltosFlightUI(AltosVoice altosVoice, AltosFlightReader altosFlightReader, int n) {
        AltosUIPreferences.set_component(this);
        this.displays = new LinkedList();
        this.voice = altosVoice;
        this.reader = altosFlightReader;
        this.bag = this.getScrollablePane();
        this.bag.setLayout(new GridBagLayout());
        this.setTitle(String.format("AltOS %s", this.reader.name));
        if (n >= 0) {
            this.set_inset(3);
            this.frequencies = new AltosUIFreqList(AltosUIPreferences.frequency(n));
            this.frequencies.set_product("Monitor");
            this.frequencies.set_serial(n);
            this.frequencies.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    double d = AltosFlightUI.this.frequencies.frequency();
                    try {
                        AltosFlightUI.this.reader.set_frequency(d);
                    }
                    catch (TimeoutException timeoutException) {
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    AltosFlightUI.this.reader.save_frequency();
                }
            });
            this.bag.add((Component)this.frequencies, this.constraints(0, 1));
            this.rates = new AltosUIRateList(AltosUIPreferences.telemetry_rate(n));
            this.rates.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = AltosFlightUI.this.rates.rate();
                    try {
                        AltosFlightUI.this.reader.set_telemetry_rate(n);
                    }
                    catch (TimeoutException timeoutException) {
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    AltosFlightUI.this.reader.save_telemetry_rate();
                }
            });
            this.rates.setEnabled(this.reader.supports_telemetry_rate(2));
            this.bag.add((Component)this.rates, this.constraints(1, 1));
            if (this.reader.supports_telemetry(1)) {
                this.telemetries = new AltosUITelemetryList(n);
                this.telemetries.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        int n = AltosFlightUI.this.telemetries.get_selected();
                        AltosFlightUI.this.reader.set_telemetry(n);
                        AltosFlightUI.this.reader.save_telemetry();
                    }
                });
                this.bag.add((Component)this.telemetries, this.constraints(2, 1));
            } else {
                String string = this.reader.supports_telemetry(2) ? "Telemetry: 0.9" : (this.reader.supports_telemetry(3) ? "Telemetry: 0.8" : "Telemetry: None");
                this.telemetry = new JLabel(string);
                this.bag.add((Component)this.telemetry, this.constraints(2, 1));
            }
            this.next_row();
        }
        this.set_inset(0);
        this.flightStatus = new AltosFlightStatus();
        this.displays.add(this.flightStatus);
        this.bag.add((Component)this.flightStatus, this.constraints(0, 4, 2));
        this.next_row();
        this.pane = new JTabbedPane();
        this.pad = new AltosPad();
        this.displays.add(this.pad);
        this.pane.add("Status", this.pad);
        this.igniter = new AltosIgnitor();
        this.displays.add(this.igniter);
        this.ascent = new AltosAscent();
        this.displays.add(this.ascent);
        this.descent = new AltosDescent();
        this.displays.add(this.descent);
        this.landed = new AltosLanded(this.reader);
        this.displays.add(this.landed);
        this.flightInfo = new AltosInfoTable();
        this.displays.add(this.flightInfo);
        this.pane.add("Table", new JScrollPane(this.flightInfo));
        this.companion = new AltosCompanionInfo();
        this.displays.add(this.companion);
        this.has_companion = false;
        this.has_state = false;
        this.sitemap = new AltosUIMap();
        this.displays.add(this.sitemap);
        this.has_map = false;
        this.bag.add((Component)this.pane, this.constraints(0, 4, 1));
        this.setDefaultCloseOperation(0);
        AltosUIPreferences.register_font_listener(this);
        AltosPreferences.register_units_listener(this);
        this.status_update = new AltosFlightStatusUpdate(this.flightStatus);
        this.flightStatus.start(this.status_update);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                AltosFlightUI.this.flightStatus.stop();
                AltosFlightUI.this.disconnect();
                AltosFlightUI.this.setVisible(false);
                AltosFlightUI.this.dispose();
                AltosUIPreferences.unregister_font_listener(AltosFlightUI.this);
                AltosPreferences.unregister_units_listener(AltosFlightUI.this);
                if (AltosFlightUI.this.exit_on_close) {
                    System.exit(0);
                }
            }
        });
        this.pack();
        this.setVisible(true);
        this.thread = new AltosDisplayThread(this, this.voice, this, this.reader);
        this.thread.start();
    }

    public AltosFlightUI(AltosVoice altosVoice, AltosFlightReader altosFlightReader) {
        this(altosVoice, altosFlightReader, -1);
    }
}

