/*
 * Decompiled with CFR 0.152.
 */
package altosui;

import altosui.AltosConfigFCUI;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.altusmetrum.altoslib_14.AltosConfigDataException;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosParse;
import org.altusmetrum.altoslib_14.AltosPreferences;
import org.altusmetrum.altoslib_14.AltosPyro;
import org.altusmetrum.altoslib_14.AltosUnits;
import org.altusmetrum.altoslib_14.AltosUnitsListener;
import org.altusmetrum.altosuilib_14.AltosUIDialog;

public class AltosConfigPyroUI
extends AltosUIDialog
implements ItemListener,
DocumentListener,
AltosUnitsListener,
ActionListener {
    AltosConfigFCUI owner;
    Container pane;
    static Insets il = new Insets(4, 4, 4, 4);
    static Insets ir = new Insets(4, 4, 4, 4);
    static String[] state_names;
    PyroColumn[] columns;
    JLabel[] labels;
    JLabel pyro_firing_time_label;
    JComboBox<String> pyro_firing_time_value;
    static String[] pyro_firing_time_values;
    boolean initializing;

    static void make_state_names() {
        if (state_names == null) {
            state_names = new String[6];
            for (int i = 3; i <= 8; ++i) {
                AltosConfigPyroUI.state_names[i - 3] = AltosLib.state_name_capital(i);
            }
        }
    }

    public void set_pyros(AltosPyro[] altosPyroArray) {
        for (int i = 0; i < altosPyroArray.length; ++i) {
            if (altosPyroArray[i].channel >= this.columns.length) continue;
            this.columns[altosPyroArray[i].channel].set(altosPyroArray[i]);
        }
    }

    public AltosPyro[] get_pyros() throws AltosConfigDataException {
        AltosPyro[] altosPyroArray = new AltosPyro[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            try {
                altosPyroArray[i] = this.columns[i].get();
                continue;
            }
            catch (AltosConfigDataException altosConfigDataException) {
                throw new AltosConfigDataException("Channel %c, %s", i + 65, altosConfigDataException.getMessage());
            }
        }
        return altosPyroArray;
    }

    public void set_pyro_firing_time(double d) {
        this.initializing = true;
        this.pyro_firing_time_value.setSelectedItem(Double.toString(d));
        this.pyro_firing_time_value.setEnabled(d >= 0.0);
        this.initializing = false;
    }

    public double get_pyro_firing_time() throws AltosConfigDataException {
        String string = this.pyro_firing_time_value.getSelectedItem().toString();
        try {
            return AltosParse.parse_double_locale(string);
        }
        catch (ParseException parseException) {
            throw new AltosConfigDataException("Invalid pyro firing time \"%s\"", string);
        }
    }

    public void set_dirty() {
        if (!this.initializing) {
            this.owner.set_dirty();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.initializing) {
            this.owner.set_dirty();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (!this.initializing) {
            this.owner.set_dirty();
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.initializing) {
            this.owner.set_dirty();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.initializing) {
            this.owner.set_dirty();
        }
    }

    @Override
    public void units_changed(boolean bl) {
        int n;
        for (n = 0; n < this.columns.length; ++n) {
            this.columns[n].units_changed(bl);
        }
        n = 0;
        for (int i = 1; i <= 65535; i <<= 1) {
            String string;
            if ((i & 0xF3FF) == 0 || (string = AltosPyro.pyro_to_name(i)) == null) continue;
            this.labels[n].setText(string);
            ++n;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Close")) {
            this.setVisible(false);
        }
    }

    public AltosConfigPyroUI(AltosConfigFCUI altosConfigFCUI, AltosPyro[] altosPyroArray, double d) {
        super(altosConfigFCUI, "Configure Pyro Channels", false);
        GridBagConstraints gridBagConstraints;
        int n;
        int n2;
        this.owner = altosConfigFCUI;
        this.pane = this.getScrollablePane();
        this.pane.setLayout(new GridBagLayout());
        int n3 = 0;
        for (n2 = 1; n2 < 65535; n2 <<= 1) {
            if ((n2 & 0xF3FF) == 0) continue;
            ++n3;
        }
        this.labels = new JLabel[n3];
        n2 = 1;
        for (n = 1; n <= 65535; n <<= 1) {
            String string;
            if ((n & 0xF3FF) == 0 || (string = AltosPyro.pyro_to_name(n)) == null) continue;
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n2;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = il;
            JLabel jLabel = new JLabel(string);
            this.pane.add((Component)jLabel, gridBagConstraints);
            this.labels[n2 - 1] = jLabel;
            ++n2;
        }
        this.columns = new PyroColumn[altosPyroArray.length];
        for (n = 0; n < altosPyroArray.length; ++n) {
            this.columns[n] = new PyroColumn(this, n * 2 + 1, 0, n);
            this.columns[n].set(altosPyroArray[n]);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = il;
        gridBagConstraints.ipady = 5;
        this.pyro_firing_time_label = new JLabel("Pyro Firing Time(s):");
        this.pane.add((Component)this.pyro_firing_time_label, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = ir;
        gridBagConstraints.ipady = 5;
        this.pyro_firing_time_value = new JComboBox<String>(pyro_firing_time_values);
        this.pyro_firing_time_value.setEditable(true);
        this.pyro_firing_time_value.addItemListener(this);
        this.set_pyro_firing_time(d);
        this.pane.add(this.pyro_firing_time_value, gridBagConstraints);
        this.pyro_firing_time_value.setToolTipText("Length of extra pyro channel firing pulse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = altosPyroArray.length * 2 - 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridy = 1000;
        JButton jButton = new JButton("Close");
        this.pane.add((Component)jButton, gridBagConstraints);
        jButton.addActionListener(this);
        jButton.setActionCommand("Close");
        this.addWindowListener(new ConfigListener(this, this.owner));
        AltosPreferences.register_units_listener(this);
    }

    @Override
    public void dispose() {
        AltosPreferences.unregister_units_listener(this);
        super.dispose();
    }

    public void make_visible() {
        this.pack();
        this.setVisible(true);
    }

    static {
        pyro_firing_time_values = new String[]{"0.050", "0.100", "0.250", "0.500", "1.0", "2.0"};
    }

    class ConfigListener
    extends WindowAdapter {
        AltosConfigPyroUI ui;
        AltosConfigFCUI owner;

        public ConfigListener(AltosConfigPyroUI altosConfigPyroUI2, AltosConfigFCUI altosConfigFCUI) {
            this.ui = altosConfigPyroUI2;
            this.owner = altosConfigFCUI;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.ui.setVisible(false);
        }
    }

    class PyroColumn
    implements AltosUnitsListener {
        public PyroItem[] items;
        public JLabel label;
        int channel;

        public void set(AltosPyro altosPyro) {
            int n = 0;
            if ((altosPyro.flags & 0xC00) != 0) {
                JOptionPane.showMessageDialog(AltosConfigPyroUI.this.owner, String.format("Pyro settings \u201cAscending\u201d and \u201cDescending\u201d are deprecated.\nClearing %s configuration.", AltosLib.igniter_name(altosPyro.channel)), "Deprecated Pyro Settings", 0);
                altosPyro.flags = 0;
                AltosConfigPyroUI.this.owner.set_dirty();
            }
            for (int i = 1; i < 65535; i <<= 1) {
                if ((0xF3FF & i) == 0) continue;
                this.items[n].set((altosPyro.flags & i) != 0, altosPyro.get_value(i));
                ++n;
            }
        }

        public AltosPyro get() throws AltosConfigDataException {
            AltosPyro altosPyro = new AltosPyro(this.channel);
            int n = 0;
            for (int i = 1; i < 65535; i <<= 1) {
                if ((0xF3FF & i) == 0) continue;
                if (this.items[n].enabled()) {
                    try {
                        altosPyro.flags |= i;
                        altosPyro.set_value(i, this.items[n].value());
                    }
                    catch (AltosConfigDataException altosConfigDataException) {
                        throw new AltosConfigDataException("%s, %s", AltosPyro.pyro_to_name(i), altosConfigDataException.getMessage());
                    }
                }
                ++n;
            }
            return altosPyro;
        }

        @Override
        public void units_changed(boolean bl) {
            int n = 0;
            for (int i = 1; i < 65535; i <<= 1) {
                if ((0xF3FF & i) == 0) continue;
                this.items[n].units_changed(bl);
                ++n;
            }
        }

        public PyroColumn(AltosConfigPyroUI altosConfigPyroUI2, int n, int n2, int n3) {
            int n4;
            this.channel = n3;
            int n5 = 0;
            for (n4 = 1; n4 < 65535; n4 <<= 1) {
                if ((n4 & 0xF3FF) == 0) continue;
                ++n5;
            }
            this.items = new PyroItem[n5];
            n4 = 0;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2++;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = il;
            this.label = new JLabel(String.format("Pyro Channel %c", 65 + this.channel));
            AltosConfigPyroUI.this.pane.add((Component)this.label, gridBagConstraints);
            for (int i = 1; i < 65535; i <<= 1) {
                if ((i & 0xF3FF) == 0) continue;
                this.items[n4] = new PyroItem(altosConfigPyroUI2, i, n, n2 + n4);
                ++n4;
            }
        }
    }

    class PyroItem
    implements ItemListener,
    DocumentListener,
    AltosUnitsListener {
        public int flag;
        public JCheckBox enable;
        public JTextField value;
        public JComboBox<String> combo;
        AltosConfigPyroUI ui;
        boolean setting;

        public void set_enable(boolean bl) {
            if (this.value != null) {
                this.value.setEnabled(bl);
            }
            if (this.combo != null) {
                this.combo.setEnabled(bl);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.set_enable(this.enable.isSelected());
            if (!this.setting) {
                this.ui.set_dirty();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            if (!this.setting) {
                this.ui.set_dirty();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (!this.setting) {
                this.ui.set_dirty();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (!this.setting) {
                this.ui.set_dirty();
            }
        }

        @Override
        public void units_changed(boolean bl) {
            AltosUnits altosUnits = AltosPyro.pyro_to_units(this.flag);
            if (altosUnits != null) {
                try {
                    double d = altosUnits.parse_locale(this.value.getText(), !bl);
                    this.set(this.enabled(), d);
                }
                catch (ParseException parseException) {
                    this.set(this.enabled(), 0.0);
                }
            }
        }

        public void set(boolean bl, double d) {
            this.setting = true;
            this.enable.setSelected(bl);
            this.set_enable(bl);
            if (this.value != null) {
                double d2 = AltosPyro.pyro_to_scale(this.flag);
                double d3 = d;
                AltosUnits altosUnits = AltosPyro.pyro_to_units(this.flag);
                if (altosUnits != null) {
                    d3 = altosUnits.parse_value(d);
                }
                String string = d2 >= 100.0 ? "%6.2f" : (d2 >= 10.0 ? "%6.1f" : "%6.0f");
                this.value.setText(String.format(string, d3));
            }
            if (this.combo != null && d >= 3.0 && d <= 8.0) {
                this.combo.setSelectedIndex((int)d - 3);
            }
            this.setting = false;
        }

        public boolean enabled() {
            return this.enable.isSelected();
        }

        public double value() throws AltosConfigDataException {
            if (this.value != null) {
                AltosUnits altosUnits = AltosPyro.pyro_to_units(this.flag);
                try {
                    if (altosUnits != null) {
                        return altosUnits.parse_locale(this.value.getText());
                    }
                    return AltosParse.parse_double_locale(this.value.getText());
                }
                catch (ParseException parseException) {
                    throw new AltosConfigDataException("\"%s\": %s\n", this.value.getText(), parseException.getMessage());
                }
            }
            if (this.combo != null) {
                return this.combo.getSelectedIndex() + 3;
            }
            return 0.0;
        }

        public PyroItem(AltosConfigPyroUI altosConfigPyroUI2, int n, int n2, int n3) {
            this.ui = altosConfigPyroUI2;
            this.flag = n;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = n2;
            gridBagConstraints.gridy = n3;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.insets = il;
            this.enable = new JCheckBox();
            this.enable.addItemListener(this);
            AltosConfigPyroUI.this.pane.add((Component)this.enable, gridBagConstraints);
            if ((this.flag & 0xC00) == 0) {
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = n2 + 1;
                gridBagConstraints.gridy = n3;
                gridBagConstraints.gridwidth = 1;
                gridBagConstraints.fill = 0;
                gridBagConstraints.anchor = 21;
                gridBagConstraints.insets = il;
                if ((this.flag & 0xC000) != 0) {
                    AltosConfigPyroUI.make_state_names();
                    this.combo = new JComboBox<String>(state_names);
                    this.combo.addItemListener(this);
                    AltosConfigPyroUI.this.pane.add(this.combo, gridBagConstraints);
                } else {
                    this.value = new JTextField(10);
                    this.value.getDocument().addDocumentListener(this);
                    AltosConfigPyroUI.this.pane.add((Component)this.value, gridBagConstraints);
                }
            }
        }
    }
}

