/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.concurrent.TimeoutException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosConfigData;
import org.altusmetrum.altoslib_14.AltosFrequency;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosTelemetryReader;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosDeviceUIDialog;
import org.altusmetrum.altosuilib_14.AltosScanResult;
import org.altusmetrum.altosuilib_14.AltosScanResults;
import org.altusmetrum.altosuilib_14.AltosSerial;
import org.altusmetrum.altosuilib_14.AltosSerialInUseException;
import org.altusmetrum.altosuilib_14.AltosUIDialog;
import org.altusmetrum.altosuilib_14.AltosUIFrame;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;

public class AltosScanUI
extends AltosUIDialog
implements ActionListener {
    AltosUIFrame owner;
    AltosDevice device;
    AltosConfigData config_data;
    AltosTelemetryReader reader;
    private JList<AltosScanResult> list;
    private JLabel scanning_label;
    private JLabel frequency_label;
    private JLabel telemetry_label;
    private JLabel rate_label;
    private JButton cancel_button;
    private JButton monitor_button;
    private JCheckBox[] telemetry_boxes;
    private JCheckBox[] rate_boxes;
    Timer timer;
    AltosScanResults results = new AltosScanResults();
    int telemetry;
    boolean select_telemetry = false;
    int rate;
    boolean select_rate = false;
    static final int timeout = 1200;
    TelemetryHandler handler;
    Thread thread;
    AltosFrequency[] frequencies;
    int frequency_index;
    int packet_count;
    int tick_count;

    void scan_exception(Exception exception) {
        if (exception instanceof FileNotFoundException) {
            JOptionPane.showMessageDialog(this.owner, ((FileNotFoundException)exception).getMessage(), "Cannot open target device", 0);
        } else if (exception instanceof AltosSerialInUseException) {
            JOptionPane.showMessageDialog(this.owner, String.format("Device \"%s\" already in use", this.device.toShortString()), "Device in use", 0);
        } else if (exception instanceof IOException) {
            IOException iOException = (IOException)exception;
            JOptionPane.showMessageDialog(this.owner, this.device.toShortString(), iOException.getLocalizedMessage(), 0);
        } else {
            JOptionPane.showMessageDialog(this.owner, String.format("Connection to \"%s\" failed", this.device.toShortString()), "Connection Failed", 0);
        }
        this.close();
    }

    void set_label() {
        this.frequency_label.setText(String.format("Frequency: %s", this.frequencies[this.frequency_index].toString()));
        if (this.select_telemetry) {
            this.telemetry_label.setText(String.format("Telemetry: %s", AltosLib.telemetry_name((int)this.telemetry)));
        }
        if (this.select_rate) {
            this.rate_label.setText(String.format("Rate: %d baud", AltosLib.ao_telemetry_rate_values[this.rate]));
        }
    }

    void set_telemetry() {
        this.reader.set_telemetry(this.telemetry);
    }

    void set_rate() {
        this.reader.set_telemetry_rate(this.rate);
    }

    void set_frequency() throws InterruptedException, TimeoutException {
        this.reader.set_frequency(this.frequencies[this.frequency_index].frequency);
        this.reader.reset();
    }

    void next() throws InterruptedException, TimeoutException {
        boolean bl;
        this.reader.set_monitor(false);
        if (this.select_rate) {
            bl = false;
            do {
                ++this.rate;
                if (this.rate <= 2) continue;
                bl = true;
                this.rate = 0;
            } while (!this.rate_boxes[this.rate].isSelected());
            this.set_rate();
            if (!bl) {
                this.set_label();
                return;
            }
        }
        if (this.select_telemetry) {
            bl = false;
            do {
                ++this.telemetry;
                if (this.telemetry <= 3) continue;
                bl = true;
                this.telemetry = 1;
            } while (!this.telemetry_boxes[this.telemetry - 1].isSelected());
            this.set_telemetry();
            if (!bl) {
                this.set_label();
                return;
            }
        }
        this.packet_count = 0;
        this.tick_count = 0;
        ++this.frequency_index;
        if (this.frequency_index >= this.frequencies.length) {
            this.frequency_index = 0;
        }
        this.set_frequency();
        this.set_label();
        this.reader.set_monitor(true);
    }

    void close() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.thread = null;
        if (this.timer != null) {
            this.timer.stop();
        }
        this.setVisible(false);
        this.dispose();
    }

    void tick_timer() throws InterruptedException, TimeoutException {
        ++this.tick_count;
        if (this.packet_count == 0 || this.tick_count > 5) {
            this.next();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        try {
            int n;
            int n2;
            if (string.equals("cancel")) {
                this.close();
            }
            if (string.equals("tick")) {
                this.tick_timer();
            }
            if (string.equals("telemetry")) {
                n2 = 0;
                for (n = 1; n <= 3; ++n) {
                    int n3 = n - 1;
                    if (!this.telemetry_boxes[n3].isSelected()) continue;
                    n2 |= 1 << n;
                }
                if (n2 == 0) {
                    n2 |= 2;
                    this.telemetry_boxes[0].setSelected(true);
                }
                AltosUIPreferences.set_scanning_telemetry((int)n2);
            }
            if (string.equals("rate")) {
                n2 = 0;
                for (n = 0; n <= 2; ++n) {
                    if (!this.rate_boxes[n].isSelected()) continue;
                    n2 |= 1 << n;
                }
                if (n2 == 0) {
                    n2 = 1;
                    this.rate_boxes[0].setSelected(true);
                }
                AltosUIPreferences.set_scanning_telemetry_rate((int)n2);
            }
            if (string.equals("monitor")) {
                this.close();
                AltosScanResult altosScanResult = this.list.getSelectedValue();
                if (altosScanResult != null && this.device != null && this.reader != null) {
                    this.reader.set_telemetry(altosScanResult.telemetry);
                    this.reader.set_telemetry_rate(altosScanResult.rate);
                    this.reader.set_frequency(altosScanResult.frequency.frequency);
                    this.reader.save_frequency();
                    this.reader.save_telemetry();
                    this.reader.save_telemetry_rate();
                    this.owner.scan_device_selected(this.device);
                }
            }
        }
        catch (TimeoutException timeoutException) {
            this.close();
        }
        catch (InterruptedException interruptedException) {
            this.close();
        }
    }

    private boolean open() {
        this.device = AltosDeviceUIDialog.show(this.owner, 65537);
        if (this.device == null) {
            return false;
        }
        try {
            this.reader = new AltosTelemetryReader((AltosLink)new AltosSerial(this.device));
            this.set_frequency();
            this.set_telemetry();
            this.set_rate();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.reader.flush();
            this.handler = new TelemetryHandler();
            this.thread = new Thread(this.handler);
            this.thread.start();
            return true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this.owner, fileNotFoundException.getMessage(), "Cannot open target device", 0);
        }
        catch (AltosSerialInUseException altosSerialInUseException) {
            JOptionPane.showMessageDialog(this.owner, String.format("Device \"%s\" already in use", this.device.toShortString()), "Device in use", 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.owner, this.device.toShortString(), "Unkonwn I/O error", 0);
        }
        catch (TimeoutException timeoutException) {
            JOptionPane.showMessageDialog(this.owner, this.device.toShortString(), "Timeout error", 0);
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(this.owner, this.device.toShortString(), "Interrupted exception", 0);
        }
        if (this.reader != null) {
            this.reader.close(false);
        }
        return false;
    }

    public AltosScanUI(AltosUIFrame altosUIFrame, boolean bl) {
        super(altosUIFrame, "Scan Telemetry", false);
        int n;
        int n2;
        this.owner = altosUIFrame;
        this.select_telemetry = bl;
        this.select_rate = true;
        this.frequencies = AltosUIPreferences.common_frequencies();
        this.frequency_index = 0;
        this.telemetry = 1;
        this.rate = 0;
        if (!this.open()) {
            return;
        }
        Container container = this.getScrollablePane();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        Insets insets = new Insets(4, 4, 4, 4);
        this.timer = new Timer(1200, this);
        this.timer.setActionCommand("tick");
        this.timer.restart();
        this.owner = altosUIFrame;
        container.setLayout(new GridBagLayout());
        this.scanning_label = new JLabel("Scanning:");
        this.frequency_label = new JLabel("");
        if (this.select_telemetry) {
            this.telemetry_label = new JLabel("");
            this.telemetry_label.setPreferredSize(new Dimension(100, 16));
            this.telemetry = 1;
        } else {
            this.telemetry = 1;
        }
        if (this.select_rate) {
            this.rate_label = new JLabel("");
            this.rate_label.setPreferredSize(new Dimension(100, 16));
        }
        this.set_label();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        container.add((Component)this.scanning_label, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        container.add((Component)this.frequency_label, gridBagConstraints);
        int n3 = 3;
        int n4 = 3;
        int n5 = 0;
        if (this.select_rate && this.select_telemetry) {
            gridBagConstraints.gridwidth = 1;
        }
        if (this.select_rate) {
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = n5++;
            container.add((Component)this.rate_label, gridBagConstraints);
            n2 = AltosUIPreferences.scanning_telemetry_rate();
            this.rate_boxes = new JCheckBox[3];
            for (n = 0; n <= 2; ++n) {
                this.rate_boxes[n] = new JCheckBox(String.format("%d baud", AltosLib.ao_telemetry_rate_values[n]));
                gridBagConstraints.gridy = n3 + n;
                container.add((Component)this.rate_boxes[n], gridBagConstraints);
                this.rate_boxes[n].setActionCommand("rate");
                this.rate_boxes[n].addActionListener(this);
                this.rate_boxes[n].setSelected((n2 & 1 << n) != 0);
            }
            n3 += 3;
        }
        if (this.select_telemetry) {
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = n5++;
            container.add((Component)this.telemetry_label, gridBagConstraints);
            n2 = AltosUIPreferences.scanning_telemetry();
            this.telemetry_boxes = new JCheckBox[3];
            for (n = 1; n <= 3; ++n) {
                int n6 = n - 1;
                this.telemetry_boxes[n6] = new JCheckBox(AltosLib.telemetry_name((int)n));
                gridBagConstraints.gridy = n4 + n6;
                container.add((Component)this.telemetry_boxes[n6], gridBagConstraints);
                this.telemetry_boxes[n6].setActionCommand("telemetry");
                this.telemetry_boxes[n6].addActionListener(this);
                this.telemetry_boxes[n6].setSelected((n2 & 1 << n) != 0);
            }
            n4 += 3;
        }
        n2 = Math.max(n3, n4);
        this.list = new JList<AltosScanResult>((ListModel)this.results){

            @Override
            public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
                int n3;
                if (n == 1 && n2 < 0 && (n3 = this.getFirstVisibleIndex()) != -1) {
                    Rectangle rectangle2 = this.getCellBounds(n3, n3);
                    if (rectangle2.y == rectangle.y && n3 != 0) {
                        Point point = rectangle2.getLocation();
                        --point.y;
                        int n4 = this.locationToIndex(point);
                        Rectangle rectangle3 = this.getCellBounds(n4, n4);
                        if (rectangle3 == null || rectangle3.y >= rectangle2.y) {
                            return 0;
                        }
                        return rectangle3.height;
                    }
                }
                return super.getScrollableUnitIncrement(rectangle, n, n2);
            }
        };
        this.list.setSelectionMode(0);
        this.list.setLayoutOrientation(2);
        this.list.setVisibleRowCount(-1);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    AltosScanUI.this.monitor_button.doClick();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setPreferredSize(new Dimension(400, 80));
        jScrollPane.setAlignmentX(0.0f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 3));
        JLabel jLabel = new JLabel("Select Device");
        jLabel.setLabelFor(this.list);
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        jPanel.add(jScrollPane);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        container.add((Component)jPanel, gridBagConstraints);
        this.cancel_button = new JButton("Cancel");
        this.cancel_button.addActionListener(this);
        this.cancel_button.setActionCommand("cancel");
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = n2 + 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        container.add((Component)this.cancel_button, gridBagConstraints);
        this.monitor_button = new JButton("Monitor");
        this.monitor_button.addActionListener(this);
        this.monitor_button.setActionCommand("monitor");
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = n2 + 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        container.add((Component)this.monitor_button, gridBagConstraints);
        this.pack();
        this.setLocationRelativeTo(this.owner);
        this.addWindowListener(new ConfigListener(this));
        this.setVisible(true);
    }

    class ConfigListener
    extends WindowAdapter {
        AltosScanUI ui;

        public ConfigListener(AltosScanUI altosScanUI2) {
            this.ui = altosScanUI2;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            this.ui.actionPerformed(new ActionEvent(windowEvent.getSource(), 1001, "close"));
        }
    }

    class TelemetryHandler
    implements Runnable {
        TelemetryHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block11: {
                var1_1 = false;
                try {
                    try {
                        while (true) lbl-1000:
                        // 3 sources

                        {
                            try {
                                while (true) {
                                    if ((var2_2 = AltosScanUI.this.reader.read()) == null) {
                                        continue;
                                    }
                                    ++AltosScanUI.this.packet_count;
                                    var3_7 = var2_2.cal_data();
                                    if (var3_7.flight == 0x7FFFFFFF) continue;
                                    var4_8 = new AltosScanResult(var3_7.callsign, var3_7.serial, var3_7.flight, AltosScanUI.this.frequencies[AltosScanUI.this.frequency_index], AltosScanUI.this.telemetry, AltosScanUI.this.rate);
                                    var5_9 = new Runnable(){

                                        @Override
                                        public void run() {
                                            AltosScanUI.this.results.add(var4_8);
                                        }
                                    };
                                    SwingUtilities.invokeLater(var5_9);
                                }
                            }
                            catch (ParseException var2_3) {
                            }
                            catch (AltosCRCException var2_4) {
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedException var2_5) {
                        var1_1 = true;
                        AltosScanUI.this.reader.close(var1_1);
                        break block11;
                    }
                    catch (IOException var2_6) {
                        AltosScanUI.this.reader.close(var1_1);
                    }
                    ** GOTO lbl-1000
                }
                catch (Throwable var6_10) {
                    AltosScanUI.this.reader.close(var1_1);
                    throw var6_10;
                }
            }
        }
    }
}

