/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import org.altusmetrum.altoslib_14.AltosFrequency;
import org.altusmetrum.altoslib_14.AltosLib;

class AltosScanResult {
    String callsign;
    int serial;
    int flight;
    AltosFrequency frequency;
    int telemetry;
    int rate;
    boolean interrupted = false;

    public String toString() {
        return String.format("%-9.9s serial %-4d flight %-4d (%s %s %d)", this.callsign, this.serial, this.flight, this.frequency.toShortString(), AltosLib.telemetry_name((int)this.telemetry), AltosLib.ao_telemetry_rate_values[this.rate]);
    }

    public String toShortString() {
        return String.format("%s %d %d %7.3f %d %d", this.callsign, this.serial, this.flight, this.frequency, this.telemetry, this.rate);
    }

    public AltosScanResult(String string, int n, int n2, AltosFrequency altosFrequency, int n3, int n4) {
        this.callsign = string;
        this.serial = n;
        this.flight = n2;
        this.frequency = altosFrequency;
        this.telemetry = n3;
        this.rate = n4;
    }

    public int hashCode() {
        return this.serial ^ this.frequency.hashCode() ^ this.telemetry ^ this.rate;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof AltosScanResult)) {
            return false;
        }
        AltosScanResult altosScanResult = (AltosScanResult)object;
        return this.serial == altosScanResult.serial && this.frequency.equals((Object)altosScanResult.frequency) && this.telemetry == altosScanResult.telemetry && this.rate == altosScanResult.rate;
    }

    public boolean up_to_date(AltosScanResult altosScanResult) {
        if (this.flight == 0 && altosScanResult.flight != 0) {
            this.flight = altosScanResult.flight;
            return false;
        }
        if (this.callsign.equals("N0CALL") && !altosScanResult.callsign.equals("N0CALL")) {
            this.callsign = altosScanResult.callsign;
            return false;
        }
        return true;
    }
}

