/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.altusmetrum.altoslib_14.AltosFrequency;
import org.altusmetrum.altosuilib_14.AltosEditFreqUI;
import org.altusmetrum.altosuilib_14.AltosUIDialog;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;

public class AltosConfigFreqUI
extends AltosUIDialog
implements ActionListener {
    Frame frame;
    LinkedList<ActionListener> listeners;
    FrequencyList frequencies;
    JButton add;
    JButton edit;
    JButton remove;
    JButton cancel;
    JButton ok;

    void save_frequencies() {
        AltosUIPreferences.set_common_frequencies((AltosFrequency[])this.frequencies.frequencies());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok".equals(string)) {
            this.save_frequencies();
            this.setVisible(false);
        } else if ("cancel".equals(string)) {
            this.setVisible(false);
        } else if ("add".equals(string)) {
            AltosEditFreqUI altosEditFreqUI = new AltosEditFreqUI(this.frame);
            altosEditFreqUI.setVisible(true);
            AltosFrequency altosFrequency = altosEditFreqUI.get();
            if (altosFrequency != null) {
                this.frequencies.add(altosFrequency);
            }
        } else if ("edit".equals(string)) {
            AltosFrequency altosFrequency = this.frequencies.selected();
            if (altosFrequency == null) {
                return;
            }
            AltosEditFreqUI altosEditFreqUI = new AltosEditFreqUI(this.frame, altosFrequency);
            altosEditFreqUI.setVisible(true);
            AltosFrequency altosFrequency2 = altosEditFreqUI.get();
            if (altosFrequency2 != null) {
                if (altosFrequency != null) {
                    this.frequencies.remove(altosFrequency);
                }
                this.frequencies.add(altosFrequency2);
            }
        } else if ("remove".equals(string)) {
            AltosFrequency altosFrequency = this.frequencies.selected();
            if (altosFrequency == null) {
                return;
            }
            int n = JOptionPane.showConfirmDialog(this, String.format("Remove frequency \"%s\"?", altosFrequency.toShortString()), "Remove Frequency", 0);
            if (n == 0) {
                this.frequencies.remove(altosFrequency);
            }
        }
    }

    public AltosFrequency[] frequencies() {
        return this.frequencies.frequencies();
    }

    public AltosConfigFreqUI(Frame frame, AltosFrequency[] altosFrequencyArray) {
        super(frame, "Manage Frequencies", true);
        this.frame = frame;
        this.listeners = new LinkedList();
        this.frequencies = new FrequencyList(altosFrequencyArray);
        Container container = this.getScrollablePane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)new JLabel("Frequencies"), gridBagConstraints);
        JScrollPane jScrollPane = new JScrollPane(this.frequencies);
        jScrollPane.setAlignmentX(0.0f);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        container.add((Component)jScrollPane, gridBagConstraints);
        this.add = new JButton("Add");
        this.add.setActionCommand("add");
        this.add.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)this.add, gridBagConstraints);
        this.edit = new JButton("Edit");
        this.edit.setActionCommand("edit");
        this.edit.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)this.edit, gridBagConstraints);
        this.remove = new JButton("Remove");
        this.remove.setActionCommand("remove");
        this.remove.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)this.remove, gridBagConstraints);
        this.ok = new JButton("OK");
        this.ok.setActionCommand("ok");
        this.ok.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)this.ok, gridBagConstraints);
        this.cancel = new JButton("Cancel");
        this.cancel.setActionCommand("cancel");
        this.cancel.addActionListener(this);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        container.add((Component)this.cancel, gridBagConstraints);
        this.pack();
        this.setLocationRelativeTo(this.frame);
    }

    public static void show(Component component) {
        Frame frame = JOptionPane.getFrameForComponent(component);
        AltosConfigFreqUI altosConfigFreqUI = new AltosConfigFreqUI(frame, AltosUIPreferences.common_frequencies());
        altosConfigFreqUI.setVisible(true);
    }

    class FrequencyList
    extends JList<AltosFrequency> {
        DefaultListModel<AltosFrequency> list_model = new DefaultListModel();

        public void add(AltosFrequency altosFrequency) {
            int n;
            for (n = 0; n < this.list_model.size(); ++n) {
                AltosFrequency altosFrequency2 = this.list_model.get(n);
                if (altosFrequency.frequency == altosFrequency2.frequency) {
                    return;
                }
                if (altosFrequency.frequency < altosFrequency2.frequency) break;
            }
            this.list_model.insertElementAt(altosFrequency, n);
        }

        public void remove(AltosFrequency altosFrequency) {
            this.list_model.removeElement(altosFrequency);
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
            int n3;
            if (n == 1 && n2 < 0 && (n3 = this.getFirstVisibleIndex()) != -1) {
                Rectangle rectangle2 = this.getCellBounds(n3, n3);
                if (rectangle2.y == rectangle.y && n3 != 0) {
                    Point point = rectangle2.getLocation();
                    --point.y;
                    int n4 = this.locationToIndex(point);
                    Rectangle rectangle3 = this.getCellBounds(n4, n4);
                    if (rectangle3 == null || rectangle3.y >= rectangle2.y) {
                        return 0;
                    }
                    return rectangle3.height;
                }
            }
            return super.getScrollableUnitIncrement(rectangle, n, n2);
        }

        public AltosFrequency selected() {
            AltosFrequency altosFrequency = (AltosFrequency)this.getSelectedValue();
            return altosFrequency;
        }

        public AltosFrequency[] frequencies() {
            AltosFrequency[] altosFrequencyArray = new AltosFrequency[this.list_model.size()];
            for (int i = 0; i < this.list_model.size(); ++i) {
                altosFrequencyArray[i] = this.list_model.get(i);
            }
            return altosFrequencyArray;
        }

        public FrequencyList(AltosFrequency[] altosFrequencyArray) {
            this.setModel(this.list_model);
            this.setSelectionMode(2);
            this.setLayoutOrientation(2);
            for (int i = 0; i < altosFrequencyArray.length; ++i) {
                this.add(altosFrequencyArray[i]);
            }
            this.setVisibleRowCount(altosFrequencyArray.length);
        }
    }
}

