/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosUnits;

public class AltosPressure
extends AltosUnits {
    @Override
    public double value(double d, boolean bl) {
        if (bl) {
            return AltosConvert.pa_to_psi(d);
        }
        return d / 1000.0;
    }

    @Override
    public double inverse(double d, boolean bl) {
        if (bl) {
            return AltosConvert.psi_to_pa(d);
        }
        return d * 1000.0;
    }

    @Override
    public String show_units(boolean bl) {
        if (bl) {
            return "psi";
        }
        return "kPa";
    }

    @Override
    public String say_units(boolean bl) {
        if (bl) {
            return "p s i";
        }
        return "kilopascals";
    }

    @Override
    public int show_fraction(int n, boolean bl) {
        return n / 5;
    }
}

