/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.IOException;
import java.text.ParseException;
import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosFlightReader;
import org.altusmetrum.altoslib_14.AltosIdleFetch;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosPreferences;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altoslib_14.AltosUnknownProduct;

public class AltosIdleReader
extends AltosFlightReader {
    AltosLink link;
    boolean remote;
    AltosCalData cal_data = null;
    AltosState state = null;
    AltosIdleFetch fetch;
    long next_millis;
    static final long report_interval = 5000L;
    static final long minimum_delay = 1000L;

    private void start_link() throws InterruptedException, TimeoutException {
        if (this.remote) {
            this.link.start_remote();
        } else {
            this.link.flush_input();
        }
    }

    private boolean stop_link() throws InterruptedException, TimeoutException {
        if (this.remote) {
            this.link.stop_remote();
        }
        return this.link.reply_abort;
    }

    @Override
    public AltosCalData cal_data() {
        if (this.cal_data == null) {
            try {
                this.cal_data = new AltosCalData(this.link.config_data());
            }
            catch (InterruptedException interruptedException) {
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            if (this.cal_data == null) {
                this.cal_data = new AltosCalData();
            }
        }
        return this.cal_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AltosState read() throws InterruptedException, ParseException, AltosCRCException, IOException {
        long l;
        boolean bl = false;
        boolean bl2 = false;
        long l2 = this.next_millis - System.currentTimeMillis();
        if (l2 > 0L) {
            Thread.sleep(l2);
        }
        this.next_millis = System.currentTimeMillis() + 5000L;
        try {
            try {
                this.start_link();
                if (this.state == null) {
                    this.state = new AltosState(this.cal_data());
                }
                this.fetch.provide_data(this.state);
                if (!this.link.has_error && !this.link.reply_abort) {
                    bl = true;
                }
            }
            catch (TimeoutException timeoutException) {
            }
            catch (AltosUnknownProduct altosUnknownProduct) {
                bl = true;
            }
        }
        finally {
            try {
                bl2 = this.stop_link();
            }
            catch (TimeoutException timeoutException) {
                bl2 = true;
            }
            if (bl && this.remote) {
                try {
                    this.state.set_rssi(this.link.rssi(), 0);
                }
                catch (TimeoutException timeoutException) {
                    this.state.set_rssi(0, 0);
                }
            }
        }
        if (this.next_millis - (l = System.currentTimeMillis()) < 1000L) {
            this.next_millis = l + 1000L;
        }
        return this.state;
    }

    @Override
    public void close(boolean bl) {
        try {
            this.link.close();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void set_frequency(double d) throws InterruptedException, TimeoutException {
        this.link.set_radio_frequency(d);
    }

    @Override
    public void save_frequency() {
        AltosPreferences.set_frequency(this.link.serial, this.link.frequency);
    }

    public void set_callsign(String string) throws InterruptedException, TimeoutException {
        this.link.set_callsign(string);
    }

    public AltosIdleReader(AltosLink altosLink, boolean bl) throws IOException, InterruptedException, TimeoutException {
        this.link = altosLink;
        this.remote = bl;
        this.next_millis = System.currentTimeMillis();
        this.fetch = new AltosIdleFetch(altosLink);
    }
}

