/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosGPS;

public class AltosGreatCircle
implements Cloneable {
    public double distance;
    public double bearing;
    public double range;
    public double elevation;
    public static final double rad = Math.PI / 180;
    public static final double earth_radius = 6371200.0;
    public static final int BEARING_LONG = 0;
    public static final int BEARING_SHORT = 1;
    public static final int BEARING_VOICE = 2;

    double sqr(double d) {
        return d * d;
    }

    public String bearing_words(int n) {
        return AltosConvert.bearing_to_words(n, this.bearing);
    }

    public AltosGreatCircle(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8 = Math.PI / 180 * d;
        double d9 = Math.PI / 180 * -d2;
        double d10 = Math.PI / 180 * d4;
        double d11 = Math.PI / 180 * -d5;
        double d12 = d11 - d9;
        double d13 = Math.sqrt(this.sqr(Math.cos(d10) * Math.sin(d12)) + this.sqr(Math.cos(d8) * Math.sin(d10) - Math.sin(d8) * Math.cos(d10) * Math.cos(d12)));
        double d14 = Math.sin(d8) * Math.sin(d10) + Math.cos(d8) * Math.cos(d10) * Math.cos(d12);
        double d15 = Math.atan2(d13, d14);
        if (Math.cos(d8) < 1.0E-20) {
            d7 = d8 > 0.0 ? Math.PI : -Math.PI;
        } else {
            d7 = d15 < 1.0E-10 ? 0.0 : Math.acos((Math.sin(d10) - Math.sin(d8) * Math.cos(d15)) / (Math.sin(d15) * Math.cos(d8)));
            if (Math.sin(d11 - d9) > 0.0) {
                d7 = Math.PI * 2 - d7;
            }
        }
        this.distance = d15 * 6371200.0;
        this.bearing = Double.isNaN(d7) || Double.isInfinite(d7) ? 0.0 : d7 * 180.0 / Math.PI;
        double d16 = d6 - d3;
        this.range = Math.sqrt(this.distance * this.distance + d16 * d16);
        this.elevation = Math.atan2(d16, this.distance) * 180.0 / Math.PI;
    }

    public AltosGreatCircle clone() {
        AltosGreatCircle altosGreatCircle = new AltosGreatCircle();
        altosGreatCircle.distance = this.distance;
        altosGreatCircle.bearing = this.bearing;
        altosGreatCircle.range = this.range;
        altosGreatCircle.elevation = this.elevation;
        return altosGreatCircle;
    }

    public AltosGreatCircle(double d, double d2, double d3, double d4) {
        this(d, d2, 0.0, d3, d4, 0.0);
    }

    public AltosGreatCircle(AltosGPS altosGPS, AltosGPS altosGPS2) {
        this(altosGPS.lat, altosGPS.lon, altosGPS.alt, altosGPS2.lat, altosGPS2.lon, altosGPS2.alt);
    }

    public AltosGreatCircle() {
        this.distance = 0.0;
        this.bearing = 0.0;
        this.range = 0.0;
        this.elevation = 0.0;
    }
}

