/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.FileWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosEeprom;
import org.altusmetrum.altoslib_14.AltosEepromChunk;
import org.altusmetrum.altoslib_14.AltosEepromList;
import org.altusmetrum.altoslib_14.AltosEepromLog;
import org.altusmetrum.altoslib_14.AltosEepromMonitor;
import org.altusmetrum.altoslib_14.AltosEepromNameData;
import org.altusmetrum.altoslib_14.AltosEepromRecord;
import org.altusmetrum.altoslib_14.AltosEepromRecordSet;
import org.altusmetrum.altoslib_14.AltosFile;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosState;

public class AltosEepromDownload
implements Runnable {
    AltosLink link;
    boolean remote;
    Thread eeprom_thread;
    AltosEepromMonitor monitor;
    AltosEepromList flights;
    String parse_errors;
    boolean done;
    int prev_state;
    int state_block;

    private boolean has_gps_date(AltosState altosState) {
        if (altosState == null) {
            return false;
        }
        AltosGPS altosGPS = altosState.gps;
        return altosGPS != null && altosGPS.year != Integer.MAX_VALUE && altosGPS.month != Integer.MAX_VALUE && altosGPS.day != Integer.MAX_VALUE;
    }

    private AltosFile MakeFile(int n, int n2, AltosEepromNameData altosEepromNameData) throws IOException {
        AltosFile altosFile;
        while (true) {
            if (altosEepromNameData.gps != null) {
                AltosGPS altosGPS = altosEepromNameData.gps;
                altosFile = new AltosFile(altosGPS.year, altosGPS.month, altosGPS.day, n, n2, "eeprom");
            } else {
                altosFile = new AltosFile(n, n2, "eeprom");
            }
            if (!altosEepromNameData.avoid_duplicate_files || !altosFile.exists()) break;
            ++n2;
        }
        return altosFile;
    }

    void LogError(String string) {
        if (this.parse_errors != null) {
            this.parse_errors.concat(string.concat("\n"));
        } else {
            this.parse_errors = string;
        }
    }

    int FindLastLog(AltosEepromLog altosEepromLog, BlockCache blockCache) throws TimeoutException, InterruptedException {
        int n = altosEepromLog.start_block;
        int n2 = altosEepromLog.end_block - 1;
        while (n <= n2) {
            int n3 = (n2 + n) / 2;
            if (!blockCache.get(n3, true).erased()) {
                n = n3 + 1;
                continue;
            }
            n2 = n3 - 1;
        }
        return n;
    }

    void CaptureLog(AltosEepromLog altosEepromLog) throws IOException, InterruptedException, TimeoutException, ParseException {
        Object object;
        boolean bl = false;
        int n = this.flights.config_data.log_format;
        BlockCache blockCache = new BlockCache(altosEepromLog);
        this.done = false;
        if (this.flights.config_data.serial < 0) {
            throw new IOException("no serial number found");
        }
        this.monitor.set_serial(altosEepromLog.serial);
        this.monitor.set_flight(altosEepromLog.flight);
        int n2 = altosEepromLog.start_block;
        int n3 = this.FindLastLog(altosEepromLog, blockCache);
        this.monitor.set_max(n3 - n2 - 1);
        ArrayList<Byte> arrayList = new ArrayList<Byte>();
        for (int i = n2; i < n3; ++i) {
            this.monitor.set_block(i - n2);
            object = blockCache.get(i, false);
            for (int j = 0; j < ((AltosEepromChunk)object).data.length; ++j) {
                arrayList.add((byte)((AltosEepromChunk)object).data[j]);
            }
        }
        object = new AltosEeprom(this.flights.config_data, arrayList);
        AltosEepromRecordSet altosEepromRecordSet = new AltosEepromRecordSet((AltosEeprom)object);
        AltosEepromNameData altosEepromNameData = new AltosEepromNameData(altosEepromRecordSet.cal_data());
        for (AltosEepromRecord altosEepromRecord : altosEepromRecordSet.ordered) {
            altosEepromRecord.provide_data(altosEepromNameData, altosEepromRecordSet.cal_data());
            if (!altosEepromNameData.done()) continue;
            break;
        }
        AltosFile altosFile = this.MakeFile(this.flights.config_data.serial, altosEepromLog.flight, altosEepromNameData);
        altosEepromLog.set_file(altosFile);
        boolean bl2 = true;
        if (altosFile.exists()) {
            bl2 = this.monitor.check_overwrite(altosFile);
        }
        if (bl2) {
            FileWriter fileWriter = new FileWriter(altosFile);
            ((AltosEeprom)object).write(fileWriter);
            fileWriter.close();
        }
        if (((AltosEeprom)object).errors != 0) {
            throw new ParseException(String.format("%d CRC Errors", ((AltosEeprom)object).errors), 0);
        }
    }

    static String label(int n) {
        if (n < 0) {
            return "Corrupt";
        }
        return "Flight";
    }

    static int flight(int n) {
        if (n < 0) {
            return -n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl = false;
        try {
            if (this.remote) {
                this.link.start_remote();
            }
            for (AltosEepromLog altosEepromLog : this.flights) {
                this.parse_errors = null;
                if (altosEepromLog.download_selected) {
                    this.monitor.reset();
                    try {
                        this.CaptureLog(altosEepromLog);
                    }
                    catch (ParseException parseException) {
                        this.LogError(parseException.getMessage());
                    }
                }
                bl = true;
                if (this.parse_errors == null) continue;
                this.monitor.show_message(String.format("%s %d download error. Valid log data saved\n%s", AltosEepromDownload.label(altosEepromLog.flight), AltosEepromDownload.flight(altosEepromLog.flight), this.parse_errors), this.link.name, 1);
            }
        }
        catch (IOException iOException) {
            this.monitor.show_message(iOException.getLocalizedMessage(), this.link.name, 2);
        }
        catch (InterruptedException interruptedException) {
            this.monitor.show_message(String.format("Connection to \"%s\" interrupted", this.link.name), "Connection Interrupted", 2);
        }
        catch (TimeoutException timeoutException) {
            this.monitor.show_message(String.format("Connection to \"%s\" failed", this.link.name), "Connection Failed", 2);
        }
        finally {
            if (this.remote) {
                try {
                    this.link.stop_remote();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.link.flush_output();
        }
        this.monitor.done(bl);
    }

    public void start() {
        this.eeprom_thread = new Thread(this);
        this.monitor.set_thread(this.eeprom_thread);
        this.eeprom_thread.start();
    }

    public AltosEepromDownload(AltosEepromMonitor altosEepromMonitor, AltosLink altosLink, boolean bl, AltosEepromList altosEepromList) {
        this.monitor = altosEepromMonitor;
        this.link = altosLink;
        this.remote = bl;
        this.flights = altosEepromList;
        this.monitor.start();
    }

    class BlockCache
    extends Hashtable<Integer, AltosEepromChunk> {
        AltosEepromLog log;

        AltosEepromChunk get(int n, boolean bl) throws TimeoutException, InterruptedException {
            if (this.contains(n)) {
                return (AltosEepromChunk)super.get(n);
            }
            AltosEepromChunk altosEepromChunk = new AltosEepromChunk(AltosEepromDownload.this.link, n, n == this.log.start_block);
            if (bl) {
                this.put(n, altosEepromChunk);
            }
            return altosEepromChunk;
        }

        public BlockCache(AltosEepromLog altosEepromLog) {
            this.log = altosEepromLog;
        }
    }
}

