/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altosuilib_14;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.altusmetrum.altoslib_14.AltosParse;
import org.altusmetrum.altosuilib_14.AltosUIFrame;
import org.altusmetrum.altosuilib_14.AltosUIMapPreload;

class AltosUIMapPos
extends Box
implements ActionListener {
    AltosUIMapPreload preload;
    AltosUIFrame owner;
    JLabel label;
    JComboBox hemi;
    JTextField deg;
    JLabel deg_label;
    JTextField min;
    JLabel min_label;

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.preload.center_map();
    }

    public void set_value(double d) {
        int n = 0;
        if (d < 0.0) {
            n = 1;
            d = -d;
        }
        double d2 = Math.floor(d);
        this.deg.setText(String.format("%3.0f", d2));
        double d3 = (d - d2) * 60.0;
        this.min.setText(String.format("%7.4f", d3));
        this.hemi.setSelectedIndex(n);
    }

    public double get_value() throws ParseException {
        double d;
        double d2;
        int n = this.hemi.getSelectedIndex();
        String string = this.deg.getText();
        String string2 = this.min.getText();
        try {
            d2 = AltosParse.parse_double_locale((String)string);
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(this.owner, String.format("Invalid degrees \"%s\"", string), "Invalid number", 0);
            throw parseException;
        }
        try {
            d = string2.equals("") ? 0.0 : AltosParse.parse_double_locale((String)string2);
        }
        catch (ParseException parseException) {
            JOptionPane.showMessageDialog(this.owner, String.format("Invalid minutes \"%s\"", string2), "Invalid number", 0);
            throw parseException;
        }
        double d3 = d2 + d / 60.0;
        if (n == 1) {
            d3 = -d3;
        }
        return d3;
    }

    public AltosUIMapPos(AltosUIFrame altosUIFrame, AltosUIMapPreload altosUIMapPreload, String string, String[] stringArray, double d) {
        super(0);
        this.owner = altosUIFrame;
        this.preload = altosUIMapPreload;
        this.label = new JLabel(string);
        this.hemi = new JComboBox<String>(stringArray);
        this.hemi.setEditable(false);
        this.deg = new JTextField(5);
        this.deg.addActionListener(this);
        this.deg.setMinimumSize(this.deg.getPreferredSize());
        this.deg.setHorizontalAlignment(4);
        this.deg_label = new JLabel("\u00b0");
        this.min = new JTextField(9);
        this.min.addActionListener(this);
        this.min.setMinimumSize(this.min.getPreferredSize());
        this.min_label = new JLabel("'");
        this.set_value(d);
        this.add(this.label);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.hemi);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.deg);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.deg_label);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.min);
        this.add(Box.createRigidArea(new Dimension(5, 0)));
        this.add(this.min_label);
    }
}

