/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.telegps;

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altoslib_14.AltosUnits;
import org.altusmetrum.altosuilib_14.AltosUIFlightTab;
import org.altusmetrum.altosuilib_14.AltosUIIndicator;
import org.altusmetrum.altosuilib_14.AltosUILib;
import org.altusmetrum.altosuilib_14.AltosUIUnitsIndicator;

public class TeleGPSInfo
extends AltosUIFlightTab {
    JLabel cur;
    JLabel max;

    @Override
    public void font_size_changed(int n) {
        this.cur.setFont(AltosUILib.label_font);
        this.max.setFont(AltosUILib.label_font);
        super.font_size_changed(n);
    }

    public void labels(Container container, int n) {
        GridBagLayout gridBagLayout = (GridBagLayout)container.getLayout();
        this.cur = new JLabel("Current");
        this.cur.setFont(AltosUILib.label_font);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints(this.cur, gridBagConstraints);
        this.add(this.cur);
        this.max = new JLabel("Maximum");
        this.max.setFont(AltosUILib.label_font);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = n;
        gridBagLayout.setConstraints(this.max, gridBagConstraints);
        this.add(this.max);
    }

    @Override
    public String getName() {
        return "Location";
    }

    public TeleGPSInfo() {
        int n = 0;
        this.labels(this, n++);
        this.add(new Altitude(this, n++));
        this.add(new GroundSpeed(this, n++));
        this.add(new AscentRate(this, n++));
        this.add(new Course(this, n++));
        this.add(new Lat(this, n++));
        this.add(new Lon(this, n++));
        this.add(new GPSLocked(this, n++));
    }

    class GPSLocked
    extends AltosUIIndicator {
        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            if (altosState == null || altosState.gps == null) {
                this.hide();
            } else {
                int n = altosState.gps.nsat;
                int n2 = altosState.gps.cc_gps_sat != null ? altosState.gps.cc_gps_sat.length : 0;
                this.show("%4d in solution", n, "%4d in view", n2);
                this.set_lights(altosState.gps.locked && n >= 4);
            }
        }

        public GPSLocked(Container container, int n) {
            super(container, n, "GPS Locked", 2, true, 1);
        }
    }

    class Lon
    extends AltosUIIndicator {
        String pos(double d, String string, String string2) {
            String string3 = string;
            if (d < 0.0) {
                string3 = string2;
                d = -d;
            }
            int n = (int)Math.floor(d);
            double d2 = (d - Math.floor(d)) * 60.0;
            return String.format("%s %4d\u00b0 %9.6f", string3, n, d2);
        }

        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            if (altosState.gps != null && altosState.gps.connected && altosState.gps.lon != 2.147483647E9) {
                this.show(this.pos(altosState.gps.lon, "E", "W"));
            } else {
                this.show("Missing");
            }
        }

        public Lon(Container container, int n) {
            super(container, n, "Longitude", 1, false, 2);
        }
    }

    class Lat
    extends AltosUIIndicator {
        String pos(double d, String string, String string2) {
            String string3 = string;
            if (d < 0.0) {
                string3 = string2;
                d = -d;
            }
            int n = (int)Math.floor(d);
            double d2 = (d - Math.floor(d)) * 60.0;
            return String.format("%s %4d\u00b0 %9.6f", string3, n, d2);
        }

        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            if (altosState.gps != null && altosState.gps.connected && altosState.gps.lat != 2.147483647E9) {
                this.show(this.pos(altosState.gps.lat, "N", "S"));
            } else {
                this.show("Missing");
            }
        }

        public Lat(Container container, int n) {
            super(container, n, "Latitude", 1, false, 2);
        }
    }

    class Course
    extends AltosUIIndicator {
        @Override
        public void show(AltosState altosState, AltosListenerState altosListenerState) {
            double d = altosState.gps_course();
            if (d == 2.147483647E9) {
                this.show("Missing", "Missing");
            } else {
                this.show(String.format("%3.0f\u00b0", d), AltosConvert.bearing_to_words(0, d));
            }
        }

        public Course(Container container, int n) {
            super(container, n, "Course", 2, false, 1);
        }
    }

    class GroundSpeed
    extends ValueHold {
        @Override
        public double value(AltosState altosState, int n) {
            if (n == 0) {
                return altosState.gps_ground_speed();
            }
            return altosState.max_gps_ground_speed();
        }

        public GroundSpeed(Container container, int n) {
            super(container, n, (AltosUnits)AltosConvert.speed, "Ground Speed");
        }
    }

    class AscentRate
    extends ValueHold {
        @Override
        public double value(AltosState altosState, int n) {
            if (n == 0) {
                return altosState.gps_ascent_rate();
            }
            return altosState.max_gps_ascent_rate();
        }

        public AscentRate(Container container, int n) {
            super(container, n, (AltosUnits)AltosConvert.speed, "Ascent Rate");
        }
    }

    class Altitude
    extends ValueHold {
        @Override
        public double value(AltosState altosState, int n) {
            if (n == 0) {
                return altosState.altitude();
            }
            return altosState.max_altitude();
        }

        public Altitude(Container container, int n) {
            super(container, n, (AltosUnits)AltosConvert.height, "Altitude");
        }
    }

    abstract class ValueHold
    extends DualValue {
        @Override
        public void reset() {
            super.reset();
        }

        public ValueHold(Container container, int n, AltosUnits altosUnits, String string) {
            super(container, n, altosUnits, string);
        }
    }

    abstract class DualValue
    extends AltosUIUnitsIndicator {
        public DualValue(Container container, int n, AltosUnits altosUnits, String string) {
            super(container, n, altosUnits, string, 2, false, 1);
        }
    }

    abstract class Value
    extends AltosUIUnitsIndicator {
        @Override
        public abstract void show(AltosState var1, AltosListenerState var2);

        public Value(Container container, int n, AltosUnits altosUnits, String string) {
            super(container, n, altosUnits, string, 1, false, 2);
        }
    }
}

