/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.telegps;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JTabbedPane;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosFilterListener;
import org.altusmetrum.altoslib_14.AltosFlightSeries;
import org.altusmetrum.altoslib_14.AltosFlightStats;
import org.altusmetrum.altoslib_14.AltosFontListener;
import org.altusmetrum.altoslib_14.AltosGPS;
import org.altusmetrum.altoslib_14.AltosGPSTimeValue;
import org.altusmetrum.altoslib_14.AltosPreferences;
import org.altusmetrum.altoslib_14.AltosRecordSet;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altoslib_14.AltosUnitsListener;
import org.altusmetrum.altosuilib_14.AltosFlightStatsTable;
import org.altusmetrum.altosuilib_14.AltosGraph;
import org.altusmetrum.altosuilib_14.AltosUIEnable;
import org.altusmetrum.altosuilib_14.AltosUIFlightSeries;
import org.altusmetrum.altosuilib_14.AltosUIFrame;
import org.altusmetrum.altosuilib_14.AltosUIMap;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;
import org.altusmetrum.telegps.TeleGPS;

public class TeleGPSGraphUI
extends AltosUIFrame
implements AltosFontListener,
AltosUnitsListener,
AltosFilterListener {
    JTabbedPane pane;
    AltosGraph graph;
    AltosUIEnable enable;
    AltosUIMap map;
    AltosState state;
    AltosFlightStats stats;
    AltosFlightStatsTable statsTable;
    AltosGPS gps;
    boolean has_gps;
    AltosUIFlightSeries flight_series;

    void fill_map(AltosFlightSeries altosFlightSeries) {
        boolean bl = false;
        AltosGPSTimeValue altosGPSTimeValue = null;
        double d = altosFlightSeries.cal_data().gps_pad_altitude;
        if (altosFlightSeries.gps_series != null) {
            Iterator<AltosGPSTimeValue> iterator = altosFlightSeries.gps_series.iterator();
            while (iterator.hasNext()) {
                AltosGPSTimeValue altosGPSTimeValue2;
                altosGPSTimeValue = altosGPSTimeValue2 = iterator.next();
                AltosGPS altosGPS = altosGPSTimeValue2.gps;
                if (altosGPS == null || !altosGPS.locked || altosGPS.nsat < 4) continue;
                if (this.map == null) {
                    this.map = new AltosUIMap();
                }
                double d2 = altosGPS.alt - d;
                int n = (int)altosFlightSeries.value_before("State", altosGPSTimeValue2.time);
                this.map.show(altosGPS, altosGPSTimeValue2.time, n, d2);
                this.gps = altosGPS;
                this.has_gps = true;
            }
        }
        if (altosGPSTimeValue != null) {
            int n = (int)altosFlightSeries.value_after("State", altosGPSTimeValue.time);
            double d3 = this.gps.alt - d;
            if (n == 8) {
                this.map.show(altosGPSTimeValue.gps, altosGPSTimeValue.time, n, d3);
            }
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
        TeleGPS.subtract_window();
    }

    @Override
    public void font_size_changed(int n) {
        if (this.map != null) {
            this.map.font_size_changed(n);
        }
        if (this.statsTable != null) {
            this.statsTable.font_size_changed(n);
        }
    }

    @Override
    public void units_changed(boolean bl) {
        if (this.map != null) {
            this.map.units_changed(bl);
        }
        if (this.enable != null) {
            this.enable.units_changed(bl);
        }
    }

    @Override
    public void filter_changed(double d, double d2) {
        this.flight_series.set_filter(d, d2);
        this.graph.filter_changed();
        this.stats = new AltosFlightStats(this.flight_series);
        this.statsTable.filter_changed(this.stats);
    }

    @Override
    public double speed_filter() {
        return this.flight_series.speed_filter_width;
    }

    @Override
    public double accel_filter() {
        return this.flight_series.accel_filter_width;
    }

    TeleGPSGraphUI(AltosRecordSet altosRecordSet, File file) throws InterruptedException, IOException {
        super(file.getName());
        AltosCalData altosCalData = altosRecordSet.cal_data();
        this.pane = new JTabbedPane();
        this.flight_series = new AltosUIFlightSeries(altosCalData);
        this.enable = new AltosUIEnable(this);
        altosRecordSet.capture_series(this.flight_series);
        this.flight_series.finish();
        this.stats = new AltosFlightStats(this.flight_series);
        this.graph = new AltosGraph(this.enable, this.stats, this.flight_series);
        this.statsTable = new AltosFlightStatsTable(this.stats);
        this.map = new AltosUIMap();
        this.pane.add("Graph", (Component)this.graph.panel);
        this.pane.add("Configure Graph", this.enable);
        this.pane.add("Statistics", this.statsTable);
        this.fill_map(this.flight_series);
        this.pane.add("Map", this.map);
        this.setContentPane(this.pane);
        AltosUIPreferences.register_font_listener(this);
        AltosPreferences.register_units_listener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TeleGPSGraphUI.this.close();
            }
        });
        this.pack();
        this.setDefaultCloseOperation(0);
        TeleGPS.add_window();
        this.setVisible(true);
        if (this.state != null) {
            this.map.centre(this.state);
        }
    }
}

