/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.telegps;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeoutException;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosEepromList;
import org.altusmetrum.altoslib_14.AltosEepromLog;
import org.altusmetrum.altoslib_14.AltosFlightDisplay;
import org.altusmetrum.altoslib_14.AltosFlightReader;
import org.altusmetrum.altoslib_14.AltosFlightSeries;
import org.altusmetrum.altoslib_14.AltosFontListener;
import org.altusmetrum.altoslib_14.AltosIdleReader;
import org.altusmetrum.altoslib_14.AltosLib;
import org.altusmetrum.altoslib_14.AltosListenerState;
import org.altusmetrum.altoslib_14.AltosPreferences;
import org.altusmetrum.altoslib_14.AltosRecordSet;
import org.altusmetrum.altoslib_14.AltosReplayReader;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altoslib_14.AltosTelemetryReader;
import org.altusmetrum.altoslib_14.AltosUnitsListener;
import org.altusmetrum.altosuilib_14.AltosCSVUI;
import org.altusmetrum.altosuilib_14.AltosDataChooser;
import org.altusmetrum.altosuilib_14.AltosDevice;
import org.altusmetrum.altosuilib_14.AltosDeviceUIDialog;
import org.altusmetrum.altosuilib_14.AltosEepromGrapher;
import org.altusmetrum.altosuilib_14.AltosEepromManage;
import org.altusmetrum.altosuilib_14.AltosFlashUI;
import org.altusmetrum.altosuilib_14.AltosInfoTable;
import org.altusmetrum.altosuilib_14.AltosScanUI;
import org.altusmetrum.altosuilib_14.AltosSerial;
import org.altusmetrum.altosuilib_14.AltosSerialInUseException;
import org.altusmetrum.altosuilib_14.AltosUIFrame;
import org.altusmetrum.altosuilib_14.AltosUIFreqList;
import org.altusmetrum.altosuilib_14.AltosUILib;
import org.altusmetrum.altosuilib_14.AltosUIMap;
import org.altusmetrum.altosuilib_14.AltosUIMapPreload;
import org.altusmetrum.altosuilib_14.AltosUIPreferences;
import org.altusmetrum.altosuilib_14.AltosUIRateList;
import org.altusmetrum.altosuilib_14.AltosUSBDevice;
import org.altusmetrum.altosuilib_14.AltosVoice;
import org.altusmetrum.telegps.TeleGPSConfig;
import org.altusmetrum.telegps.TeleGPSDisplayThread;
import org.altusmetrum.telegps.TeleGPSGraphUI;
import org.altusmetrum.telegps.TeleGPSInfo;
import org.altusmetrum.telegps.TeleGPSPreferences;
import org.altusmetrum.telegps.TeleGPSState;
import org.altusmetrum.telegps.TeleGPSStatus;
import org.altusmetrum.telegps.TeleGPSStatusUpdate;

public class TeleGPS
extends AltosUIFrame
implements AltosFlightDisplay,
AltosFontListener,
AltosUnitsListener,
ActionListener,
AltosEepromGrapher {
    static String[] telegps_icon_names = new String[]{"/altusmetrum-telegps-16.png", "/altusmetrum-telegps-32.png", "/altusmetrum-telegps-48.png", "/altusmetrum-telegps-64.png", "/altusmetrum-telegps-128.png", "/altusmetrum-telegps-256.png"};
    static AltosVoice voice;
    AltosFlightReader reader;
    TeleGPSDisplayThread thread;
    boolean idle_mode;
    JMenuBar menu_bar;
    JMenu file_menu;
    JMenu monitor_menu;
    JMenu device_menu;
    AltosUIFreqList frequencies;
    ActionListener frequency_listener;
    AltosUIRateList rates;
    ActionListener rate_listener;
    Container bag;
    TeleGPSStatus telegps_status;
    TeleGPSStatusUpdate status_update;
    JTabbedPane pane;
    AltosUIMap map;
    TeleGPSInfo gps_info;
    TeleGPSState gps_state;
    AltosInfoTable info_table;
    LinkedList<AltosFlightDisplay> displays;
    static final String new_command = "new";
    static final String graph_command = "graph";
    static final String export_command = "export";
    static final String load_maps_command = "loadmaps";
    static final String preferences_command = "preferences";
    static final String close_command = "close";
    static final String exit_command = "exit";
    static final String[][] file_menu_entries;
    static final String connect_command = "connect";
    static final String disconnect_command = "disconnect";
    static final String scan_command = "scan";
    static final String[][] monitor_menu_entries;
    static final String download_command = "download";
    static final String configure_command = "configure";
    static final String flash_command = "flash";
    static final String[][] device_menu_entries;
    static int number_of_windows;
    static final int process_none = 0;
    static final int process_csv = 1;
    static final int process_kml = 2;
    static final int process_graph = 3;
    static final int process_replay = 4;
    static final int process_summary = 5;
    static final int process_cat = 6;

    static AltosVoice voice() {
        if (voice == null) {
            voice = new AltosVoice();
        }
        return voice;
    }

    void stop_display() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.thread = null;
    }

    @Override
    public void reset() {
        for (AltosFlightDisplay altosFlightDisplay : this.displays) {
            altosFlightDisplay.reset();
        }
    }

    @Override
    public void font_size_changed(int n) {
        for (AltosFlightDisplay altosFlightDisplay : this.displays) {
            altosFlightDisplay.font_size_changed(n);
        }
    }

    @Override
    public void units_changed(boolean bl) {
        for (AltosFlightDisplay altosFlightDisplay : this.displays) {
            altosFlightDisplay.units_changed(bl);
        }
    }

    @Override
    public void show(AltosState altosState, AltosListenerState altosListenerState) {
        try {
            this.status_update.saved_state = altosState;
            this.status_update.saved_listener_state = altosListenerState;
            if (altosState == null) {
                altosState = new AltosState(new AltosCalData());
            }
            int n = 0;
            for (AltosFlightDisplay altosFlightDisplay : this.displays) {
                altosFlightDisplay.show(altosState, altosListenerState);
                ++n;
            }
        }
        catch (Exception exception) {
            System.out.printf("Exception %s\n", exception.toString());
            for (StackTraceElement stackTraceElement : exception.getStackTrace()) {
                System.out.printf("%s\n", stackTraceElement.toString());
            }
        }
    }

    void new_window() {
        new TeleGPS();
    }

    void preferences() {
        new TeleGPSPreferences(this, TeleGPS.voice());
    }

    void load_maps() {
        new AltosUIMapPreload(this);
    }

    void disconnect() {
        this.setTitle("TeleGPS");
        this.stop_display();
        this.telegps_status.stop();
        this.telegps_status.disable_receive();
        this.disable_frequency_menu();
        this.disable_rate_menu();
    }

    void connect_flight(AltosDevice altosDevice) {
        try {
            AltosTelemetryReader altosTelemetryReader = new AltosTelemetryReader(new AltosSerial(altosDevice));
            this.set_reader(altosTelemetryReader, altosDevice, false);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, fileNotFoundException.getMessage(), String.format("Cannot open %s", altosDevice.toShortString()), 0);
        }
        catch (AltosSerialInUseException altosSerialInUseException) {
            JOptionPane.showMessageDialog(this, String.format("Device \"%s\" already in use", altosDevice.toShortString()), "Device in use", 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, String.format("Unknown I/O error on %s", altosDevice.toShortString()), "Unknown I/O error", 0);
        }
        catch (TimeoutException timeoutException) {
            JOptionPane.showMessageDialog(this, String.format("Timeout on %s", altosDevice.toShortString()), "Timeout error", 0);
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(this, String.format("Interrupted %s", altosDevice.toShortString()), "Interrupted exception", 0);
        }
    }

    void connect_idle(AltosDevice altosDevice) {
        try {
            AltosIdleReader altosIdleReader = new AltosIdleReader(new AltosSerial(altosDevice), false);
            this.set_reader(altosIdleReader, altosDevice, true);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, fileNotFoundException.getMessage(), String.format("Cannot open %s", altosDevice.toShortString()), 0);
        }
        catch (AltosSerialInUseException altosSerialInUseException) {
            JOptionPane.showMessageDialog(this, String.format("Device \"%s\" already in use", altosDevice.toShortString()), "Device in use", 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, String.format("Unknown I/O error on %s", altosDevice.toShortString()), "Unknown I/O error", 0);
        }
        catch (TimeoutException timeoutException) {
            JOptionPane.showMessageDialog(this, String.format("Timeout on %s", altosDevice.toShortString()), "Timeout error", 0);
        }
        catch (InterruptedException interruptedException) {
            JOptionPane.showMessageDialog(this, String.format("Interrupted %s", altosDevice.toShortString()), "Interrupted exception", 0);
        }
    }

    void connect(AltosDevice altosDevice) {
        if (this.reader != null) {
            this.disconnect();
        }
        if (altosDevice.matchProduct(65537)) {
            this.connect_flight(altosDevice);
        } else {
            this.connect_idle(altosDevice);
        }
    }

    void connect() {
        AltosDevice altosDevice = AltosDeviceUIDialog.show(this, 65536);
        if (altosDevice == null) {
            return;
        }
        this.connect(altosDevice);
    }

    @Override
    public void scan_device_selected(AltosDevice altosDevice) {
        this.connect(altosDevice);
    }

    void scan() {
        new AltosScanUI(this, false);
    }

    void download() {
        new AltosEepromManage(this, this, 37);
    }

    void configure() {
        new TeleGPSConfig(this);
    }

    private static AltosFlightSeries make_series(AltosRecordSet altosRecordSet) {
        AltosFlightSeries altosFlightSeries = new AltosFlightSeries(altosRecordSet.cal_data());
        altosRecordSet.capture_series(altosFlightSeries);
        altosFlightSeries.finish();
        return altosFlightSeries;
    }

    void export() {
        AltosDataChooser altosDataChooser = new AltosDataChooser(this);
        AltosRecordSet altosRecordSet = altosDataChooser.runDialog();
        if (altosRecordSet == null) {
            return;
        }
        AltosFlightSeries altosFlightSeries = TeleGPS.make_series(altosRecordSet);
        new AltosCSVUI(this, altosFlightSeries, altosDataChooser.file());
    }

    void graph() {
        AltosDataChooser altosDataChooser = new AltosDataChooser(this);
        AltosRecordSet altosRecordSet = altosDataChooser.runDialog();
        TeleGPS.graph_file(this, altosRecordSet, altosDataChooser.file());
    }

    @Override
    public void graph_flights(AltosEepromList altosEepromList) {
        for (AltosEepromLog altosEepromLog : altosEepromList) {
            if (altosEepromLog.file == null) continue;
            AltosRecordSet altosRecordSet = TeleGPS.record_set(altosEepromLog.file);
            TeleGPS.graph_file(this, altosRecordSet, altosEepromLog.file);
        }
    }

    void flash() {
        AltosFlashUI.show(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (new_command.equals(actionEvent.getActionCommand())) {
            this.new_window();
            return;
        }
        if (preferences_command.equals(actionEvent.getActionCommand())) {
            this.preferences();
            return;
        }
        if (load_maps_command.equals(actionEvent.getActionCommand())) {
            this.load_maps();
            return;
        }
        if (close_command.equals(actionEvent.getActionCommand())) {
            this.close();
            return;
        }
        if (exit_command.equals(actionEvent.getActionCommand())) {
            System.exit(0);
        }
        if (connect_command.equals(actionEvent.getActionCommand())) {
            this.connect();
            return;
        }
        if (disconnect_command.equals(actionEvent.getActionCommand())) {
            this.disconnect();
            return;
        }
        if (scan_command.equals(actionEvent.getActionCommand())) {
            this.scan();
            return;
        }
        if (download_command.equals(actionEvent.getActionCommand())) {
            this.download();
            return;
        }
        if (configure_command.equals(actionEvent.getActionCommand())) {
            this.configure();
            return;
        }
        if (export_command.equals(actionEvent.getActionCommand())) {
            this.export();
            return;
        }
        if (graph_command.equals(actionEvent.getActionCommand())) {
            this.graph();
            return;
        }
        if (flash_command.equals(actionEvent.getActionCommand())) {
            this.flash();
            return;
        }
    }

    void enable_frequency_menu(int n, final AltosFlightReader altosFlightReader) {
        if (this.frequency_listener != null) {
            this.disable_frequency_menu();
        }
        this.frequency_listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                double d = TeleGPS.this.frequencies.frequency();
                try {
                    altosFlightReader.set_frequency(d);
                }
                catch (TimeoutException timeoutException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                altosFlightReader.save_frequency();
            }
        };
        this.frequencies.addActionListener(this.frequency_listener);
        this.frequencies.set_product("Monitor");
        this.frequencies.set_serial(n);
        this.frequencies.set_frequency(AltosUIPreferences.frequency(n));
        this.frequencies.setEnabled(true);
    }

    void disable_frequency_menu() {
        if (this.frequency_listener != null) {
            this.frequencies.removeActionListener(this.frequency_listener);
            this.frequencies.setEnabled(false);
            this.frequency_listener = null;
        }
    }

    void enable_rate_menu(int n, final AltosFlightReader altosFlightReader) {
        if (this.rate_listener != null) {
            this.disable_rate_menu();
        }
        this.rate_listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = TeleGPS.this.rates.rate();
                try {
                    altosFlightReader.set_telemetry_rate(n);
                }
                catch (TimeoutException timeoutException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                altosFlightReader.save_telemetry_rate();
            }
        };
        this.rates.addActionListener(this.rate_listener);
        this.rates.set_product("Monitor");
        this.rates.set_serial(n);
        this.rates.set_rate(AltosUIPreferences.telemetry_rate(n));
        this.rates.setEnabled(altosFlightReader.supports_telemetry_rate(2));
    }

    void disable_rate_menu() {
        if (this.rate_listener != null) {
            this.rates.removeActionListener(this.rate_listener);
            this.rates.setEnabled(false);
            this.rate_listener = null;
        }
    }

    public void set_reader(AltosFlightReader altosFlightReader, AltosDevice altosDevice, boolean bl) {
        this.idle_mode = bl;
        this.status_update = new TeleGPSStatusUpdate(this.telegps_status);
        this.telegps_status.start(this.status_update);
        this.setTitle(String.format("TeleGPS %s", altosFlightReader.name));
        this.thread = new TeleGPSDisplayThread(this, TeleGPS.voice(), this, altosFlightReader);
        this.thread.start();
        if (altosDevice != null) {
            if (bl) {
                this.disable_frequency_menu();
                this.disable_rate_menu();
            } else {
                this.enable_frequency_menu(altosDevice.getSerial(), altosFlightReader);
                this.enable_rate_menu(altosDevice.getSerial(), altosFlightReader);
            }
        }
    }

    public static void add_window() {
        ++number_of_windows;
    }

    public static void subtract_window() {
        if (--number_of_windows == 0) {
            System.exit(0);
        }
    }

    private void close() {
        this.disconnect();
        AltosUIPreferences.unregister_font_listener(this);
        AltosPreferences.unregister_units_listener(this);
        this.setVisible(false);
        this.dispose();
        TeleGPS.subtract_window();
    }

    private void add_menu(JMenu jMenu, String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(string2);
    }

    private JMenu make_menu(String string, String[][] stringArray) {
        JMenu jMenu = new JMenu(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (MAC_OS_X && (stringArray[i][1].equals(exit_command) || stringArray[i][1].equals(preferences_command))) continue;
            this.add_menu(jMenu, stringArray[i][0], stringArray[i][1]);
        }
        this.menu_bar.add(jMenu);
        return jMenu;
    }

    @Override
    public void macosx_file_handler(String string) {
        TeleGPS.process_graph(new File(string));
    }

    @Override
    public void macosx_quit_handler() {
        System.exit(0);
    }

    @Override
    public void macosx_preferences_handler() {
        this.preferences();
    }

    public TeleGPS() {
        AltosUIPreferences.set_component(this);
        this.register_for_macosx_events();
        this.reader = null;
        this.bag = this.getContentPane();
        this.bag.setLayout(new GridBagLayout());
        this.setTitle("TeleGPS");
        this.menu_bar = new JMenuBar();
        this.setJMenuBar(this.menu_bar);
        this.file_menu = this.make_menu("File", file_menu_entries);
        this.monitor_menu = this.make_menu("Monitor", monitor_menu_entries);
        this.device_menu = this.make_menu("Device", device_menu_entries);
        this.set_inset(3);
        this.frequencies = new AltosUIFreqList();
        this.frequencies.setEnabled(false);
        this.bag.add((Component)this.frequencies, this.constraints(0, 1));
        this.rates = new AltosUIRateList();
        this.rates.setEnabled(false);
        this.bag.add((Component)this.rates, this.constraints(1, 1));
        this.next_row();
        this.set_inset(0);
        this.displays = new LinkedList();
        int n = -1;
        this.telegps_status = new TeleGPSStatus();
        this.bag.add((Component)this.telegps_status, this.constraints(0, 3, 2));
        this.next_row();
        this.displays.add(this.telegps_status);
        this.pane = new JTabbedPane();
        this.bag.add((Component)this.pane, this.constraints(0, 3, 1));
        this.map = new AltosUIMap();
        this.pane.add(this.map.getName(), this.map);
        this.displays.add(this.map);
        this.gps_info = new TeleGPSInfo();
        this.pane.add(this.gps_info.getName(), this.gps_info);
        this.displays.add(this.gps_info);
        this.gps_state = new TeleGPSState();
        this.pane.add(this.gps_state.getName(), this.gps_state);
        this.displays.add(this.gps_state);
        this.info_table = new AltosInfoTable();
        this.pane.add("Table", this.info_table);
        this.displays.add(this.info_table);
        this.setDefaultCloseOperation(0);
        AltosUIPreferences.register_font_listener(this);
        AltosPreferences.register_units_listener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                TeleGPS.this.close();
            }
        });
        this.pack();
        this.setVisible(true);
        TeleGPS.add_window();
    }

    public TeleGPS(AltosFlightReader altosFlightReader, boolean bl) {
        this();
        this.set_reader(altosFlightReader, null, bl);
    }

    public TeleGPS(AltosDevice altosDevice) {
        this();
        this.connect(altosDevice);
    }

    static AltosRecordSet record_set(File file) {
        try {
            return AltosLib.record_set(file);
        }
        catch (IOException iOException) {
            System.out.printf("%s\n", iOException.getMessage());
            return null;
        }
    }

    static AltosReplayReader replay_file(File file) {
        AltosRecordSet altosRecordSet = TeleGPS.record_set(file);
        if (altosRecordSet == null) {
            return null;
        }
        return new AltosReplayReader(altosRecordSet, file);
    }

    private static boolean graph_file(TeleGPS teleGPS, AltosRecordSet altosRecordSet, File file) {
        if (altosRecordSet == null) {
            return false;
        }
        if (!altosRecordSet.valid()) {
            JOptionPane.showMessageDialog(teleGPS, String.format("Failed to parse file %s", file), "Graph Failed", 0);
            return false;
        }
        try {
            new TeleGPSGraphUI(altosRecordSet, file);
        }
        catch (IOException iOException) {
            System.out.printf("Exception %s\n", iOException.toString());
        }
        catch (InterruptedException interruptedException) {
            System.out.printf("Exception %s\n", interruptedException.toString());
            return false;
        }
        return true;
    }

    static boolean process_graph(File file) {
        AltosRecordSet altosRecordSet = TeleGPS.record_set(file);
        return TeleGPS.graph_file(null, altosRecordSet, file);
    }

    static boolean process_replay(File file) {
        AltosReplayReader altosReplayReader = TeleGPS.replay_file(file);
        if (altosReplayReader == null) {
            return false;
        }
        new TeleGPS(altosReplayReader, true);
        return true;
    }

    public static boolean load_library(Frame frame) {
        if (!AltosUILib.load_library()) {
            JOptionPane.showMessageDialog(frame, String.format("No AltOS library in \"%s\"", System.getProperty("java.library.path", "<undefined>")), "Cannot load device access library", 0);
            return false;
        }
        return true;
    }

    public static void help(int n) {
        System.out.printf("Usage: altosui [OPTION]... [FILE]...\n", new Object[0]);
        System.out.printf("  Options:\n", new Object[0]);
        System.out.printf("    --replay <filename>\t\trelive the glory of past flights \n", new Object[0]);
        System.out.printf("    --graph <filename>\t\tgraph a flight\n", new Object[0]);
        System.out.printf("    --csv\tgenerate comma separated output for spreadsheets, etc\n", new Object[0]);
        System.out.printf("    --kml\tgenerate KML output for use with Google Earth\n", new Object[0]);
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        TeleGPS.load_library(null);
        try {
            UIManager.setLookAndFeel(AltosUIPreferences.look_and_feel());
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = false;
        int n2 = 0;
        block10: for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("--help")) {
                TeleGPS.help(0);
                continue;
            }
            if (stringArray[i].equals("--replay")) {
                n2 = 4;
                continue;
            }
            if (stringArray[i].equals("--kml")) {
                n2 = 2;
                continue;
            }
            if (stringArray[i].equals("--csv")) {
                n2 = 1;
                continue;
            }
            if (stringArray[i].equals("--graph")) {
                n2 = 3;
                continue;
            }
            if (stringArray[i].equals("--summary")) {
                n2 = 5;
                continue;
            }
            if (stringArray[i].equals("--cat")) {
                n2 = 6;
                continue;
            }
            if (stringArray[i].startsWith("--")) {
                TeleGPS.help(1);
                continue;
            }
            File file = new File(stringArray[i]);
            switch (n2) {
                case 0: 
                case 3: {
                    if (TeleGPS.process_graph(file)) continue block10;
                    ++n;
                    continue block10;
                }
                case 4: {
                    if (!TeleGPS.process_replay(file)) {
                        ++n;
                    }
                    bl = true;
                    continue block10;
                }
                case 2: {
                    ++n;
                    continue block10;
                }
                case 1: {
                    ++n;
                    continue block10;
                }
                case 5: {
                    ++n;
                    continue block10;
                }
                case 6: {
                    ++n;
                }
            }
        }
        if (n != 0) {
            System.exit(n);
        }
        if (number_of_windows == 0) {
            List<AltosDevice> list = AltosUSBDevice.list(65537);
            if (list != null) {
                for (AltosDevice altosDevice : list) {
                    new TeleGPS(altosDevice);
                    bl = true;
                }
            }
            if (number_of_windows == 0) {
                new TeleGPS();
            }
        }
    }

    static {
        TeleGPS.set_icon_names(telegps_icon_names);
        file_menu_entries = new String[][]{{"New Window", new_command}, {"Graph Data", graph_command}, {"Export Data", export_command}, {"Load Maps", load_maps_command}, {"Preferences", preferences_command}, {"Close", close_command}, {"Exit", exit_command}};
        monitor_menu_entries = new String[][]{{"Connect Device", connect_command}, {"Disconnect", disconnect_command}, {"Scan Channels", scan_command}};
        device_menu_entries = new String[][]{{"Download Data", download_command}, {"Configure Device", configure_command}, {"Flash Device", flash_command}};
    }
}

