/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosCalData;
import org.altusmetrum.altoslib_14.AltosFlightReader;
import org.altusmetrum.altoslib_14.AltosLine;
import org.altusmetrum.altoslib_14.AltosLink;
import org.altusmetrum.altoslib_14.AltosLog;
import org.altusmetrum.altoslib_14.AltosPreferences;
import org.altusmetrum.altoslib_14.AltosState;
import org.altusmetrum.altoslib_14.AltosTelemetry;

public class AltosTelemetryReader
extends AltosFlightReader {
    AltosLink link;
    AltosLog log;
    double frequency;
    int telemetry;
    int telemetry_rate;
    private AltosState state = null;
    private AltosCalData cal_data = null;
    LinkedBlockingQueue<AltosLine> telem;

    @Override
    public AltosState read() throws InterruptedException, ParseException, AltosCRCException, IOException {
        AltosLine altosLine;
        do {
            altosLine = this.telem.take();
            if (altosLine.line != null) continue;
            throw new IOException("IO error");
        } while (!this.link.get_monitor());
        AltosTelemetry altosTelemetry = AltosTelemetry.parse(altosLine.line);
        if (this.state == null) {
            this.state = new AltosState(this.cal_data());
        }
        altosTelemetry.provide_data(this.state);
        return this.state;
    }

    @Override
    public AltosCalData cal_data() {
        if (this.cal_data == null) {
            this.cal_data = new AltosCalData();
        }
        return this.cal_data;
    }

    public void flush() {
        this.telem.clear();
    }

    public void reset() {
        this.flush();
        this.state = null;
        this.cal_data = null;
    }

    @Override
    public void close(boolean bl) {
        this.link.remove_monitor(this.telem);
        this.log.close();
        try {
            this.link.close();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void set_frequency(double d) throws InterruptedException, TimeoutException {
        this.frequency = d;
        this.link.set_radio_frequency(this.frequency);
    }

    @Override
    public boolean supports_telemetry(int n) {
        try {
            if (this.link.config_data().compare_version("1.0") >= 0) {
                return true;
            }
            if (this.link.config_data().compare_version("0.9") >= 0) {
                return n == 2;
            }
            return n == 3;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (TimeoutException timeoutException) {
            return true;
        }
    }

    @Override
    public boolean supports_telemetry_rate(int n) {
        try {
            if (this.link.config_data().compare_version("1.4.1.1") >= 0) {
                return true;
            }
            return n == 0;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (TimeoutException timeoutException) {
            return true;
        }
    }

    @Override
    public void save_frequency() {
        AltosPreferences.set_frequency(this.link.serial, this.frequency);
    }

    @Override
    public void set_telemetry(int n) {
        this.telemetry = n;
        this.link.set_telemetry(this.telemetry);
    }

    @Override
    public void save_telemetry() {
        AltosPreferences.set_telemetry(this.link.serial, this.telemetry);
    }

    @Override
    public void set_telemetry_rate(int n) {
        this.telemetry_rate = n;
        this.link.set_telemetry_rate(this.telemetry_rate);
    }

    @Override
    public void save_telemetry_rate() {
        AltosPreferences.set_telemetry_rate(this.link.serial, this.telemetry_rate);
    }

    public void set_monitor(boolean bl) {
        this.link.set_monitor(bl);
    }

    @Override
    public File backing_file() {
        return this.log.file();
    }

    @Override
    public boolean has_monitor_battery() {
        return this.link.has_monitor_battery();
    }

    @Override
    public double monitor_battery() throws InterruptedException {
        return this.link.monitor_battery();
    }

    public AltosTelemetryReader(AltosLink altosLink) throws IOException, InterruptedException, TimeoutException {
        this.link = altosLink;
        boolean bl = false;
        try {
            this.log = new AltosLog(this.link);
            this.name = this.link.name;
            this.telem = new LinkedBlockingQueue();
            this.frequency = AltosPreferences.frequency(this.link.serial);
            this.set_frequency(this.frequency);
            this.telemetry = AltosPreferences.telemetry(this.link.serial);
            this.set_telemetry(this.telemetry);
            this.telemetry_rate = AltosPreferences.telemetry_rate(this.link.serial);
            this.set_telemetry_rate(this.telemetry_rate);
            this.link.add_monitor(this.telem);
            bl = true;
        }
        finally {
            if (!bl) {
                this.close(true);
            }
        }
    }
}

