/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

import org.altusmetrum.altoslib_14.AltosCRCException;
import org.altusmetrum.altoslib_14.AltosConvert;
import org.altusmetrum.altoslib_14.AltosDataListener;
import org.altusmetrum.altoslib_14.AltosTelemetryStandard;

public class AltosTelemetryMetrumSensor
extends AltosTelemetryStandard {
    int state() {
        return this.uint8(5);
    }

    int accel() {
        return this.int16(6);
    }

    int pres() {
        return this.int32(8);
    }

    int temp() {
        return this.int16(12);
    }

    int acceleration() {
        return this.int16(14);
    }

    int speed() {
        return this.int16(16);
    }

    int height_16() {
        return this.int16(18);
    }

    int v_batt() {
        return this.int16(20);
    }

    int sense_a() {
        return this.int16(22);
    }

    int sense_m() {
        return this.int16(24);
    }

    public AltosTelemetryMetrumSensor(int[] nArray) throws AltosCRCException {
        super(nArray);
    }

    @Override
    public void provide_data(AltosDataListener altosDataListener) {
        super.provide_data(altosDataListener);
        altosDataListener.set_state(this.state());
        altosDataListener.set_acceleration(altosDataListener.cal_data().acceleration(this.accel()));
        altosDataListener.set_pressure(this.pres());
        altosDataListener.set_temperature((double)this.temp() / 100.0);
        altosDataListener.set_kalman(this.height_16(), (double)this.speed() / 16.0, (double)this.acceleration() / 16.0);
        altosDataListener.set_battery_voltage(AltosConvert.mega_battery_voltage(this.v_batt()));
        altosDataListener.set_apogee_voltage(AltosConvert.mega_pyro_voltage(this.sense_a()));
        altosDataListener.set_main_voltage(AltosConvert.mega_pyro_voltage(this.sense_m()));
    }
}

