/*
 * Decompiled with CFR 0.152.
 */
package org.altusmetrum.altoslib_14;

public class AltosQuaternion {
    double r;
    double x;
    double y;
    double z;

    public AltosQuaternion multiply(AltosQuaternion altosQuaternion) {
        return new AltosQuaternion(this.r * altosQuaternion.r - this.x * altosQuaternion.x - this.y * altosQuaternion.y - this.z * altosQuaternion.z, this.r * altosQuaternion.x + this.x * altosQuaternion.r + this.y * altosQuaternion.z - this.z * altosQuaternion.y, this.r * altosQuaternion.y - this.x * altosQuaternion.z + this.y * altosQuaternion.r + this.z * altosQuaternion.x, this.r * altosQuaternion.z + this.x * altosQuaternion.y - this.y * altosQuaternion.x + this.z * altosQuaternion.r);
    }

    public AltosQuaternion conjugate() {
        return new AltosQuaternion(this.r, -this.x, -this.y, -this.z);
    }

    public double normal() {
        return Math.sqrt(this.r * this.r + this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public AltosQuaternion scale(double d) {
        return new AltosQuaternion(this.r * d, this.x * d, this.y * d, this.z * d);
    }

    public AltosQuaternion normalize() {
        double d = this.normal();
        if (d <= 0.0) {
            return this;
        }
        return this.scale(1.0 / d);
    }

    public double dot(AltosQuaternion altosQuaternion) {
        return this.r * altosQuaternion.r + this.x * altosQuaternion.x + this.y * altosQuaternion.y + this.z * altosQuaternion.z;
    }

    public AltosQuaternion rotate(AltosQuaternion altosQuaternion) {
        return altosQuaternion.multiply(this).multiply(altosQuaternion.conjugate());
    }

    public AltosQuaternion vectors_to_rotation(AltosQuaternion altosQuaternion) {
        double d = this.y * altosQuaternion.z - this.z * altosQuaternion.y;
        double d2 = this.z * altosQuaternion.x - this.x * altosQuaternion.z;
        double d3 = this.x * altosQuaternion.y - this.y * altosQuaternion.x;
        double d4 = d * d + d2 * d2 + d3 * d3;
        double d5 = Math.sqrt(d4);
        double d6 = this.x * altosQuaternion.x + this.y * altosQuaternion.y + this.z * altosQuaternion.z;
        double d7 = Math.sqrt((1.0 + d6) / 2.0);
        double d8 = Math.sqrt((1.0 - d6) / 2.0);
        double d9 = d8 / d5;
        AltosQuaternion altosQuaternion2 = new AltosQuaternion(d7, d * d9, d2 * d9, d3 * d9);
        return altosQuaternion2.normalize();
    }

    public AltosQuaternion(double d, double d2, double d3, double d4) {
        this.r = d;
        this.x = d2;
        this.y = d3;
        this.z = d4;
    }

    public AltosQuaternion(AltosQuaternion altosQuaternion) {
        this.r = altosQuaternion.r;
        this.x = altosQuaternion.x;
        this.y = altosQuaternion.y;
        this.z = altosQuaternion.z;
    }

    public AltosQuaternion() {
        this.r = 1.0;
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
    }

    public static AltosQuaternion vector(double d, double d2, double d3) {
        return new AltosQuaternion(0.0, d, d2, d3);
    }

    public static AltosQuaternion rotation(double d, double d2, double d3, double d4, double d5) {
        return new AltosQuaternion(d5, d4 * d, d4 * d2, d4 * d3);
    }

    public static AltosQuaternion zero_rotation() {
        return new AltosQuaternion(1.0, 0.0, 0.0, 0.0);
    }

    public static AltosQuaternion euler(double d, double d2, double d3) {
        double d4 = Math.sin(d /= 2.0);
        double d5 = Math.cos(d);
        double d6 = Math.sin(d2 /= 2.0);
        double d7 = Math.cos(d2);
        double d8 = Math.sin(d3 /= 2.0);
        double d9 = Math.cos(d3);
        return new AltosQuaternion(d5 * d7 * d9 + d4 * d6 * d8, d4 * d7 * d9 - d5 * d6 * d8, d5 * d6 * d9 + d4 * d7 * d8, d5 * d7 * d8 - d4 * d6 * d9);
    }
}

